/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQLineQty;
import org.compiere.model.MRfQResponse;
import org.compiere.model.X_C_RfQ;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class MRfQ
extends X_C_RfQ {
    private static CCache<Integer, MRfQ> s_cache = new CCache("C_RfQ", 10);

    public static MRfQ get(Ctx ctx, int C_RfQ_ID, String trxName) {
        Integer key = new Integer(C_RfQ_ID);
        MRfQ retValue = (MRfQ)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MRfQ(ctx, C_RfQ_ID, trxName);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MRfQ(Ctx ctx, int C_RfQ_ID, String trxName) {
        super(ctx, C_RfQ_ID, trxName);
        if (C_RfQ_ID == 0) {
            this.setDateResponse(new Timestamp(System.currentTimeMillis()));
            this.setDateWorkStart(new Timestamp(System.currentTimeMillis()));
            this.setIsInvitedVendorsOnly(false);
            this.setQuoteType("S");
            this.setIsQuoteAllQty(false);
            this.setIsQuoteTotalAmt(false);
            this.setIsRfQResponseAccepted(true);
            this.setIsSelfService(true);
            this.setProcessed(false);
        }
    }

    public MRfQ(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRfQLine[] getLines() {
        ArrayList<MRfQLine> list = new ArrayList<MRfQLine>();
        String sql = "SELECT * FROM C_RfQLine WHERE C_RfQ_ID=? AND IsActive='Y' ORDER BY Line";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_RfQ_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRfQLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MRfQLine[] retValue = new MRfQLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MRfQResponse[] getResponses(boolean activeOnly, boolean completedOnly) {
        ArrayList<MRfQResponse> list = new ArrayList<MRfQResponse>();
        String sql = "SELECT * FROM C_RfQResponse WHERE C_RfQ_ID=?";
        if (activeOnly) {
            sql = sql + " AND IsActive='Y'";
        }
        if (completedOnly) {
            sql = sql + " AND IsComplete='Y'";
        }
        sql = sql + " ORDER BY Price";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_RfQ_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRfQResponse(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MRfQResponse[] retValue = new MRfQResponse[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MRfQ[");
        sb.append(this.get_ID()).append(",Name=").append(this.getName()).append(",QuoteType=").append(this.getQuoteType()).append("]");
        return sb.toString();
    }

    public boolean isQuoteTotalAmtOnly() {
        return "T".equals(this.getQuoteType());
    }

    public boolean isQuoteSelectedLines() {
        return "S".equals(this.getQuoteType());
    }

    public boolean isQuoteAllLines() {
        return "A".equals(this.getQuoteType());
    }

    public String checkQuoteTotalAmtOnly() {
        if (!this.isQuoteTotalAmtOnly()) {
            return null;
        }
        MRfQLine[] lines = this.getLines();
        for (int i = 0; i < lines.length; ++i) {
            MRfQLine line = lines[i];
            MRfQLineQty[] qtys = line.getQtys();
            if (qtys.length <= 1) continue;
            this.log.warning("isQuoteTotalAmtOnlyValid - #" + qtys.length + " - " + (Object)((Object)line));
            String msg = "@Line@ " + line.getLine() + ": #@C_RfQLineQty@=" + qtys.length + " - @IsQuoteTotalAmt@";
            return msg;
        }
        return null;
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateWorkStart() != null && this.getDeliveryDays() != 0) {
            this.setDateWorkComplete(TimeUtil.addDays((Timestamp)this.getDateWorkStart(), (int)this.getDeliveryDays()));
        } else if (this.getDateWorkStart() != null && this.getDeliveryDays() == 0 && this.getDateWorkComplete() != null) {
            this.setDeliveryDays(TimeUtil.getDaysBetween((Timestamp)this.getDateWorkStart(), (Timestamp)this.getDateWorkComplete()));
        } else if (this.getDateWorkStart() == null && this.getDeliveryDays() != 0 && this.getDateWorkComplete() != null) {
            this.setDateWorkStart(TimeUtil.addDays((Timestamp)this.getDateWorkComplete(), (int)(this.getDeliveryDays() * -1)));
        }
        return true;
    }
}

