/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MRfQLine;
import org.compiere.model.MRfQResponseLineQty;
import org.compiere.model.MUOM;
import org.compiere.model.X_C_RfQLineQty;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MRfQLineQty
extends X_C_RfQLineQty {
    private static CCache<Integer, MRfQLineQty> s_cache = new CCache("C_RfQLineQty", 20);
    private MUOM m_uom = null;

    public static MRfQLineQty get(Ctx ctx, int C_RfQLineQty_ID, String trxName) {
        Integer key = new Integer(C_RfQLineQty_ID);
        MRfQLineQty retValue = (MRfQLineQty)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MRfQLineQty(ctx, C_RfQLineQty_ID, trxName);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MRfQLineQty(Ctx ctx, int C_RfQLineQty_ID, String trxName) {
        super(ctx, C_RfQLineQty_ID, trxName);
        if (C_RfQLineQty_ID == 0) {
            this.setIsOfferQty(false);
            this.setIsPurchaseQty(false);
            this.setQty(Env.ONE);
        }
    }

    public MRfQLineQty(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        if (this.get_ID() > 0) {
            s_cache.put((Object)new Integer(this.get_ID()), (Object)this);
        }
    }

    public MRfQLineQty(MRfQLine line) {
        this(line.getCtx(), 0, line.get_TrxName());
        this.setClientOrg((PO)line);
        this.setC_RfQLine_ID(line.getC_RfQLine_ID());
    }

    public String getUomName() {
        if (this.m_uom == null) {
            this.m_uom = MUOM.get(this.getCtx(), this.getC_UOM_ID());
        }
        return this.m_uom.getName();
    }

    public MRfQResponseLineQty[] getResponseQtys(boolean onlyValidAmounts) {
        ArrayList<MRfQResponseLineQty> list = new ArrayList<MRfQResponseLineQty>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM C_RfQResponseLineQty WHERE C_RfQLineQty_ID=? AND IsActive='Y'";
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getC_RfQLineQty_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MRfQResponseLineQty qty = new MRfQResponseLineQty(this.getCtx(), rs, this.get_TrxName());
                if (onlyValidAmounts && !qty.isValidAmt()) continue;
                list.add(qty);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MRfQResponseLineQty[] retValue = new MRfQResponseLineQty[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MRfQLineQty[");
        sb.append(this.get_ID()).append(",Qty=").append(this.getQty()).append(",Offer=").append(this.isOfferQty()).append(",Purchase=").append(this.isPurchaseQty()).append("]");
        return sb.toString();
    }
}

