/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.CompiereProcessor;
import org.compiere.model.CompiereProcessorLog;
import org.compiere.model.MAttachment;
import org.compiere.model.MNote;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MSchedulerLog;
import org.compiere.model.MSchedulerPara;
import org.compiere.model.MSchedulerRecipient;
import org.compiere.model.MUserRoles;
import org.compiere.model.X_AD_Scheduler;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Trx;

public class MScheduler
extends X_AD_Scheduler
implements CompiereProcessor {
    private static CLogger s_log = CLogger.getCLogger(MScheduler.class);
    private MProcess m_process = null;
    private MSchedulerPara[] m_parameter = null;
    private MSchedulerRecipient[] m_recipients = null;

    public static MScheduler[] getActive(Ctx ctx) {
        ArrayList<MScheduler> list = new ArrayList<MScheduler>();
        String sql = "SELECT * FROM AD_Scheduler WHERE IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MScheduler(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MScheduler[] retValue = new MScheduler[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MScheduler(Ctx ctx, int AD_Scheduler_ID, String trxName) {
        super(ctx, AD_Scheduler_ID, trxName);
        if (AD_Scheduler_ID == 0) {
            this.setFrequencyType("D");
            this.setFrequency(1);
            this.setKeepLogDays(7);
        }
    }

    public MScheduler(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getServerID() {
        return "Scheduler" + this.get_ID();
    }

    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName());
        }
        return this.getDateNextRun();
    }

    public CompiereProcessorLog[] getLogs() {
        ArrayList<MSchedulerLog> list = new ArrayList<MSchedulerLog>();
        String sql = "SELECT * FROM AD_SchedulerLog WHERE AD_Scheduler_ID=? ORDER BY Created DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getAD_Scheduler_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MSchedulerLog(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        CompiereProcessorLog[] retValue = new MSchedulerLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE FROM AD_SchedulerLog WHERE AD_Scheduler_ID=" + this.getAD_Scheduler_ID() + " AND (Created+" + this.getKeepLogDays() + ") < SysDate";
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        return no;
    }

    public MProcess getProcess() {
        if (this.m_process == null) {
            this.m_process = new MProcess(this.getCtx(), this.getAD_Process_ID(), null);
        }
        return this.m_process;
    }

    public MSchedulerPara[] getParameters(boolean reload) {
        if (!reload && this.m_parameter != null) {
            return this.m_parameter;
        }
        ArrayList<MSchedulerPara> list = new ArrayList<MSchedulerPara>();
        String sql = "SELECT * FROM AD_Scheduler_Para WHERE AD_Scheduler_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.getAD_Scheduler_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MSchedulerPara(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_parameter = new MSchedulerPara[list.size()];
        list.toArray(this.m_parameter);
        return this.m_parameter;
    }

    public MSchedulerRecipient[] getRecipients(boolean reload) {
        if (!reload && this.m_recipients != null) {
            return this.m_recipients;
        }
        ArrayList<MSchedulerRecipient> list = new ArrayList<MSchedulerRecipient>();
        String sql = "SELECT * FROM AD_SchedulerRecipient WHERE AD_Scheduler_ID=? AND IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.getAD_Scheduler_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MSchedulerRecipient(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_recipients = new MSchedulerRecipient[list.size()];
        list.toArray(this.m_recipients);
        return this.m_recipients;
    }

    public Integer[] getRecipientAD_User_IDs() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        MSchedulerRecipient[] recipients = this.getRecipients(false);
        for (int i = 0; i < recipients.length; ++i) {
            Integer ii;
            MSchedulerRecipient recipient = recipients[i];
            if (!recipient.isActive()) continue;
            if (recipient.getAD_User_ID() != 0 && !list.contains(ii = new Integer(recipient.getAD_User_ID()))) {
                list.add(ii);
            }
            if (recipient.getAD_Role_ID() == 0) continue;
            MUserRoles[] urs = MUserRoles.getOfRole((Ctx)this.getCtx(), (int)recipient.getAD_Role_ID());
            for (int j = 0; j < urs.length; ++j) {
                Integer ii2;
                MUserRoles ur = urs[j];
                if (!ur.isActive() || list.contains(ii2 = new Integer(ur.getAD_User_ID()))) continue;
                list.add(ii2);
            }
        }
        if (list.size() == 0) {
            Integer ii = new Integer(this.getUpdatedBy());
            list.add(ii);
        }
        Integer[] recipientIDs = new Integer[list.size()];
        list.toArray(recipientIDs);
        return recipientIDs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MScheduler[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }

    public String execute(Trx trx) throws Exception {
        this.getProcess();
        if (this.m_process.isReport()) {
            return this.runReport(trx);
        }
        return this.runProcess(trx);
    }

    private String runReport(Trx trx) throws Exception {
        this.log.info(this.m_process.toString());
        if (!this.m_process.isReport() || this.m_process.getAD_ReportView_ID() == 0) {
            return "Not a Report AD_Process_ID=" + this.m_process.getAD_Process_ID() + " - " + this.m_process.getName();
        }
        int AD_Table_ID = 0;
        int Record_ID = 0;
        MPInstance pInstance = new MPInstance(this.m_process, Record_ID);
        this.fillParameter(pInstance);
        ProcessInfo pi = new ProcessInfo(this.m_process.getName(), this.m_process.getAD_Process_ID(), AD_Table_ID, Record_ID);
        pi.setAD_User_ID(this.getUpdatedBy());
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        if (!this.m_process.processIt(pi, trx) && pi.getClassName() != null) {
            return "Process failed: (" + pi.getClassName() + ") " + pi.getSummary();
        }
        ReportEngine re = ReportEngine.get((Ctx)this.getCtx(), (ProcessInfo)pi);
        if (re == null) {
            return "Cannot create Report AD_Process_ID=" + this.m_process.getAD_Process_ID() + " - " + this.m_process.getName();
        }
        File report = re.getPDF();
        int AD_Message_ID = 884;
        Integer[] userIDs = this.getRecipientAD_User_IDs();
        for (int i = 0; i < userIDs.length; ++i) {
            MNote note = new MNote(this.getCtx(), AD_Message_ID, userIDs[i].intValue(), trx.getTrxName());
            note.setClientOrg(this.getAD_Client_ID(), this.getAD_Org_ID());
            note.setTextMsg(this.getName());
            note.setDescription(this.getDescription());
            note.setRecord(AD_Table_ID, Record_ID);
            note.save();
            MAttachment attachment = new MAttachment(this.getCtx(), 389, note.getAD_Note_ID(), trx.getTrxName());
            attachment.setClientOrg(this.getAD_Client_ID(), this.getAD_Org_ID());
            attachment.addEntry(report);
            attachment.setTextMsg(this.getName());
            attachment.save();
        }
        return pi.getSummary();
    }

    private String runProcess(Trx trx) throws Exception {
        this.log.info(this.m_process.toString());
        int AD_Table_ID = 0;
        int Record_ID = 0;
        MPInstance pInstance = new MPInstance(this.m_process, Record_ID);
        this.fillParameter(pInstance);
        ProcessInfo pi = new ProcessInfo(this.m_process.getName(), this.m_process.getAD_Process_ID(), AD_Table_ID, Record_ID);
        pi.setAD_User_ID(this.getUpdatedBy());
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        this.m_process.processIt(pi, trx);
        return pi.getSummary();
    }

    private void fillParameter(MPInstance pInstance) {
        MSchedulerPara[] sParams = this.getParameters(false);
        MPInstancePara[] iParams = pInstance.getParameters();
        block2: for (int pi = 0; pi < iParams.length; ++pi) {
            MPInstancePara iPara = iParams[pi];
            for (int np = 0; np < sParams.length; ++np) {
                MSchedulerPara sPara = sParams[np];
                if (!iPara.getParameterName().equals(sPara.getColumnName())) continue;
                String variable = sPara.getParameterDefault();
                this.log.fine(sPara.getColumnName() + " = " + variable);
                String value = variable;
                if (variable == null || variable != null && variable.length() == 0) {
                    value = null;
                } else if (variable.indexOf("@") != -1) {
                    int index = variable.indexOf("@");
                    String columnName = variable.substring(index + 1);
                    if ((index = columnName.indexOf("@")) != -1) {
                        columnName = columnName.substring(0, index);
                        String env = this.getCtx().getContext(columnName);
                        if (env.length() == 0) {
                            this.log.warning(sPara.getColumnName() + " - not in environment =" + columnName + "(" + variable + ") - ignored");
                            continue block2;
                        }
                        value = env;
                    }
                }
                if (value == null) {
                    this.log.fine(sPara.getColumnName() + " - empty");
                    continue block2;
                }
                try {
                    if (DisplayType.isNumeric((int)sPara.getDisplayType()) || DisplayType.isID((int)sPara.getDisplayType())) {
                        BigDecimal bd = null;
                        bd = value instanceof BigDecimal ? (BigDecimal)((Object)value) : (value instanceof Integer ? new BigDecimal((Integer)((Object)value)) : new BigDecimal(value.toString()));
                        iPara.setP_Number(bd);
                        this.log.fine(sPara.getColumnName() + " = " + variable + " (=" + bd + "=)");
                    } else if (DisplayType.isDate((int)sPara.getDisplayType())) {
                        Timestamp ts = null;
                        ts = value instanceof Timestamp ? (Timestamp)((Object)value) : Timestamp.valueOf(value.toString());
                        iPara.setP_Date(ts);
                        this.log.fine(sPara.getColumnName() + " = " + variable + " (=" + ts + "=)");
                    } else {
                        iPara.setP_String(value.toString());
                        this.log.fine(sPara.getColumnName() + " = " + variable + " (=" + value + "=) " + value.getClass().getName());
                    }
                    if (iPara.save()) continue block2;
                    this.log.warning("Not Saved - " + sPara.getColumnName());
                }
                catch (Exception e) {
                    this.log.warning(sPara.getColumnName() + " = " + variable + " (" + value + ") " + value.getClass().getName() + " - " + e.getLocalizedMessage());
                }
                continue block2;
            }
        }
    }
}

