/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.X_R_Status;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MStatus
extends X_R_Status {
    private static CLogger s_log = CLogger.getCLogger(MStatus.class);
    private static CCache<Integer, MStatus> s_cache = new CCache("R_Status", 10);
    private static CCache<Integer, MStatus> s_cacheDefault = new CCache("R_Status", 10);

    public static MStatus get(Ctx ctx, int R_Status_ID) {
        if (R_Status_ID == 0) {
            return null;
        }
        Integer key = new Integer(R_Status_ID);
        MStatus retValue = (MStatus)((Object)s_cache.get((Object)key));
        if (retValue == null) {
            retValue = new MStatus(ctx, R_Status_ID, null);
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public static MStatus getDefault(Ctx ctx, int R_RequestType_ID) {
        Integer key = new Integer(R_RequestType_ID);
        MStatus retValue = (MStatus)((Object)s_cacheDefault.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        String sql = "SELECT * FROM R_Status s WHERE EXISTS (SELECT * FROM R_RequestType rt WHERE rt.R_StatusCategory_ID=s.R_StatusCategory_ID AND rt.R_RequestType_ID=?) AND IsDefault='Y' ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, R_RequestType_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MStatus(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (retValue != null) {
            s_cacheDefault.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public static MStatus[] getClosed(Ctx ctx) {
        int AD_Client_ID = ctx.getAD_Client_ID();
        String sql = "SELECT * FROM R_Status WHERE AD_Client_ID=? AND IsActive='Y' AND IsClosed='Y' ORDER BY Value";
        ArrayList<MStatus> list = new ArrayList<MStatus>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                list.add(new MStatus(ctx, rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            s_log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        MStatus[] retValue = new MStatus[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MStatus(Ctx ctx, int R_Status_ID, String trxName) {
        super(ctx, R_Status_ID, trxName);
        if (R_Status_ID == 0) {
            this.setIsClosed(false);
            this.setIsDefault(false);
            this.setIsFinalClose(false);
            this.setIsOpen(false);
            this.setIsWebCanUpdate(true);
        }
    }

    public MStatus(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    protected boolean beforeSave(boolean newRecord) {
        if (this.isOpen() && this.isClosed()) {
            this.setIsClosed(false);
        }
        if (this.isFinalClose() && !this.isClosed()) {
            this.setIsFinalClose(false);
        }
        if (!this.isWebCanUpdate() && this.getUpdate_Status_ID() != 0) {
            this.setUpdate_Status_ID(0);
        }
        if (this.getTimeoutDays() == 0 && this.getNext_Status_ID() != 0) {
            this.setNext_Status_ID(0);
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MStatus[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

