/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MStatus;
import org.compiere.model.X_R_StatusCategory;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MStatusCategory
extends X_R_StatusCategory {
    private static CCache<Integer, MStatusCategory> s_cache = new CCache("R_StatusCategory", 20);
    private static CLogger s_log = CLogger.getCLogger(MStatusCategory.class);
    private MStatus[] m_status = null;

    public static MStatusCategory getDefault(Ctx ctx) {
        int AD_Client_ID = ctx.getAD_Client_ID();
        String sql = "SELECT * FROM R_StatusCategory WHERE AD_Client_ID in (0,?) AND IsDefault='Y' ORDER BY AD_Client_ID DESC";
        MStatusCategory retValue = null;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, AD_Client_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = new MStatusCategory(ctx, rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return retValue;
    }

    public static MStatusCategory createDefault(Ctx ctx) {
        int AD_Client_ID = ctx.getAD_Client_ID();
        MStatusCategory retValue = new MStatusCategory(ctx, 0, null);
        retValue.setClientOrg(AD_Client_ID, 0);
        retValue.setName(Msg.getMsg((Ctx)ctx, (String)"Standard"));
        retValue.setIsDefault(true);
        if (!retValue.save()) {
            return null;
        }
        String sql = "UPDATE R_Status SET R_StatusCategory_ID=" + retValue.getR_StatusCategory_ID() + " WHERE R_StatusCategory_ID IS NULL AND AD_Client_ID=" + AD_Client_ID;
        int no = DB.executeUpdate((String)sql, null);
        s_log.info("Default for AD_Client_ID=" + AD_Client_ID + " - Status #" + no);
        return retValue;
    }

    public static MStatusCategory get(Ctx ctx, int R_StatusCategory_ID) {
        Integer key = new Integer(R_StatusCategory_ID);
        MStatusCategory retValue = (MStatusCategory)((Object)s_cache.get((Object)key));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MStatusCategory(ctx, R_StatusCategory_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put((Object)key, (Object)retValue);
        }
        return retValue;
    }

    public MStatusCategory(Ctx ctx, int R_StatusCategory_ID, String trxName) {
        super(ctx, R_StatusCategory_ID, trxName);
        if (R_StatusCategory_ID == 0) {
            this.setIsDefault(false);
        }
    }

    public MStatusCategory(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MStatus[] getStatus(boolean reload) {
        if (this.m_status != null && !reload) {
            return this.m_status;
        }
        String sql = "SELECT * FROM R_Status WHERE R_StatusCategory_ID=? ORDER BY SeqNo";
        ArrayList<MStatus> list = new ArrayList<MStatus>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.getR_StatusCategory_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MStatus(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_status = new MStatus[list.size()];
        list.toArray(this.m_status);
        return this.m_status;
    }

    public int getDefaultR_Status_ID() {
        if (this.m_status == null) {
            this.getStatus(false);
        }
        for (int i = 0; i < this.m_status.length; ++i) {
            if (!this.m_status[i].isDefault() || !this.m_status[i].isActive()) continue;
            return this.m_status[i].getR_Status_ID();
        }
        if (this.m_status.length > 0 && this.m_status[0].isActive()) {
            return this.m_status[0].getR_Status_ID();
        }
        return 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RStatusCategory[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

