/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.model.X_C_UOM;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Ini;

public class MUOM
extends X_C_UOM {
    static final String X12_MINUTE = "MJ";
    static final String X12_HOUR = "HR";
    static final String X12_DAY = "DA";
    static final String X12_DAY_WORK = "WD";
    static final String X12_WEEK = "WK";
    static final String X12_MONTH = "MO";
    static final String X12_MONTH_WORK = "WM";
    static final String X12_YEAR = "YR";
    private static CLogger s_log = CLogger.getCLogger(MUOM.class);
    private static CCache<Integer, MUOM> s_cache = new CCache("C_UOM", 30);

    public static int getMinute_UOM_ID(Ctx ctx) {
        if (Ini.isClient()) {
            for (MUOM uom : s_cache.values()) {
                if (!uom.isMinute()) continue;
                return uom.getC_UOM_ID();
            }
        }
        int C_UOM_ID = 0;
        String sql = "SELECT C_UOM_ID FROM C_UOM WHERE IsActive='Y' AND X12DE355='MJ'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                C_UOM_ID = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
        return C_UOM_ID;
    }

    public static int getDefault_UOM_ID(Ctx ctx) {
        String sql = "SELECT C_UOM_ID FROM C_UOM WHERE AD_Client_ID IN (0,?) ORDER BY IsDefault DESC, AD_Client_ID DESC, C_UOM_ID";
        return DB.getSQLValue(null, (String)sql, (int)ctx.getAD_Client_ID());
    }

    public static MUOM get(Ctx ctx, int C_UOM_ID) {
        Integer ii;
        MUOM uom;
        if (s_cache.size() == 0) {
            MUOM.loadUOMs(ctx);
        }
        if ((uom = (MUOM)((Object)s_cache.get((Object)(ii = new Integer(C_UOM_ID))))) != null) {
            return uom;
        }
        uom = new MUOM(ctx, C_UOM_ID, null);
        s_cache.put((Object)new Integer(C_UOM_ID), (Object)uom);
        return uom;
    }

    public static int getPrecision(Ctx ctx, int C_UOM_ID) {
        MUOM uom = MUOM.get(ctx, C_UOM_ID);
        return uom.getStdPrecision();
    }

    private static void loadUOMs(Ctx ctx) {
        String sql = MRole.getDefault((Ctx)ctx, (boolean)false).addAccessSQL("SELECT * FROM C_UOM WHERE IsActive='Y'", "C_UOM", false, false);
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MUOM uom = new MUOM(ctx, rs, null);
                s_cache.put((Object)new Integer(uom.getC_UOM_ID()), (Object)uom);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            s_log.log(Level.SEVERE, sql, (Throwable)e);
        }
    }

    public MUOM(Ctx ctx, int C_UOM_ID, String trxName) {
        super(ctx, C_UOM_ID, trxName);
        if (C_UOM_ID == 0) {
            this.setIsDefault(false);
            this.setStdPrecision(2);
            this.setCostingPrecision(6);
        }
    }

    public MUOM(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("UOM[");
        sb.append("ID=").append(this.get_ID()).append(", Name=").append(this.getName());
        return sb.toString();
    }

    public BigDecimal round(BigDecimal qty, boolean stdPrecision) {
        int precision = this.getStdPrecision();
        if (!stdPrecision) {
            precision = this.getCostingPrecision();
        }
        if (qty.scale() > precision) {
            return qty.setScale(this.getStdPrecision(), 4);
        }
        return qty;
    }

    public boolean isMinute() {
        return X12_MINUTE.equals(this.getX12DE355());
    }

    public boolean isHour() {
        return X12_HOUR.equals(this.getX12DE355());
    }

    public boolean isDay() {
        return X12_DAY.equals(this.getX12DE355());
    }

    public boolean isWorkDay() {
        return X12_DAY_WORK.equals(this.getX12DE355());
    }

    public boolean isWeek() {
        return X12_WEEK.equals(this.getX12DE355());
    }

    public boolean isMonth() {
        return X12_MONTH.equals(this.getX12DE355());
    }

    public boolean isWorkMonth() {
        return X12_MONTH_WORK.equals(this.getX12DE355());
    }

    public boolean isYear() {
        return X12_YEAR.equals(this.getX12DE355());
    }
}

