/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MCalendar;
import org.compiere.model.MClient;
import org.compiere.model.MPeriod;
import org.compiere.model.X_C_Year;
import org.compiere.util.Ctx;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class MYear
extends X_C_Year {
    public MYear(Ctx ctx, int C_Year_ID, String trxName) {
        super(ctx, C_Year_ID, trxName);
        if (C_Year_ID == 0) {
            this.setProcessing(false);
        }
    }

    public MYear(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MYear(MCalendar calendar) {
        this(calendar.getCtx(), 0, calendar.get_TrxName());
        this.setClientOrg((PO)calendar);
        this.setC_Calendar_ID(calendar.getC_Calendar_ID());
        this.setYear();
    }

    private void setYear() {
        GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
        String Year = String.valueOf(cal.get(1));
        super.setFiscalYear(Year);
    }

    public int getYearAsInt() {
        String year = this.getFiscalYear();
        try {
            return Integer.parseInt(year);
        }
        catch (Exception e) {
            StringTokenizer st = new StringTokenizer(year, "/-, \t\n\r\f");
            if (st.hasMoreTokens()) {
                String year2 = st.nextToken();
                try {
                    return Integer.parseInt(year2);
                }
                catch (Exception e2) {
                    this.log.log(Level.WARNING, year + "->" + year2 + " - " + e2.toString());
                }
            } else {
                this.log.log(Level.WARNING, year + " - " + e.toString());
            }
            return 0;
        }
    }

    public String getYY() {
        int yy = this.getYearAsInt();
        String year = String.valueOf(yy);
        if (year.length() == 4) {
            return year.substring(2, 4);
        }
        return this.getFiscalYear();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MYear[");
        sb.append(this.get_ID()).append("-").append(this.getFiscalYear()).append("]");
        return sb.toString();
    }

    protected boolean beforeSave(boolean newRecord) {
        int yy = this.getYearAsInt();
        if (yy == 0) {
            this.log.saveError("FillMandatory", Msg.getElement((Ctx)this.getCtx(), (String)"Year") + " -> " + yy + " (2006 - 2006/07 - 2006-07 - ...)");
            return false;
        }
        return true;
    }

    public boolean createStdPeriods(Locale locale) {
        if (locale == null) {
            MClient client = MClient.get((Ctx)this.getCtx());
            locale = client.getLocale();
        }
        if (locale == null && Language.getLoginLanguage() != null) {
            locale = Language.getLoginLanguage().getLocale();
        }
        if (locale == null) {
            locale = Env.getLanguage((Ctx)this.getCtx()).getLocale();
        }
        String[] months = null;
        try {
            DateFormatSymbols symbols = new DateFormatSymbols(locale);
            months = symbols.getShortMonths();
        }
        catch (Exception e) {
            months = new String[]{"Jan", "Feb", "Nar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        }
        int year = this.getYearAsInt();
        GregorianCalendar cal = new GregorianCalendar(locale);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        for (int month = 0; month < 12; ++month) {
            cal.set(1, year);
            cal.set(2, month);
            cal.set(5, 1);
            Timestamp start = new Timestamp(cal.getTimeInMillis());
            String name = months[month] + "-" + this.getYY();
            cal.add(2, 1);
            cal.add(6, -1);
            Timestamp end = new Timestamp(cal.getTimeInMillis());
            MPeriod period = new MPeriod(this, month + 1, name, start, end);
            if (period.save(this.get_TrxName())) continue;
            return false;
        }
        return true;
    }
}

