/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCost;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProductCost {
    private int m_M_Product_ID = 0;
    private int m_M_AttributeSetInstance_ID = 0;
    private MProduct m_product = null;
    private String m_trxName = null;
    private int m_C_UOM_ID = 0;
    private BigDecimal m_qty = Env.ZERO;
    private static CLogger log = CLogger.getCLogger(ProductCost.class);
    public static final int ACCTTYPE_P_Revenue = 1;
    public static final int ACCTTYPE_P_Expense = 2;
    public static final int ACCTTYPE_P_Asset = 3;
    public static final int ACCTTYPE_P_Cogs = 4;
    public static final int ACCTTYPE_P_PPV = 5;
    public static final int ACCTTYPE_P_IPV = 6;
    public static final int ACCTTYPE_P_TDiscountRec = 7;
    public static final int ACCTTYPE_P_TDiscountGrant = 8;
    public static final int ACCTTYPE_P_CostAdjustment = 9;
    public static final int ACCTTYPE_P_InventoryClearing = 10;

    public ProductCost(Ctx ctx, int M_Product_ID, int M_AttributeSetInstance_ID, String trxName) {
        this.m_M_Product_ID = M_Product_ID;
        if (this.m_M_Product_ID != 0) {
            this.m_product = MProduct.get(ctx, M_Product_ID);
        }
        this.m_M_AttributeSetInstance_ID = M_AttributeSetInstance_ID;
        this.m_trxName = trxName;
    }

    public MProduct getProduct() {
        return this.m_product;
    }

    public boolean isService() {
        if (this.m_product != null) {
            return this.m_product.isService();
        }
        return false;
    }

    public void setQty(BigDecimal qty) {
        this.m_qty = qty;
    }

    public void setQty(BigDecimal qty, int C_UOM_ID) {
        this.m_qty = MUOMConversion.convert(C_UOM_ID, this.m_C_UOM_ID, qty, true);
        if (qty != null && this.m_qty == null) {
            log.severe("Conversion error - set to " + qty);
            this.m_qty = qty;
        } else {
            this.m_C_UOM_ID = C_UOM_ID;
        }
    }

    public MAccount getAccount(int AcctType, MAcctSchema as) {
        if (AcctType < 1 || AcctType > 10) {
            return null;
        }
        if (this.m_M_Product_ID == 0) {
            return this.getAccountDefault(AcctType, as);
        }
        String sql = "SELECT P_Revenue_Acct, P_Expense_Acct, P_Asset_Acct, P_Cogs_Acct, P_PurchasePriceVariance_Acct, P_InvoicePriceVariance_Acct, P_TradeDiscountRec_Acct, P_TradeDiscountGrant_Acct,P_CostAdjustment_Acct, P_InventoryClearing_Acct FROM M_Product_Acct WHERE M_Product_ID=? AND C_AcctSchema_ID=?";
        int validCombination_ID = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.m_M_Product_ID);
            pstmt.setInt(2, as.getC_AcctSchema_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                validCombination_ID = rs.getInt(AcctType);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        if (validCombination_ID == 0) {
            return null;
        }
        return MAccount.get((Ctx)as.getCtx(), (int)validCombination_ID);
    }

    public MAccount getAccountDefault(int AcctType, MAcctSchema as) {
        if (AcctType < 1 || AcctType > 10) {
            return null;
        }
        String sql = "SELECT P_Revenue_Acct, P_Expense_Acct, P_Asset_Acct, P_Cogs_Acct, P_PurchasePriceVariance_Acct, P_InvoicePriceVariance_Acct, P_TradeDiscountRec_Acct, P_TradeDiscountGrant_Acct, P_CostAdjustment_Acct, P_InventoryClearing_Acct FROM M_Product_Category pc, M_Product_Category_Acct pca WHERE pc.M_Product_Category_ID=pca.M_Product_Category_ID AND pca.C_AcctSchema_ID=? ORDER BY pc.IsDefault DESC, pc.Created";
        int validCombination_ID = 0;
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, as.getC_AcctSchema_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                validCombination_ID = rs.getInt(AcctType);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        if (validCombination_ID == 0) {
            return null;
        }
        return MAccount.get((Ctx)as.getCtx(), (int)validCombination_ID);
    }

    public BigDecimal getProductCosts(MAcctSchema as, int AD_Org_ID, String costingMethod, int C_OrderLine_ID, boolean zeroCostsOK) {
        if (this.m_qty == null) {
            log.fine("No Qty");
            return null;
        }
        if (this.m_product == null) {
            log.fine("No Product");
            return null;
        }
        BigDecimal cost = MCost.getCurrentCost(this.m_product, this.m_M_AttributeSetInstance_ID, as, AD_Org_ID, costingMethod, this.m_qty, C_OrderLine_ID, zeroCostsOK, this.m_trxName);
        if (cost == null) {
            log.fine("No Costs");
            return null;
        }
        return cost;
    }

    private BigDecimal getProductItemCostOld(MAcctSchema as, String costType) {
        BigDecimal current = null;
        BigDecimal cost = null;
        String cm = as.getCostingMethod();
        StringBuffer sql = new StringBuffer("SELECT CurrentCostPrice,");
        if (costType == null && "A".equals(cm) || "A".equals(costType)) {
            sql.append("COSTAVERAGE");
        } else if (costType == null && "p".equals(cm) || "p".equals(costType)) {
            sql.append("PRICELASTPO");
        } else {
            sql.append("COSTSTANDARD");
        }
        sql.append(" FROM M_Product_Costing WHERE M_Product_ID=? AND C_AcctSchema_ID=?");
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setInt(1, this.m_M_Product_ID);
            pstmt.setInt(2, as.getC_AcctSchema_ID());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                current = rs.getBigDecimal(1);
                cost = rs.getBigDecimal(2);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        if (costType != null && cost != null && !cost.equals(Env.ZERO)) {
            log.fine("Costs=" + cost);
            return cost;
        }
        if (current != null && !current.equals(Env.ZERO)) {
            log.fine("Current=" + current);
            return current;
        }
        boolean create = cost == null && current == null;
        return this.updateCostsOld(as, create);
    }

    private BigDecimal updateCostsOld(MAcctSchema as, boolean create) {
        if (create) {
            StringBuffer sql = new StringBuffer("INSERT INTO M_Product_Costing (M_Product_ID,C_AcctSchema_ID, AD_Client_ID,AD_Org_ID,IsActive,Created,CreatedBy,Updated,UpdatedBy, CurrentCostPrice,CostStandard,FutureCostPrice, CostStandardPOQty,CostStandardPOAmt,CostStandardCumQty,CostStandardCumAmt, CostAverage,CostAverageCumQty,CostAverageCumAmt, PriceLastPO,PriceLastInv, TotalInvQty,TotalInvAmt) VALUES (");
            sql.append(this.m_M_Product_ID).append(",").append(as.getC_AcctSchema_ID()).append(",").append(as.getAD_Client_ID()).append(",").append(as.getAD_Org_ID()).append(",").append("'Y',SysDate,0,SysDate,0, 0,0,0,  0,0,0,0,  0,0,0,  0,0,  0,0)");
            int no = DB.executeUpdate((String)sql.toString(), (String)this.m_trxName);
            if (no == 1) {
                log.fine("CostingCreated");
            }
        }
        String costSource = "PriceList-PO";
        BigDecimal costs = this.getPriceList(as, true);
        if (costs == null || costs.equals(Env.ZERO)) {
            costSource = "PO Cost";
            costs = this.getPOCost(as);
        }
        if (costs == null || costs.equals(Env.ZERO)) {
            costSource = "PriceList";
            costs = this.getPriceList(as, false);
        }
        if (costs == null || costs.equals(Env.ZERO)) {
            costSource = "Not Found";
            costs = new BigDecimal("1");
        }
        StringBuffer sql = new StringBuffer("UPDATE M_Product_Costing ");
        sql.append("SET CurrentCostPrice=").append(costs).append(" WHERE M_Product_ID=").append(this.m_M_Product_ID).append(" AND C_AcctSchema_ID=").append(as.getC_AcctSchema_ID());
        int no = DB.executeUpdate((String)sql.toString(), (String)this.m_trxName);
        if (no == 1) {
            log.fine(costSource + " - " + costs);
        }
        return costs;
    }

    private BigDecimal getPriceList(MAcctSchema as, boolean onlyPOPriceList) {
        StringBuffer sql = new StringBuffer("SELECT pl.C_Currency_ID, pp.PriceList, pp.PriceStd, pp.PriceLimit FROM M_PriceList pl, M_PriceList_Version plv, M_ProductPrice pp WHERE pl.M_PriceList_ID = plv.M_PriceList_ID AND plv.M_PriceList_Version_ID = pp.M_PriceList_Version_ID AND pp.M_Product_ID=?");
        if (onlyPOPriceList) {
            sql.append(" AND pl.IsSOPriceList='N'");
        }
        sql.append(" ORDER BY pl.IsSOPriceList ASC, plv.ValidFrom DESC");
        int C_Currency_ID = 0;
        BigDecimal PriceList = null;
        BigDecimal PriceStd = null;
        BigDecimal PriceLimit = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql.toString(), null);
            pstmt.setInt(1, this.m_M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                C_Currency_ID = rs.getInt(1);
                PriceList = rs.getBigDecimal(2);
                PriceStd = rs.getBigDecimal(3);
                PriceLimit = rs.getBigDecimal(4);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        if (C_Currency_ID == 0) {
            return null;
        }
        BigDecimal price = PriceLimit;
        if (price == null || price.equals(Env.ZERO)) {
            price = PriceStd;
        }
        if (price == null || price.equals(Env.ZERO)) {
            price = PriceList;
        }
        if (price != null && !price.equals(Env.ZERO)) {
            price = MConversionRate.convert((Ctx)as.getCtx(), (BigDecimal)price, (int)C_Currency_ID, (int)as.getC_Currency_ID(), (int)as.getAD_Client_ID(), (int)0);
        }
        return price;
    }

    private BigDecimal getPOCost(MAcctSchema as) {
        String sql = "SELECT C_Currency_ID, PriceList,PricePO,PriceLastPO FROM M_Product_PO WHERE M_Product_ID=? ORDER BY IsCurrentVendor DESC";
        int C_Currency_ID = 0;
        BigDecimal PriceList = null;
        BigDecimal PricePO = null;
        BigDecimal PriceLastPO = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.m_M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                C_Currency_ID = rs.getInt(1);
                PriceList = rs.getBigDecimal(2);
                PricePO = rs.getBigDecimal(3);
                PriceLastPO = rs.getBigDecimal(4);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, (Throwable)e);
        }
        if (C_Currency_ID == 0) {
            return null;
        }
        BigDecimal cost = PriceLastPO;
        if (cost == null || cost.equals(Env.ZERO)) {
            cost = PricePO;
        }
        if (cost == null || cost.equals(Env.ZERO)) {
            cost = PriceList;
        }
        if (cost != null && !cost.equals(Env.ZERO)) {
            cost = MConversionRate.convert((Ctx)as.getCtx(), (BigDecimal)cost, (int)C_Currency_ID, (int)as.getC_Currency_ID(), (int)as.getAD_Client_ID(), (int)as.getAD_Org_ID());
        }
        return cost;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ProductCost[");
        sb.append("M_Product_ID=").append(this.m_M_Product_ID).append(",M_AttributeSetInstance_ID").append(this.m_M_AttributeSetInstance_ID).append(",Qty=").append(this.m_qty).append("]");
        return sb.toString();
    }
}

