/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MAging;
import org.compiere.model.MRole;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class Aging
extends SvrProcess {
    private Timestamp p_StatementDate = null;
    private boolean p_IsSOTrx = false;
    private int p_AD_Org_ID = 0;
    private int p_C_Currency_ID = 0;
    private int p_C_BP_Group_ID = 0;
    private int p_C_BPartner_ID = 0;
    private boolean p_IsListInvoices = false;
    private int m_statementOffset = 0;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("StatementDate")) {
                this.p_StatementDate = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("IsSOTrx")) {
                this.p_IsSOTrx = "Y".equals(para[i].getParameter());
                continue;
            }
            if (name.equals("C_Currency_ID")) {
                this.p_C_Currency_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.p_C_BP_Group_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("IsListInvoices")) {
                this.p_IsListInvoices = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        if (this.p_StatementDate == null) {
            this.p_StatementDate = new Timestamp(System.currentTimeMillis());
        } else {
            this.m_statementOffset = TimeUtil.getDaysBetween((Timestamp)new Timestamp(System.currentTimeMillis()), (Timestamp)this.p_StatementDate);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("StatementDate=" + this.p_StatementDate + ", IsSOTrx=" + this.p_IsSOTrx + ", C_Currency_ID=" + this.p_C_Currency_ID + ",AD_Org_ID=" + this.p_AD_Org_ID + ", C_BP_Group_ID=" + this.p_C_BP_Group_ID + ", C_BPartner_ID=" + this.p_C_BPartner_ID + ", IsListInvoices=" + this.p_IsListInvoices);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT bp.C_BP_Group_ID, oi.C_BPartner_ID,oi.C_Invoice_ID,oi.C_InvoicePaySchedule_ID, oi.C_Currency_ID, oi.IsSOTrx, oi.DateInvoiced, oi.NetDays,oi.DueDate,oi.DaysDue, ");
        if (this.p_C_Currency_ID == 0) {
            sql.append("oi.GrandTotal, oi.PaidAmt, oi.OpenAmt ");
        } else {
            String s = ",oi.C_Currency_ID," + this.p_C_Currency_ID + ",oi.DateAcct,oi.C_ConversionType_ID,oi.AD_Client_ID,oi.AD_Org_ID)";
            sql.append("currencyConvert(oi.GrandTotal").append(s).append(", currencyConvert(oi.PaidAmt").append(s).append(", currencyConvert(oi.OpenAmt").append(s);
        }
        sql.append(",oi.C_Activity_ID,oi.C_Campaign_ID,oi.C_Project_ID FROM RV_OpenItem oi INNER JOIN C_BPartner bp ON (oi.C_BPartner_ID=bp.C_BPartner_ID) WHERE oi.ISSoTrx=").append(this.p_IsSOTrx ? "'Y'" : "'N'");
        if (this.p_AD_Org_ID > 0) {
            sql.append(" AND oi.AD_Org_ID=").append(this.p_AD_Org_ID);
        }
        if (this.p_C_BPartner_ID > 0) {
            sql.append(" AND oi.C_BPartner_ID=").append(this.p_C_BPartner_ID);
        } else if (this.p_C_BP_Group_ID > 0) {
            sql.append(" AND bp.C_BP_Group_ID=").append(this.p_C_BP_Group_ID);
        }
        sql.append(" ORDER BY oi.C_BPartner_ID, oi.C_Currency_ID, oi.C_Invoice_ID");
        this.log.finest(sql.toString());
        String finalSql = MRole.getDefault((Ctx)this.getCtx(), (boolean)false).addAccessSQL(sql.toString(), "oi", true, false);
        this.log.finer(finalSql);
        CPreparedStatement pstmt = null;
        MAging aging = null;
        int counter = 0;
        int rows = 0;
        int AD_PInstance_ID = this.getAD_PInstance_ID();
        try {
            pstmt = DB.prepareStatement((String)finalSql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_BP_Group_ID = rs.getInt(1);
                int C_BPartner_ID = rs.getInt(2);
                int C_Invoice_ID = this.p_IsListInvoices ? rs.getInt(3) : 0;
                int C_InvoicePaySchedule_ID = this.p_IsListInvoices ? rs.getInt(4) : 0;
                int C_Currency_ID = rs.getInt(5);
                boolean IsSOTrx = "Y".equals(rs.getString(6));
                Timestamp DueDate = rs.getTimestamp(9);
                int DaysDue = rs.getInt(10) + this.m_statementOffset;
                BigDecimal GrandTotal = rs.getBigDecimal(11);
                BigDecimal OpenAmt = rs.getBigDecimal(13);
                int C_Activity_ID = this.p_IsListInvoices ? rs.getInt(14) : 0;
                int C_Campaign_ID = this.p_IsListInvoices ? rs.getInt(15) : 0;
                int C_Project_ID = this.p_IsListInvoices ? rs.getInt(16) : 0;
                ++rows;
                if (aging == null || AD_PInstance_ID != aging.getAD_PInstance_ID() || C_BPartner_ID != aging.getC_BPartner_ID() || C_Currency_ID != aging.getC_Currency_ID() || C_Invoice_ID != aging.getC_Invoice_ID() || C_InvoicePaySchedule_ID != aging.getC_InvoicePaySchedule_ID()) {
                    if (aging != null) {
                        if (aging.save()) {
                            this.log.fine("#" + ++counter + " - " + aging);
                        } else {
                            this.log.log(Level.SEVERE, "Not saved " + aging);
                            break;
                        }
                    }
                    aging = new MAging(this.getCtx(), AD_PInstance_ID, this.p_StatementDate, C_BPartner_ID, C_Currency_ID, C_Invoice_ID, C_InvoicePaySchedule_ID, C_BP_Group_ID, DueDate, IsSOTrx, this.get_TrxName());
                    if (this.p_AD_Org_ID > 0) {
                        aging.setAD_Org_ID(this.p_AD_Org_ID);
                    }
                    aging.setC_Activity_ID(C_Activity_ID);
                    aging.setC_Campaign_ID(C_Campaign_ID);
                    aging.setC_Project_ID(C_Project_ID);
                }
                aging.add(DueDate, DaysDue, GrandTotal, OpenAmt);
            }
            if (aging != null) {
                if (aging.save()) {
                    this.log.fine("#" + ++counter + " - " + aging);
                } else {
                    this.log.log(Level.SEVERE, "Not saved " + aging);
                }
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, finalSql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.log.info("#" + counter + " - rows=" + rows);
        return "";
    }
}

