/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MDistributionRun;
import org.compiere.model.MDistributionRunDetail;
import org.compiere.model.MDistributionRunLine;
import org.compiere.model.MDocType;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MProduct;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class DistributionRun
extends SvrProcess {
    private int p_M_DistributionRun_ID = 0;
    private Timestamp p_DatePromised = null;
    private int p_C_DocType_ID = 0;
    private boolean p_IsTest = false;
    private MDistributionRun m_run = null;
    private MDistributionRunLine[] m_runLines = null;
    private MDistributionRunDetail[] m_details = null;
    private Timestamp m_DateOrdered = null;
    private int m_counter = 0;
    private MDocType m_docType = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("C_DocType_ID")) {
                this.p_C_DocType_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("DatePromised")) {
                this.p_DatePromised = (Timestamp)para[i].getParameter();
                continue;
            }
            if (name.equals("IsTest")) {
                this.p_IsTest = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.p_M_DistributionRun_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("M_DistributionRun_ID=" + this.p_M_DistributionRun_ID + ", C_DocType_ID=" + this.p_C_DocType_ID + ", DatePromised=" + this.p_DatePromised + ", Test=" + this.p_IsTest);
        if (this.p_M_DistributionRun_ID == 0) {
            throw new IllegalArgumentException("No Distribution Run ID");
        }
        this.m_run = new MDistributionRun(this.getCtx(), this.p_M_DistributionRun_ID, this.get_TrxName());
        if (this.m_run.get_ID() == 0) {
            throw new Exception("Distribution Run not found -  M_DistributionRun_ID=" + this.p_M_DistributionRun_ID);
        }
        this.m_runLines = this.m_run.getLines(true);
        if (this.m_runLines == null || this.m_runLines.length == 0) {
            throw new Exception("No active, non-zero Distribution Run Lines found");
        }
        if (this.p_C_DocType_ID == 0) {
            throw new IllegalArgumentException("No Document Type ID");
        }
        this.m_docType = new MDocType(this.getCtx(), this.p_C_DocType_ID, null);
        if (this.m_docType.get_ID() == 0) {
            throw new Exception("Document Type not found -  C_DocType_ID=" + this.p_C_DocType_ID);
        }
        this.m_DateOrdered = new Timestamp(System.currentTimeMillis());
        if (this.p_DatePromised == null) {
            this.p_DatePromised = this.m_DateOrdered;
        }
        if (this.insertDetails() == 0) {
            throw new Exception("No Lines");
        }
        this.m_details = MDistributionRunDetail.get(this.getCtx(), this.p_M_DistributionRun_ID, false, this.get_TrxName());
        this.addAllocations();
        int loops = 0;
        while (!this.isAllocationEqTotal()) {
            this.adjustAllocation();
            this.addAllocations();
            if (++loops <= 10) continue;
            throw new Exception("Loop detected - more than 10 Allocation attempts");
        }
        this.m_details = MDistributionRunDetail.get(this.getCtx(), this.p_M_DistributionRun_ID, true, this.get_TrxName());
        this.createOrders();
        return "@Created@ #" + this.m_counter;
    }

    private int insertDetails() {
        String sql = "UPDATE M_DistributionRunLine SET MinQty = 0 WHERE MinQty IS NULL";
        int no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        sql = "UPDATE M_DistributionListLine SET MinQty = 0 WHERE MinQty IS NULL";
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        sql = "UPDATE M_DistributionList l SET RatioTotal = (SELECT SUM(Ratio) FROM M_DistributionListLine ll  WHERE l.M_DistributionList_ID=ll.M_DistributionList_ID) WHERE EXISTS (SELECT * FROM M_DistributionRunLine rl WHERE l.M_DistributionList_ID=rl.M_DistributionList_ID AND rl.M_DistributionRun_ID=" + this.p_M_DistributionRun_ID + ")";
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        sql = "DELETE FROM T_DistributionRunDetail WHERE M_DistributionRun_ID=" + this.p_M_DistributionRun_ID;
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.log.fine("insertDetails - deleted #" + no);
        sql = "INSERT INTO T_DistributionRunDetail (M_DistributionRun_ID, M_DistributionRunLine_ID, M_DistributionList_ID, M_DistributionListLine_ID,AD_Client_ID,AD_Org_ID, IsActive, Created,CreatedBy, Updated,UpdatedBy,C_BPartner_ID, C_BPartner_Location_ID, M_Product_ID,Ratio, MinQty, Qty) SELECT rl.M_DistributionRun_ID, rl.M_DistributionRunLine_ID,ll.M_DistributionList_ID, ll.M_DistributionListLine_ID, rl.AD_Client_ID,rl.AD_Org_ID, rl.IsActive, rl.Created,rl.CreatedBy, rl.Updated,rl.UpdatedBy,ll.C_BPartner_ID, ll.C_BPartner_Location_ID, rl.M_Product_ID, ll.Ratio, CASE WHEN rl.MinQty > ll.MinQty THEN rl.MinQty ELSE ll.MinQty END, (ll.Ratio/l.RatioTotal*rl.TotalQty)FROM M_DistributionRunLine rl INNER JOIN M_DistributionList l ON (rl.M_DistributionList_ID=l.M_DistributionList_ID) INNER JOIN M_DistributionListLine ll ON (rl.M_DistributionList_ID=ll.M_DistributionList_ID) WHERE rl.M_DistributionRun_ID=" + this.p_M_DistributionRun_ID + " AND l.RatioTotal<>0 AND rl.IsActive='Y' AND ll.IsActive='Y'";
        no = DB.executeUpdate((String)sql, (String)this.get_TrxName());
        this.log.fine("inserted #" + no);
        return no;
    }

    private void addAllocations() {
        MDistributionRunLine runLine;
        int j;
        for (j = 0; j < this.m_runLines.length; ++j) {
            runLine = this.m_runLines[j];
            runLine.resetCalculations();
        }
        for (int i = 0; i < this.m_details.length; ++i) {
            MDistributionRunDetail detail = this.m_details[i];
            for (int j2 = 0; j2 < this.m_runLines.length; ++j2) {
                MDistributionRunLine runLine2 = this.m_runLines[j2];
                if (runLine2.getM_DistributionRunLine_ID() != detail.getM_DistributionRunLine_ID()) continue;
                detail.round(runLine2.getUOMPrecision());
                runLine2.addActualMin(detail.getMinQty());
                runLine2.addActualQty(detail.getQty());
                runLine2.addActualAllocation(detail.getActualAllocation());
                runLine2.setMaxAllocation(detail.getActualAllocation(), false);
                this.log.fine("RunLine=" + runLine2.getLine() + ": BP_ID=" + detail.getC_BPartner_ID() + ", Min=" + detail.getMinQty() + ", Qty=" + detail.getQty() + ", Allocation=" + detail.getActualAllocation());
            }
        }
        for (j = 0; j < this.m_runLines.length; ++j) {
            runLine = this.m_runLines[j];
            this.log.fine("Run - " + runLine.getInfo());
        }
    }

    private boolean isAllocationEqTotal() throws Exception {
        boolean allocationEqTotal = true;
        for (int j = 0; j < this.m_runLines.length; ++j) {
            MDistributionRunLine runLine = this.m_runLines[j];
            if (runLine.isActualMinGtTotal()) {
                throw new Exception("Line " + runLine.getLine() + " Sum of Min Qty=" + runLine.getActualMin() + " is greater than Total Qty=" + runLine.getTotalQty());
            }
            if (!allocationEqTotal || runLine.isActualAllocationEqTotal()) continue;
            allocationEqTotal = false;
        }
        this.log.info("=" + allocationEqTotal);
        return allocationEqTotal;
    }

    private void adjustAllocation() throws Exception {
        for (int j = 0; j < this.m_runLines.length; ++j) {
            this.adjustAllocation(j);
        }
    }

    private void adjustAllocation(int index) throws Exception {
        MDistributionRunDetail detail;
        int i;
        MDistributionRunLine runLine = this.m_runLines[index];
        BigDecimal difference = runLine.getActualAllocationDiff();
        if (difference.compareTo(Env.ZERO) == 0) {
            return;
        }
        boolean adjustBiggest = difference.abs().compareTo(Env.ONE) <= 0 || difference.abs().compareTo(runLine.getLastDifference().abs()) == 0;
        this.log.fine("Line=" + runLine.getLine() + ", Diff=" + difference + ", Adjust=" + adjustBiggest);
        if (adjustBiggest) {
            for (int i2 = 0; i2 < this.m_details.length; ++i2) {
                MDistributionRunDetail detail2 = this.m_details[i2];
                if (runLine.getM_DistributionRunLine_ID() != detail2.getM_DistributionRunLine_ID()) continue;
                this.log.fine("Biggest - DetailAllocation=" + detail2.getActualAllocation() + ", MaxAllocation=" + runLine.getMaxAllocation() + ", Qty Difference=" + difference);
                if (detail2.getActualAllocation().compareTo(runLine.getMaxAllocation()) != 0 || !detail2.isCanAdjust()) continue;
                detail2.adjustQty(difference);
                detail2.save();
                return;
            }
            throw new Exception("Cannot adjust Difference = " + difference + " - You need to change Total Qty or Min Qty");
        }
        BigDecimal ratioTotal = Env.ZERO;
        for (i = 0; i < this.m_details.length; ++i) {
            detail = this.m_details[i];
            if (runLine.getM_DistributionRunLine_ID() != detail.getM_DistributionRunLine_ID() || !detail.isCanAdjust()) continue;
            ratioTotal = ratioTotal.add(detail.getRatio());
        }
        if (ratioTotal.compareTo(Env.ZERO) == 0) {
            throw new Exception("Cannot distribute Difference = " + difference + " - You need to change Total Qty or Min Qty");
        }
        for (i = 0; i < this.m_details.length; ++i) {
            detail = this.m_details[i];
            if (runLine.getM_DistributionRunLine_ID() != detail.getM_DistributionRunLine_ID() || !detail.isCanAdjust()) continue;
            BigDecimal diffRatio = detail.getRatio().multiply(difference).divide(ratioTotal, 4);
            this.log.fine("Detail=" + detail.toString() + ", Allocation=" + detail.getActualAllocation() + ", DiffRatio=" + diffRatio);
            detail.adjustQty(diffRatio);
            detail.save();
        }
        runLine.setLastDifference(difference);
    }

    private boolean createOrders() {
        MBPartner runBPartner;
        int runAD_Org_ID = this.m_run.getAD_Org_ID();
        if (runAD_Org_ID == 0) {
            runAD_Org_ID = this.getCtx().getAD_Org_ID();
        }
        MOrg runOrg = MOrg.get((Ctx)this.getCtx(), (int)runAD_Org_ID);
        int runC_BPartner_ID = runOrg.getLinkedC_BPartner_ID();
        boolean counter = !this.m_run.isCreateSingleOrder() && runC_BPartner_ID > 0 && !this.m_docType.isSOTrx();
        MBPartner mBPartner = runBPartner = counter ? new MBPartner(this.getCtx(), runC_BPartner_ID, this.get_TrxName()) : null;
        if (!counter || runBPartner == null || runBPartner.get_ID() != runC_BPartner_ID) {
            counter = false;
        }
        if (counter) {
            this.log.info("RunBP=" + (Object)((Object)runBPartner) + " - " + this.m_docType);
        }
        this.log.info("Single=" + this.m_run.isCreateSingleOrder() + " - " + this.m_docType + ",SO=" + this.m_docType.isSOTrx());
        this.log.fine("Counter=" + counter + ",C_BPartner_ID=" + runC_BPartner_ID + "," + (Object)((Object)runBPartner));
        MBPartner bp = null;
        MOrder singleOrder = null;
        MProduct product = null;
        if (this.m_run.isCreateSingleOrder()) {
            bp = new MBPartner(this.getCtx(), this.m_run.getC_BPartner_ID(), this.get_TrxName());
            if (bp.get_ID() == 0) {
                throw new IllegalArgumentException("Business Partner not found - C_BPartner_ID=" + this.m_run.getC_BPartner_ID());
            }
            if (!this.p_IsTest) {
                singleOrder = new MOrder(this.getCtx(), 0, this.get_TrxName());
                singleOrder.setC_DocTypeTarget_ID(this.m_docType.getC_DocType_ID());
                singleOrder.setC_DocType_ID(this.m_docType.getC_DocType_ID());
                singleOrder.setIsReturnTrx(this.m_docType.isReturnTrx());
                singleOrder.setIsSOTrx(this.m_docType.isSOTrx());
                singleOrder.setBPartner(bp);
                if (this.m_run.getC_BPartner_Location_ID() != 0) {
                    singleOrder.setC_BPartner_Location_ID(this.m_run.getC_BPartner_Location_ID());
                }
                singleOrder.setDateOrdered(this.m_DateOrdered);
                singleOrder.setDatePromised(this.p_DatePromised);
                if (!singleOrder.save()) {
                    this.log.log(Level.SEVERE, "Order not saved");
                    return false;
                }
                ++this.m_counter;
            }
        }
        int lastC_BPartner_ID = 0;
        int lastC_BPartner_Location_ID = 0;
        MOrder order = null;
        for (int i = 0; i < this.m_details.length; ++i) {
            MDistributionRunDetail detail = this.m_details[i];
            if (this.m_run.isCreateSingleOrder()) {
                order = singleOrder;
            } else if (lastC_BPartner_ID != detail.getC_BPartner_ID() || lastC_BPartner_Location_ID != detail.getC_BPartner_Location_ID()) {
                order = null;
            }
            lastC_BPartner_ID = detail.getC_BPartner_ID();
            lastC_BPartner_Location_ID = detail.getC_BPartner_Location_ID();
            if (order == null) {
                bp = new MBPartner(this.getCtx(), detail.getC_BPartner_ID(), this.get_TrxName());
                if (!this.p_IsTest) {
                    order = new MOrder(this.getCtx(), 0, this.get_TrxName());
                    order.setC_DocTypeTarget_ID(this.m_docType.getC_DocType_ID());
                    order.setIsReturnTrx(this.m_docType.isReturnTrx());
                    order.setC_DocType_ID(this.m_docType.getC_DocType_ID());
                    order.setIsSOTrx(this.m_docType.isSOTrx());
                    if (counter && bp.getAD_OrgBP_ID_Int() > 0) {
                        this.log.fine("Counter - From_BPOrg=" + bp.getAD_OrgBP_ID_Int() + "-" + (Object)((Object)bp) + ", To_BP=" + (Object)((Object)runBPartner));
                        order.setAD_Org_ID(bp.getAD_OrgBP_ID_Int());
                        MOrgInfo oi = MOrgInfo.get((Ctx)this.getCtx(), (int)bp.getAD_OrgBP_ID_Int(), null);
                        if (oi.getM_Warehouse_ID() > 0) {
                            order.setM_Warehouse_ID(oi.getM_Warehouse_ID());
                        }
                        order.setBPartner(runBPartner);
                    } else {
                        this.log.fine("From_Org=" + runAD_Org_ID + ", To_BP=" + (Object)((Object)bp));
                        order.setAD_Org_ID(runAD_Org_ID);
                        order.setBPartner(bp);
                        if (detail.getC_BPartner_Location_ID() != 0) {
                            order.setC_BPartner_Location_ID(detail.getC_BPartner_Location_ID());
                        }
                    }
                    order.setDateOrdered(this.m_DateOrdered);
                    order.setDatePromised(this.p_DatePromised);
                    if (!order.save()) {
                        this.log.log(Level.SEVERE, "Order not saved");
                        return false;
                    }
                }
            }
            if (product == null || product.getM_Product_ID() != detail.getM_Product_ID()) {
                product = MProduct.get(this.getCtx(), detail.getM_Product_ID());
            }
            if (this.p_IsTest) {
                this.addLog(0, null, detail.getActualAllocation(), bp.getName() + " - " + product.getName());
                continue;
            }
            MOrderLine line = new MOrderLine(order);
            if (!counter || bp.getAD_OrgBP_ID_Int() <= 0) {
                line.setC_BPartner_ID(detail.getC_BPartner_ID());
                if (detail.getC_BPartner_Location_ID() != 0) {
                    line.setC_BPartner_Location_ID(detail.getC_BPartner_Location_ID());
                }
            }
            line.setProduct(product);
            line.setQty(detail.getActualAllocation());
            line.setPrice();
            if (!line.save()) {
                this.log.log(Level.SEVERE, "OrderLine not saved");
                return false;
            }
            this.addLog(0, null, detail.getActualAllocation(), order.getDocumentNo() + ": " + bp.getName() + " - " + product.getName());
        }
        order = null;
        return true;
    }
}

