/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CompiereSystemException;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MergeProcess
extends SvrProcess {
    private int from_ID = 0;
    private int to_ID = 0;
    private static String AD_ORG_ID = "AD_Org_ID";
    private static String C_BPARTNER_ID = "C_BPartner_ID";
    private static String AD_USER_ID = "AD_User_ID";
    private static String M_PRODUCT_ID = "M_Product_ID";
    private String columnName = null;
    private static String[] s_delete_Org = new String[]{"AD_OrgInfo"};
    private static String[] s_delete_User = new String[]{"AD_User_Roles"};
    private static String[] s_delete_BPartner = new String[]{"C_BP_Employee_Acct", "C_BP_Vendor_Acct", "C_BP_Customer_Acct", "T_Aging"};
    private static String[] s_delete_Product = new String[]{"M_Product_PO", "M_Replenish", "T_Replenish", "M_ProductPrice", "M_Product_Costing", "M_Product_Trl", "M_Product_Acct"};
    private int m_totalCount = 0;
    private StringBuffer m_errorLog = new StringBuffer();
    private Connection m_con = null;
    private String[] m_deleteTables = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_Org_ID")) {
                this.from_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_Org_To_ID")) {
                this.to_ID = ((BigDecimal)para[i].getParameter()).intValue();
                this.columnName = AD_ORG_ID;
                this.m_deleteTables = s_delete_Org;
                continue;
            }
            if (name.equals("AD_User_ID")) {
                this.from_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("AD_User_To_ID")) {
                this.to_ID = ((BigDecimal)para[i].getParameter()).intValue();
                this.m_deleteTables = s_delete_User;
                this.columnName = AD_USER_ID;
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.from_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_BPartner_To_ID")) {
                this.to_ID = ((BigDecimal)para[i].getParameter()).intValue();
                this.m_deleteTables = s_delete_BPartner;
                this.columnName = C_BPARTNER_ID;
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.from_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (!name.equals("M_Product_To_ID")) continue;
            this.to_ID = ((BigDecimal)para[i].getParameter()).intValue();
            this.m_deleteTables = s_delete_Product;
            this.columnName = M_PRODUCT_ID;
        }
    }

    protected String doIt() throws Exception {
        this.log.info("doIt ");
        String fromValue = null;
        String toValue = null;
        if (this.from_ID < 0) {
            throw new IllegalArgumentException("Invalid From " + this.columnName + ": " + this.from_ID);
        }
        if (this.to_ID < 0) {
            throw new IllegalArgumentException("Invalid To " + this.columnName + ": " + this.to_ID);
        }
        String fromSql = " SELECT Name FROM " + this.columnName.substring(0, this.columnName.length() - 3) + " WHERE " + this.columnName + " = ? ";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)fromSql, null);
            pstmt.setString(1, String.valueOf(this.from_ID));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                fromValue = rs.getString(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, this.columnName, (Throwable)ex);
        }
        String toSql = " SELECT Name FROM " + this.columnName.substring(0, this.columnName.length() - 3) + " WHERE " + this.columnName + " =  ?";
        pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)toSql, null);
            pstmt.setString(1, String.valueOf(this.to_ID));
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                toValue = rs.getString(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, this.columnName, (Throwable)ex);
        }
        String msg = Msg.translate((Ctx)this.getCtx(), (String)"MergeFrom") + " = " + fromValue + "\n" + Msg.translate((Ctx)this.getCtx(), (String)"MergeTo") + " = " + toValue + "\n";
        boolean success = this.merge(this.columnName, this.from_ID, this.to_ID);
        this.postMerge(this.columnName, this.to_ID);
        if (success) {
            return msg + " #" + this.m_totalCount;
        }
        throw new CompiereSystemException(" " + this.m_errorLog.toString());
    }

    private boolean merge(String ColumnName, int from_ID, int to_ID) {
        String TableName = ColumnName.substring(0, ColumnName.length() - 3);
        this.log.config(ColumnName + " - From=" + from_ID + ",To=" + to_ID);
        boolean success = true;
        this.m_totalCount = 0;
        this.m_errorLog = new StringBuffer();
        String sql = "SELECT t.TableName, c.ColumnName FROM AD_Table t INNER JOIN AD_Column c ON (t.AD_Table_ID=c.AD_Table_ID) WHERE t.IsView='N' AND t.TableName NOT IN ('C_TaxDeclarationAcct') AND ((c.ColumnName=? AND c.IsKey='N') OR c.AD_Reference_Value_ID IN (SELECT rt.AD_Reference_ID FROM AD_Ref_Table rt INNER JOIN AD_Column cc ON (rt.AD_Table_ID=cc.AD_Table_ID AND rt.Column_Key_ID=cc.AD_Column_ID) WHERE cc.IsKey='Y' AND cc.ColumnName=?)) ORDER BY t.LoadSeq DESC";
        Statement pstmt = null;
        Savepoint sp = null;
        try {
            this.m_con = DB.createConnection((boolean)false, (int)2);
            sp = this.m_con.setSavepoint("merge");
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setString(1, ColumnName);
            pstmt.setString(2, ColumnName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                String tName = rs.getString(1);
                String cName = rs.getString(2);
                if (TableName.equals(tName)) continue;
                int count = this.mergeTable(tName, cName, from_ID, to_ID);
                if (count < 0) {
                    success = false;
                    continue;
                }
                this.m_totalCount += count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
            this.log.config("Success=" + success + " - " + ColumnName + " - From=" + from_ID + ",To=" + to_ID);
            if (success) {
                sql = "DELETE FROM " + TableName + " WHERE " + ColumnName + "=" + from_ID;
                Statement stmt = this.m_con.createStatement();
                int count = 0;
                try {
                    count = stmt.executeUpdate(sql);
                    if (count != 1) {
                        this.m_errorLog.append(Env.NL).append("DELETE FROM ").append(TableName).append(" - Count=").append(count);
                        success = false;
                    }
                }
                catch (SQLException ex1) {
                    this.m_errorLog.append(Env.NL).append("DELETE FROM ").append(TableName).append(" - ").append(ex1.toString());
                    success = false;
                }
                stmt.close();
                stmt = null;
            }
            if (success) {
                this.m_con.commit();
            } else {
                this.m_con.rollback(sp);
            }
            this.m_con.close();
            this.m_con = null;
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, ColumnName, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        pstmt = null;
        this.m_con = null;
        return success;
    }

    private int mergeTable(String TableName, String ColumnName, int from_ID, int to_ID) {
        this.log.fine(TableName + "." + ColumnName + " - From=" + from_ID + ",To=" + to_ID);
        String sql = "UPDATE " + TableName + " SET " + ColumnName + "=" + to_ID + " WHERE " + ColumnName + "=" + from_ID;
        boolean delete = false;
        for (int i = 0; i < this.m_deleteTables.length; ++i) {
            if (!this.m_deleteTables[i].equals(TableName)) continue;
            delete = true;
            sql = "DELETE FROM " + TableName + " WHERE " + ColumnName + "=" + from_ID;
        }
        int count = -1;
        try {
            Statement stmt = this.m_con.createStatement();
            try {
                count = stmt.executeUpdate(sql);
                this.log.fine(count + (delete ? " -Delete- " : " -Update- ") + TableName);
            }
            catch (SQLException ex1) {
                count = -1;
                this.m_errorLog.append(Env.NL).append(delete ? "DELETE FROM " : "UPDATE ").append(TableName).append(" - ").append(ex1.toString()).append(" - ").append(sql);
            }
            stmt.close();
            stmt = null;
        }
        catch (SQLException ex) {
            count = -1;
            this.m_errorLog.append(Env.NL).append(delete ? "DELETE FROM " : "UPDATE ").append(TableName).append(" - ").append(ex.toString()).append(" - ").append(sql);
        }
        return count;
    }

    private void postMerge(String ColumnName, int to_ID) {
        if (!ColumnName.equals(AD_ORG_ID) && !ColumnName.equals(AD_USER_ID)) {
            if (ColumnName.equals(C_BPARTNER_ID)) {
                MBPartner bp = new MBPartner(Env.getCtx(), to_ID, null);
                if (bp.get_ID() != 0) {
                    MPayment[] payments = MPayment.getOfBPartner(Env.getCtx(), bp.getC_BPartner_ID(), null);
                    for (int i = 0; i < payments.length; ++i) {
                        MPayment payment = payments[i];
                        if (!payment.testAllocation()) continue;
                        payment.save();
                    }
                    MInvoice[] invoices = MInvoice.getOfBPartner(Env.getCtx(), bp.getC_BPartner_ID(), null);
                    for (int i = 0; i < invoices.length; ++i) {
                        MInvoice invoice = invoices[i];
                        if (!invoice.testAllocation()) continue;
                        invoice.save();
                    }
                    bp.setTotalOpenBalance();
                    bp.setActualLifeTimeValue();
                    bp.save();
                }
            } else if (ColumnName.equals(M_PRODUCT_ID)) {
                // empty if block
            }
        }
    }
}

