/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MBPartner;
import org.compiere.model.MCharge;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPO;
import org.compiere.model.MRequisition;
import org.compiere.model.MRequisitionLine;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CompiereSystemException;
import org.compiere.util.CompiereUserException;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class RequisitionPOCreate
extends SvrProcess {
    private int p_AD_Org_ID = 0;
    private int p_M_Warehouse_ID = 0;
    private Timestamp p_DateDoc_From;
    private Timestamp p_DateDoc_To;
    private Timestamp p_DateRequired_From;
    private Timestamp p_DateRequired_To;
    private String p_PriorityRule = null;
    private int p_AD_User_ID = 0;
    private int p_M_Product_ID = 0;
    private int p_M_Requisition_ID = 0;
    private boolean p_ConsolidateDocument = false;
    private MOrder m_order = null;
    private MOrderLine m_orderLine = null;
    private int m_M_Requisition_ID = 0;
    private int m_M_Product_ID = 0;
    private int m_M_AttributeSetInstance_ID = 0;
    private MBPartner m_bpartner = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Warehouse_ID")) {
                this.p_M_Warehouse_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("DateDoc")) {
                this.p_DateDoc_From = (Timestamp)para[i].getParameter();
                this.p_DateDoc_To = (Timestamp)para[i].getParameter_To();
                continue;
            }
            if (name.equals("DateRequired")) {
                this.p_DateRequired_From = (Timestamp)para[i].getParameter();
                this.p_DateRequired_To = (Timestamp)para[i].getParameter_To();
                continue;
            }
            if (name.equals("PriorityRule")) {
                this.p_PriorityRule = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("AD_User_ID")) {
                this.p_AD_User_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("M_Requisition_ID")) {
                this.p_M_Requisition_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("ConsolidateDocument")) {
                this.p_ConsolidateDocument = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        if (this.p_M_Requisition_ID != 0) {
            this.log.info("M_Requisition_ID=" + this.p_M_Requisition_ID);
            MRequisition req = new MRequisition(this.getCtx(), this.p_M_Requisition_ID, this.get_TrxName());
            if (!"CO".equals(req.getDocStatus())) {
                throw new CompiereUserException("@DocStatus@ = " + req.getDocStatus());
            }
            MRequisitionLine[] lines = req.getLines();
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].getC_OrderLine_ID() != 0) continue;
                this.process(lines[i]);
            }
            this.closeOrder();
            return "";
        }
        this.log.info("AD_Org_ID=" + this.p_AD_Org_ID + ", M_Warehouse_ID=" + this.p_M_Warehouse_ID + ", DateDoc=" + this.p_DateDoc_From + "/" + this.p_DateDoc_To + ", DateRequired=" + this.p_DateRequired_From + "/" + this.p_DateRequired_To + ", PriorityRule=" + this.p_PriorityRule + ", AD_User_ID=" + this.p_AD_User_ID + ", M_Product_ID=" + this.p_M_Product_ID + ", ConsolidateDocument" + this.p_ConsolidateDocument);
        StringBuffer sql = new StringBuffer("SELECT * FROM M_RequisitionLine rl ").append("WHERE rl.C_OrderLine_ID IS NULL");
        if (this.p_AD_Org_ID != 0) {
            sql.append(" AND AD_Org_ID=?");
        }
        if (this.p_M_Product_ID != 0) {
            sql.append(" AND M_Product_ID=?");
        }
        sql.append(" AND EXISTS (SELECT * FROM M_Requisition r WHERE rl.M_Requisition_ID=r.M_Requisition_ID").append(" AND r.DocStatus='CO'");
        if (this.p_M_Warehouse_ID != 0) {
            sql.append(" AND r.M_Warehouse_ID=?");
        }
        if (this.p_DateDoc_From != null && this.p_DateDoc_To != null) {
            sql.append(" AND r.DateDoc BETWEEN ? AND ?");
        } else if (this.p_DateDoc_From != null) {
            sql.append(" AND r.DateDoc => ?");
        } else if (this.p_DateDoc_To != null) {
            sql.append(" AND r.DateDoc <= ?");
        }
        if (this.p_DateRequired_From != null && this.p_DateRequired_To != null) {
            sql.append(" AND r.DateRequired BETWEEN ? AND ?");
        } else if (this.p_DateRequired_From != null) {
            sql.append(" AND r.DateRequired => ?");
        } else if (this.p_DateRequired_To != null) {
            sql.append(" AND r.DateRequired <= ?");
        }
        if (this.p_PriorityRule != null) {
            sql.append(" AND r.PriorityRule => ?");
        }
        if (this.p_AD_User_ID != 0) {
            sql.append(" AND r.AD_User_ID=?");
        }
        sql.append(") ORDER BY ");
        if (!this.p_ConsolidateDocument) {
            sql.append("M_Requisition_ID, ");
        }
        sql.append("M_Product_ID, C_Charge_ID, M_AttributeSetInstance_ID");
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql.toString(), (String)this.get_TrxName());
            int index = 1;
            if (this.p_AD_Org_ID != 0) {
                pstmt.setInt(index++, this.p_AD_Org_ID);
            }
            if (this.p_M_Product_ID != 0) {
                pstmt.setInt(index++, this.p_M_Product_ID);
            }
            if (this.p_M_Warehouse_ID != 0) {
                pstmt.setInt(index++, this.p_M_Warehouse_ID);
            }
            if (this.p_DateDoc_From != null && this.p_DateDoc_To != null) {
                pstmt.setTimestamp(index++, this.p_DateDoc_From);
                pstmt.setTimestamp(index++, this.p_DateDoc_To);
            } else if (this.p_DateDoc_From != null) {
                pstmt.setTimestamp(index++, this.p_DateDoc_From);
            } else if (this.p_DateDoc_To != null) {
                pstmt.setTimestamp(index++, this.p_DateDoc_To);
            }
            if (this.p_DateRequired_From != null && this.p_DateRequired_To != null) {
                pstmt.setTimestamp(index++, this.p_DateRequired_From);
                pstmt.setTimestamp(index++, this.p_DateRequired_To);
            } else if (this.p_DateRequired_From != null) {
                pstmt.setTimestamp(index++, this.p_DateRequired_From);
            } else if (this.p_DateRequired_To != null) {
                pstmt.setTimestamp(index++, this.p_DateRequired_To);
            }
            if (this.p_PriorityRule != null) {
                pstmt.setString(index++, this.p_PriorityRule);
            }
            if (this.p_AD_User_ID != 0) {
                pstmt.setInt(index++, this.p_AD_User_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.process(new MRequisitionLine(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.closeOrder();
        return "";
    }

    private void process(MRequisitionLine rLine) throws Exception {
        if (rLine.getM_Product_ID() == 0 && rLine.getC_Charge_ID() == 0) {
            this.log.warning("Ignored Line" + rLine.getLine() + " " + rLine.getDescription() + " - " + rLine.getLineNetAmt());
            return;
        }
        if (!this.p_ConsolidateDocument && rLine.getM_Requisition_ID() != this.m_M_Requisition_ID) {
            this.closeOrder();
        }
        if (this.m_orderLine == null || rLine.getM_Product_ID() != this.m_M_Product_ID || rLine.getM_AttributeSetInstance_ID() != this.m_M_AttributeSetInstance_ID || rLine.getC_Charge_ID() != 0) {
            this.newLine(rLine);
        }
        this.m_orderLine.setQty(this.m_orderLine.getQtyOrdered().add(rLine.getQty()));
        rLine.setC_OrderLine_ID(this.m_orderLine.getC_OrderLine_ID());
        if (!rLine.save()) {
            throw new CompiereSystemException("Cannot update Request Line");
        }
    }

    private void newOrder(MRequisitionLine rLine, int C_BPartner_ID) throws Exception {
        if (this.m_order != null) {
            this.closeOrder();
        }
        if (this.m_bpartner == null || C_BPartner_ID != this.m_bpartner.getC_BPartner_ID()) {
            this.m_bpartner = new MBPartner(this.getCtx(), C_BPartner_ID, null);
        }
        this.m_order = new MOrder(this.getCtx(), 0, this.get_TrxName());
        this.m_order.setIsSOTrx(false);
        this.m_order.setC_DocTypeTarget_ID();
        this.m_order.setBPartner(this.m_bpartner);
        if (!this.p_ConsolidateDocument) {
            this.m_order.setDescription(Msg.getElement((Ctx)this.getCtx(), (String)"M_Requisition_ID") + ": " + rLine.getParent().getDocumentNo());
        }
        this.m_M_Requisition_ID = rLine.getM_Requisition_ID();
        MRequisition requisition = new MRequisition(this.getCtx(), this.m_M_Requisition_ID, this.get_TrxName());
        this.m_order.setSalesRep_ID(requisition.getAD_User_ID());
        if (!this.m_order.save()) {
            throw new CompiereSystemException("Cannot save Order");
        }
    }

    private void closeOrder() throws Exception {
        if (this.m_orderLine != null && !this.m_orderLine.save()) {
            throw new CompiereSystemException("Cannot update Order Line");
        }
        if (this.m_order != null) {
            this.m_order.load(this.get_TrxName());
            this.addLog(0, null, this.m_order.getGrandTotal(), this.m_order.getDocumentNo());
        }
        this.m_order = null;
        this.m_orderLine = null;
    }

    private void newLine(MRequisitionLine rLine) throws Exception {
        if (this.m_orderLine != null && !this.m_orderLine.save()) {
            throw new CompiereSystemException("Cannot update Order Line");
        }
        this.m_orderLine = null;
        MProduct product = null;
        int C_BPartner_ID = rLine.getC_BPartner_ID();
        if (C_BPartner_ID == 0) {
            if (rLine.getC_Charge_ID() != 0) {
                MCharge charge = MCharge.get(this.getCtx(), rLine.getC_Charge_ID());
                C_BPartner_ID = charge.getC_BPartner_ID();
                if (C_BPartner_ID == 0) {
                    throw new CompiereUserException("No Vendor for Charge " + charge.getName());
                }
            } else {
                product = MProduct.get(this.getCtx(), rLine.getM_Product_ID());
                MProductPO[] ppos = MProductPO.getOfProduct(this.getCtx(), product.getM_Product_ID(), null);
                for (int i = 0; i < ppos.length; ++i) {
                    if (!ppos[i].isCurrentVendor() || ppos[i].getC_BPartner_ID() == 0) continue;
                    C_BPartner_ID = ppos[i].getC_BPartner_ID();
                    break;
                }
                if (C_BPartner_ID == 0 && ppos.length > 0) {
                    C_BPartner_ID = ppos[0].getC_BPartner_ID();
                }
                if (C_BPartner_ID == 0) {
                    throw new CompiereUserException("No Vendor for " + product.getName());
                }
            }
        }
        if (this.m_order == null || this.m_order.getC_BPartner_ID() != C_BPartner_ID) {
            this.newOrder(rLine, C_BPartner_ID);
        }
        this.m_orderLine = new MOrderLine(this.m_order);
        if (product != null) {
            this.m_orderLine.setProduct(product);
            this.m_orderLine.setM_AttributeSetInstance_ID(rLine.getM_AttributeSetInstance_ID());
        } else {
            this.m_orderLine.setC_Charge_ID(rLine.getC_Charge_ID());
            this.m_orderLine.setPriceActual(rLine.getPriceActual());
        }
        this.m_orderLine.setAD_Org_ID(rLine.getAD_Org_ID());
        this.m_M_Product_ID = rLine.getM_Product_ID();
        this.m_M_AttributeSetInstance_ID = rLine.getM_AttributeSetInstance_ID();
        if (!this.m_orderLine.save()) {
            throw new CompiereSystemException("Cannot save Order Line");
        }
    }
}

