/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MInterestArea;
import org.compiere.model.MMailText;
import org.compiere.model.MStore;
import org.compiere.model.MUser;
import org.compiere.model.MUserMail;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.EMail;
import org.compiere.util.Msg;

public class SendMailText
extends SvrProcess {
    private int m_R_MailText_ID = -1;
    private MMailText m_MailText = null;
    private int m_AD_User_ID = -1;
    private MClient m_client = null;
    private MUser m_from = null;
    private ArrayList<Integer> m_list = new ArrayList();
    private int m_counter = 0;
    private int m_errors = 0;
    private int m_R_InterestArea_ID = -1;
    private MInterestArea m_ia = null;
    private int m_C_BP_Group_ID = -1;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("R_InterestArea_ID")) {
                this.m_R_InterestArea_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("R_MailText_ID")) {
                this.m_R_MailText_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("C_BP_Group_ID")) {
                this.m_C_BP_Group_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_User_ID")) {
                this.m_AD_User_ID = para[i].getParameterAsInt();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("R_MailText_ID=" + this.m_R_MailText_ID);
        this.m_MailText = new MMailText(this.getCtx(), this.m_R_MailText_ID, this.get_TrxName());
        if (this.m_MailText.getR_MailText_ID() == 0) {
            throw new Exception("Not found @R_MailText_ID@=" + this.m_R_MailText_ID);
        }
        this.m_client = MClient.get((Ctx)this.getCtx());
        if (this.m_client.getAD_Client_ID() == 0) {
            throw new Exception("Not found @AD_Client_ID@");
        }
        if (this.m_client.getSmtpHost() == null || this.m_client.getSmtpHost().length() == 0) {
            throw new Exception("No SMTP Host found");
        }
        if (this.m_AD_User_ID > 0) {
            this.m_from = new MUser(this.getCtx(), this.m_AD_User_ID, this.get_TrxName());
            if (this.m_from.getAD_User_ID() == 0) {
                throw new Exception("No found @AD_User_ID@=" + this.m_AD_User_ID);
            }
        }
        this.log.fine("From " + this.m_from);
        long start = System.currentTimeMillis();
        if (this.m_R_InterestArea_ID > 0) {
            this.sendInterestArea();
        }
        if (this.m_C_BP_Group_ID > 0) {
            this.sendBPGroup();
        }
        return "@Created@=" + this.m_counter + ", @Errors@=" + this.m_errors + " - " + (System.currentTimeMillis() - start) + "ms";
    }

    private void sendInterestArea() {
        this.log.info("R_InterestArea_ID=" + this.m_R_InterestArea_ID);
        this.m_ia = MInterestArea.get(this.getCtx(), this.m_R_InterestArea_ID);
        String unsubscribe = null;
        if (this.m_ia.isSelfService()) {
            unsubscribe = "\n\n---------.----------.----------.----------.----------.----------\n" + Msg.getElement((Ctx)this.getCtx(), (String)"R_InterestArea_ID") + ": " + this.m_ia.getName() + "\n" + Msg.getMsg((Ctx)this.getCtx(), (String)"UnsubscribeInfo") + "\n";
            MStore[] wstores = MStore.getOfClient(this.m_client);
            int index = 0;
            for (int i = 0; i < wstores.length; ++i) {
                if (!wstores[i].isDefault()) continue;
                index = i;
                break;
            }
            if (wstores.length > 0) {
                unsubscribe = unsubscribe + wstores[index].getWebContext(true);
            }
        }
        String sql = "SELECT u.Name, u.EMail, u.AD_User_ID FROM R_ContactInterest ci INNER JOIN AD_User u ON (ci.AD_User_ID=u.AD_User_ID) WHERE ci.IsActive='Y' AND u.IsActive='Y' AND ci.OptOutDate IS NULL AND u.EMail IS NOT NULL AND ci.R_InterestArea_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.m_R_InterestArea_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Boolean ok = this.sendIndividualMail(rs.getString(1), rs.getInt(3), unsubscribe);
                if (ok == null) continue;
                if (ok.booleanValue()) {
                    ++this.m_counter;
                    continue;
                }
                ++this.m_errors;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        this.m_ia = null;
    }

    private void sendBPGroup() {
        this.log.info("C_BP_Group_ID=" + this.m_C_BP_Group_ID);
        String sql = "SELECT u.Name, u.EMail, u.AD_User_ID FROM AD_User u INNER JOIN C_BPartner bp ON (u.C_BPartner_ID=bp.C_BPartner_ID) WHERE u.IsActive='Y' AND bp.IsActive='Y' AND u.EMail IS NOT NULL AND bp.C_BP_Group_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.m_C_BP_Group_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                Boolean ok = this.sendIndividualMail(rs.getString(1), rs.getInt(3), null);
                if (ok == null) continue;
                if (ok.booleanValue()) {
                    ++this.m_counter;
                    continue;
                }
                ++this.m_errors;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        pstmt = null;
    }

    private Boolean sendIndividualMail(String Name2, int AD_User_ID, String unsubscribe) {
        EMail email;
        Integer ii = new Integer(AD_User_ID);
        if (this.m_list.contains(ii)) {
            return null;
        }
        this.m_list.add(ii);
        MUser to = new MUser(this.getCtx(), AD_User_ID, null);
        if (to.isEMailBounced()) {
            return null;
        }
        this.m_MailText.setUser(AD_User_ID);
        String message = this.m_MailText.getMailText(true);
        if (unsubscribe != null) {
            message = message + unsubscribe;
        }
        if ((email = this.m_client.createEMail(this.m_from, to, this.m_MailText.getMailHeader(), message)) == null) {
            return Boolean.FALSE;
        }
        if (this.m_MailText.isHtml()) {
            email.setMessageHTML(this.m_MailText.getMailHeader(), message);
        } else {
            email.setSubject(this.m_MailText.getMailHeader());
            email.setMessageText(message);
        }
        if (!email.isValid() && !email.isValid(true)) {
            this.log.warning("NOT VALID - " + email);
            to.setIsActive(false);
            to.addDescription("Invalid EMail");
            to.save();
            return Boolean.FALSE;
        }
        boolean OK = "OK".equals(email.send());
        new MUserMail(this.m_MailText, AD_User_ID, email).save();
        if (OK) {
            this.log.fine(to.getEMail());
        } else {
            this.log.warning("FAILURE - " + to.getEMail());
        }
        this.addLog(0, null, null, (OK ? "@OK@" : "@ERROR@") + " - " + to.getEMail());
        return new Boolean(OK);
    }
}

