/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.CompiereUserException;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class TranslationDocSync
extends SvrProcess {
    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        MClient client = MClient.get((Ctx)this.getCtx());
        if (client.isMultiLingualDocument()) {
            throw new CompiereUserException("@AD_Client_ID@: @IsMultiLingualDocument@");
        }
        this.log.info("" + client);
        String sql = "SELECT * FROM AD_Table WHERE TableName LIKE '%_Trl' AND TableName NOT LIKE 'AD%' ORDER BY TableName";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.processTable(new MTable(this.getCtx(), rs, null), client.getAD_Client_ID());
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return "OK";
    }

    private void processTable(MTable table2, int AD_Client_ID) {
        StringBuffer sql = new StringBuffer();
        MColumn[] columns = table2.getColumns(false);
        for (int i = 0; i < columns.length; ++i) {
            MColumn column = columns[i];
            if (column.getAD_Reference_ID() != 10 && column.getAD_Reference_ID() != 14) continue;
            String columnName = column.getColumnName();
            if (sql.length() != 0) {
                sql.append(",");
            }
            sql.append(columnName);
        }
        String baseTable = table2.getTableName();
        baseTable = baseTable.substring(0, baseTable.length() - 4);
        this.log.config(baseTable + ": " + sql);
        String columnNames = sql.toString();
        sql = new StringBuffer();
        sql.append("UPDATE ").append(table2.getTableName()).append(" t SET (").append(columnNames).append(") = (SELECT ").append(columnNames).append(" FROM ").append(baseTable).append(" b WHERE t.").append(baseTable).append("_ID=b.").append(baseTable).append("_ID) WHERE AD_Client_ID=").append(AD_Client_ID);
        int no = DB.executeUpdate((String)sql.toString(), (String)this.get_TrxName());
        this.addLog(0, null, new BigDecimal(no), baseTable);
    }
}

