/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.logging.Level;
import org.compiere.model.MColumn;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.SecureEngine;
import org.compiere.util.Util;

public class UserPassword
extends SvrProcess {
    private int p_AD_User_ID = -1;
    private String p_OldPassword = null;
    private String p_CurrentPassword = null;
    private String p_NewPassword = null;
    private String p_NewEMail = null;
    private String p_NewEMailUser = null;
    private String p_NewEMailUserPW = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("AD_User_ID")) {
                this.p_AD_User_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("OldPassword")) {
                this.p_OldPassword = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("CurrentPassword")) {
                this.p_CurrentPassword = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("NewPassword")) {
                this.p_NewPassword = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("NewEMail")) {
                this.p_NewEMail = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("NewEMailUser")) {
                this.p_NewEMailUser = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("NewEMailUserPW")) {
                this.p_NewEMailUserPW = (String)para[i].getParameter();
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
    }

    protected String doIt() throws Exception {
        this.log.info("AD_User_ID=" + this.p_AD_User_ID + " from " + this.getAD_User_ID());
        if (this.p_AD_User_ID == -1) {
            this.p_AD_User_ID = this.getAD_User_ID();
        }
        MUser user = MUser.get((Ctx)this.getCtx(), (int)this.p_AD_User_ID);
        MUser operator = MUser.get((Ctx)this.getCtx(), (int)this.getAD_User_ID());
        this.log.fine("User=" + user + ", Operator=" + operator);
        if (!operator.isAdministrator() && this.p_AD_User_ID != this.getAD_User_ID() && user.hasRole()) {
            throw new IllegalArgumentException("@UserCannotUpdate@");
        }
        if (user.isSystemAdministrator() && this.p_AD_User_ID != this.getAD_User_ID()) {
            throw new IllegalArgumentException("@UserCannotUpdate@");
        }
        if (Util.isEmpty((String)this.p_CurrentPassword)) {
            if (Util.isEmpty((String)this.p_OldPassword)) {
                throw new IllegalArgumentException("@OldPasswordMandatory@");
            }
            if (!this.p_OldPassword.equals(user.getPassword())) {
                throw new IllegalArgumentException("@OldPasswordNoMatch@");
            }
        } else {
            if (!operator.isAdministrator() && this.p_AD_User_ID != this.getAD_User_ID() && user.hasRole()) {
                throw new IllegalArgumentException("@UserCannotUpdate@");
            }
            if (!this.p_CurrentPassword.equals(operator.getPassword())) {
                throw new IllegalArgumentException("@OldPasswordNoMatch@");
            }
        }
        String sql = "UPDATE AD_User SET Updated=SysDate, UpdatedBy=" + this.getAD_User_ID();
        if (!Util.isEmpty((String)this.p_NewPassword)) {
            MColumn column = MColumn.get((Ctx)this.getCtx(), (int)417);
            if (column.isEncrypted()) {
                this.p_NewPassword = SecureEngine.encrypt((String)this.p_NewPassword);
            }
            sql = sql + ", Password=" + DB.TO_STRING((String)this.p_NewPassword);
        }
        if (!Util.isEmpty((String)this.p_NewEMail)) {
            sql = sql + ", Email=" + DB.TO_STRING((String)this.p_NewEMail);
        }
        if (!Util.isEmpty((String)this.p_NewEMailUser)) {
            sql = sql + ", EmailUser=" + DB.TO_STRING((String)this.p_NewEMailUser);
        }
        if (!Util.isEmpty((String)this.p_NewEMailUserPW)) {
            sql = sql + ", EmailUserPW=" + DB.TO_STRING((String)this.p_NewEMailUserPW);
        }
        if (DB.executeUpdate((String)(sql = sql + " WHERE AD_User_ID=" + this.p_AD_User_ID), (String)this.get_TrxName()) == 1) {
            user.setPassword(this.p_NewPassword);
            return "OK";
        }
        return "@Error@";
    }
}

