/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.sql.Timestamp;
import org.compiere.util.DB;

public class FinReportPeriod {
    private int m_C_Period_ID;
    private String m_Name;
    private Timestamp m_StartDate;
    private Timestamp m_EndDate;
    private Timestamp m_YearStartDate;

    public FinReportPeriod(int C_Period_ID, String Name2, Timestamp StartDate, Timestamp EndDate, Timestamp YearStartDate) {
        this.m_C_Period_ID = C_Period_ID;
        this.m_Name = Name2;
        this.m_StartDate = StartDate;
        this.m_EndDate = EndDate;
        this.m_YearStartDate = YearStartDate;
    }

    public String getPeriodWhere() {
        StringBuffer sql = new StringBuffer("BETWEEN ");
        sql.append(DB.TO_DATE((Timestamp)this.m_StartDate)).append(" AND ").append(DB.TO_DATE((Timestamp)this.m_EndDate));
        return sql.toString();
    }

    public String getYearWhere() {
        StringBuffer sql = new StringBuffer("BETWEEN ");
        sql.append(DB.TO_DATE((Timestamp)this.m_YearStartDate)).append(" AND ").append(DB.TO_DATE((Timestamp)this.m_EndDate));
        return sql.toString();
    }

    public String getTotalWhere() {
        StringBuffer sql = new StringBuffer("<= ");
        sql.append(DB.TO_DATE((Timestamp)this.m_EndDate));
        return sql.toString();
    }

    public boolean inPeriod(Timestamp date) {
        if (date == null) {
            return false;
        }
        if (date.before(this.m_StartDate)) {
            return false;
        }
        return !date.after(this.m_EndDate);
    }

    public String getName() {
        return this.m_Name;
    }

    public int getC_Period_ID() {
        return this.m_C_Period_ID;
    }

    public Timestamp getEndDate() {
        return this.m_EndDate;
    }

    public Timestamp getStartDate() {
        return this.m_StartDate;
    }

    public Timestamp getYearStartDate() {
        return this.m_YearStartDate;
    }
}

