/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import org.compiere.model.MElementValue;
import org.compiere.model.MPeriod;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.report.FinBalance;
import org.compiere.report.MReportTree;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Language;
import org.compiere.util.Msg;

public class FinStatement
extends SvrProcess {
    private int p_C_AcctSchema_ID = 0;
    private String p_PostingType = "A";
    private int p_C_Period_ID = 0;
    private Timestamp p_DateAcct_From = null;
    private Timestamp p_DateAcct_To = null;
    private int p_AD_Org_ID = 0;
    private int p_Account_ID = 0;
    private int p_C_BPartner_ID = 0;
    private int p_M_Product_ID = 0;
    private int p_C_Project_ID = 0;
    private int p_C_Activity_ID = 0;
    private int p_C_SalesRegion_ID = 0;
    private int p_C_Campaign_ID = 0;
    private boolean p_UpdateBalances = true;
    private int p_PA_Hierarchy_ID = 0;
    private StringBuffer m_parameterWhere = new StringBuffer();
    private MElementValue m_acct = null;
    private long m_start = System.currentTimeMillis();

    protected void prepare() {
        StringBuffer sb = new StringBuffer("Record_ID=").append(this.getRecord_ID());
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            if (name.equals("C_AcctSchema_ID")) {
                this.p_C_AcctSchema_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("PostingType")) {
                this.p_PostingType = (String)para[i].getParameter();
                continue;
            }
            if (name.equals("C_Period_ID")) {
                this.p_C_Period_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("DateAcct")) {
                this.p_DateAcct_From = (Timestamp)para[i].getParameter();
                this.p_DateAcct_To = (Timestamp)para[i].getParameter_To();
                continue;
            }
            if (name.equals("PA_Hierarchy_ID")) {
                this.p_PA_Hierarchy_ID = para[i].getParameterAsInt();
                continue;
            }
            if (name.equals("AD_Org_ID")) {
                this.p_AD_Org_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("Account_ID")) {
                this.p_Account_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_BPartner_ID")) {
                this.p_C_BPartner_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("M_Product_ID")) {
                this.p_M_Product_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Project_ID")) {
                this.p_C_Project_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Activity_ID")) {
                this.p_C_Activity_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_SalesRegion_ID")) {
                this.p_C_SalesRegion_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("C_Campaign_ID")) {
                this.p_C_Campaign_ID = ((BigDecimal)para[i].getParameter()).intValue();
                continue;
            }
            if (name.equals("UpdateBalances")) {
                this.p_UpdateBalances = "Y".equals(para[i].getParameter());
                continue;
            }
            this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
        }
        this.m_parameterWhere.append("C_AcctSchema_ID=").append(this.p_C_AcctSchema_ID).append(" AND PostingType='").append(this.p_PostingType).append("'");
        if (this.p_Account_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "AC", this.p_Account_ID));
        }
        if (this.p_AD_Org_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "OO", this.p_AD_Org_ID));
        }
        if (this.p_C_BPartner_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "BP", this.p_C_BPartner_ID));
        }
        if (this.p_M_Product_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "PR", this.p_M_Product_ID));
        }
        if (this.p_C_Project_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "PJ", this.p_C_Project_ID));
        }
        if (this.p_C_Activity_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "AY", this.p_C_Activity_ID));
        }
        if (this.p_C_Campaign_ID != 0) {
            this.m_parameterWhere.append(" AND C_Campaign_ID=").append(this.p_C_Campaign_ID);
        }
        if (this.p_C_SalesRegion_ID != 0) {
            this.m_parameterWhere.append(" AND ").append(MReportTree.getWhereClause(this.getCtx(), this.p_PA_Hierarchy_ID, "SR", this.p_C_SalesRegion_ID));
        }
        this.setDateAcct();
        sb.append(" - DateAcct ").append(this.p_DateAcct_From).append("-").append(this.p_DateAcct_To);
        sb.append(" - Where=").append(this.m_parameterWhere);
        this.log.fine(sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDateAcct() {
        if (this.p_DateAcct_From != null) {
            if (this.p_DateAcct_To == null) {
                this.p_DateAcct_To = new Timestamp(System.currentTimeMillis());
            }
            return;
        }
        if (this.p_C_Period_ID == 0) {
            GregorianCalendar cal = new GregorianCalendar(Language.getLoginLanguage().getLocale());
            cal.setTimeInMillis(System.currentTimeMillis());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(5, 1);
            this.p_DateAcct_From = new Timestamp(cal.getTimeInMillis());
            cal.add(2, 1);
            cal.add(6, -1);
            this.p_DateAcct_To = new Timestamp(cal.getTimeInMillis());
            return;
        }
        String sql = "SELECT StartDate, EndDate FROM C_Period WHERE C_Period_ID=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, null);
            pstmt.setInt(1, this.p_C_Period_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                this.p_DateAcct_From = rs.getTimestamp(1);
                this.p_DateAcct_To = rs.getTimestamp(2);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
            pstmt = null;
        }
    }

    protected String doIt() {
        if (this.p_UpdateBalances) {
            FinBalance.updateBalance(this.p_C_AcctSchema_ID, false);
        }
        this.createBalanceLine();
        this.createDetailLines();
        int AD_PrintFormat_ID = 134;
        if (Ini.isClient()) {
            this.getProcessInfo().setTransientObject((Object)MPrintFormat.get((Ctx)this.getCtx(), (int)AD_PrintFormat_ID, (boolean)false));
        } else {
            this.getProcessInfo().setSerializableObject((Serializable)MPrintFormat.get((Ctx)this.getCtx(), (int)AD_PrintFormat_ID, (boolean)false));
        }
        this.log.fine(System.currentTimeMillis() - this.m_start + " ms");
        return "";
    }

    private void createBalanceLine() {
        StringBuffer sb = new StringBuffer("INSERT INTO T_ReportStatement (AD_PInstance_ID, Fact_Acct_ID, LevelNo,DateAcct, Name, Description,AmtAcctDr, AmtAcctCr, Balance, Qty) ");
        sb.append("SELECT ").append(this.getAD_PInstance_ID()).append(",0,0,").append(DB.TO_DATE((Timestamp)this.p_DateAcct_From, (boolean)true)).append(",").append(DB.TO_STRING((String)Msg.getMsg((Ctx)Env.getCtx(), (String)"BeginningBalance"))).append(",NULL,COALESCE(SUM(AmtAcctDr),0), COALESCE(SUM(AmtAcctCr),0), COALESCE(SUM(AmtAcctDr-AmtAcctCr),0), COALESCE(SUM(Qty),0) FROM Fact_Acct_Balance WHERE ").append(this.m_parameterWhere).append(" AND DateAcct < ").append(DB.TO_DATE((Timestamp)this.p_DateAcct_From));
        if (this.p_Account_ID > 0) {
            this.m_acct = new MElementValue(this.getCtx(), this.p_Account_ID, this.get_TrxName());
            if (!this.m_acct.isBalanceSheet()) {
                MPeriod first = MPeriod.getFirstInYear(this.getCtx(), this.p_DateAcct_From);
                if (first != null) {
                    sb.append(" AND DateAcct >= ").append(DB.TO_DATE((Timestamp)first.getStartDate()));
                } else {
                    this.log.log(Level.SEVERE, "First period not found");
                }
            }
        }
        int no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
        this.log.fine("#" + no + " (Account_ID=" + this.p_Account_ID + ")");
        this.log.finest(sb.toString());
    }

    private void createDetailLines() {
        StringBuffer sb = new StringBuffer("INSERT INTO T_ReportStatement (AD_PInstance_ID, Fact_Acct_ID, LevelNo,DateAcct, Name, Description,AmtAcctDr, AmtAcctCr, Balance, Qty) ");
        sb.append("SELECT ").append(this.getAD_PInstance_ID()).append(",Fact_Acct_ID,1,").append("DateAcct,NULL,NULL,AmtAcctDr, AmtAcctCr, AmtAcctDr-AmtAcctCr, Qty FROM Fact_Acct WHERE ").append(this.m_parameterWhere).append(" AND DateAcct BETWEEN ").append(DB.TO_DATE((Timestamp)this.p_DateAcct_From)).append(" AND ").append(DB.TO_DATE((Timestamp)this.p_DateAcct_To));
        int no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
        this.log.fine("#" + no);
        this.log.finest(sb.toString());
        String sql_select = "SELECT e.Name, fa.Description FROM Fact_Acct fa INNER JOIN AD_Table t ON (fa.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Element e ON (t.TableName||'_ID'=e.ColumnName) WHERE r.Fact_Acct_ID=fa.Fact_Acct_ID";
        sb = new StringBuffer("UPDATE T_ReportStatement r SET (Name,Description)=(").append(sql_select).append(") WHERE Fact_Acct_ID <> 0 AND AD_PInstance_ID=").append(this.getAD_PInstance_ID());
        no = DB.executeUpdate((String)sb.toString(), (String)this.get_TrxName());
        this.log.fine("Name #" + no);
        this.log.finest("Name - " + sb);
    }
}

