/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.X_PA_ReportColumn;
import org.compiere.report.MReportTree;
import org.compiere.util.Ctx;

public class MReportColumn
extends X_PA_ReportColumn {
    static final String AmountType_Balance = "B";
    static final String AmountType_CR = "C";
    static final String AmountType_DR = "D";
    static final String AmountType_Qty = "Q";
    static final String AmountType_Period = "P";
    static final String AmountType_Year = "Y";
    static final String AmountType_Total = "T";

    public static MReportColumn copy(Ctx ctx, int AD_Client_ID, int AD_Org_ID, int PA_ReportColumnSet_ID, MReportColumn source, String trxName) {
        MReportColumn retValue = new MReportColumn(ctx, 0, trxName);
        MReportColumn.copyValues((PO)source, (PO)retValue, (int)AD_Client_ID, (int)AD_Org_ID);
        retValue.setPA_ReportColumnSet_ID(PA_ReportColumnSet_ID);
        retValue.setOper_1_ID(0);
        retValue.setOper_2_ID(0);
        return retValue;
    }

    public MReportColumn(Ctx ctx, int PA_ReportColumn_ID, String trxName) {
        super(ctx, PA_ReportColumn_ID, trxName);
        if (PA_ReportColumn_ID == 0) {
            this.setIsPrinted(true);
            this.setSeqNo(0);
        }
    }

    public MReportColumn(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public String getSelectClause(boolean withSum) {
        String amountType = this.getAmountType().substring(0, 1);
        StringBuffer sb = new StringBuffer();
        if (withSum) {
            sb.append("SUM(");
        }
        if (AmountType_Balance.equals(amountType)) {
            sb.append("acctBalance(Account_ID,AmtAcctDr,AmtAcctCr)");
        } else if (AmountType_CR.equals(amountType)) {
            sb.append("AmtAcctCr");
        } else if (AmountType_DR.equals(amountType)) {
            sb.append("AmtAcctDr");
        } else if (AmountType_Qty.equals(amountType)) {
            sb.append("Qty");
        } else {
            this.log.log(Level.SEVERE, "AmountType=" + this.getAmountType() + ", at=" + amountType);
            return "NULL";
        }
        if (withSum) {
            sb.append(")");
        }
        return sb.toString();
    }

    public boolean isPeriod() {
        String at = this.getAmountType();
        if (at == null) {
            return false;
        }
        return "BP".equals(at) || "CP".equals(at) || "DP".equals(at) || "QP".equals(at);
    }

    public boolean isYear() {
        String at = this.getAmountType();
        if (at == null) {
            return false;
        }
        return "BY".equals(at) || "CY".equals(at) || "DY".equals(at) || "QY".equals(at);
    }

    public boolean isTotal() {
        String at = this.getAmountType();
        if (at == null) {
            return false;
        }
        return "BT".equals(at) || "CT".equals(at) || "DT".equals(at) || "QT".equals(at);
    }

    public String getWhereClause(int PA_Hierarchy_ID) {
        if (!this.isColumnTypeSegmentValue()) {
            return "";
        }
        String et = this.getElementType();
        int ID = 0;
        if ("OO".equals(et)) {
            ID = this.getOrg_ID();
        } else if ("BP".equals(et)) {
            ID = this.getC_BPartner_ID();
        } else if ("PR".equals(et)) {
            ID = this.getM_Product_ID();
        } else if ("PJ".equals(et)) {
            ID = this.getC_Project_ID();
        } else if ("AY".equals(et)) {
            ID = this.getC_Activity_ID();
        } else if ("MC".equals(et)) {
            ID = this.getC_Campaign_ID();
        } else if ("LF".equals(et)) {
            ID = this.getC_Location_ID();
        } else if ("LT".equals(et)) {
            ID = this.getC_Location_ID();
        } else if ("OT".equals(et)) {
            ID = this.getOrg_ID();
        } else if ("SR".equals(et)) {
            ID = this.getC_SalesRegion_ID();
        } else if ("AC".equals(et)) {
            ID = this.getC_ElementValue_ID();
        } else if ("U1".equals(et)) {
            ID = this.getC_ElementValue_ID();
        } else if ("U2".equals(et)) {
            ID = this.getC_ElementValue_ID();
        } else {
            this.log.warning("Unsupported Element Type=" + et);
        }
        if (ID == 0) {
            this.log.fine("No Restrictions - No ID for EntityType=" + et);
            return "";
        }
        return " AND " + MReportTree.getWhereClause(this.getCtx(), PA_Hierarchy_ID, et, ID);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MReportColumn[").append(this.get_ID()).append(" - ").append(this.getName()).append(" - ").append(this.getDescription()).append(", SeqNo=").append(this.getSeqNo()).append(", AmountType=").append(this.getAmountType()).append(", CurrencyType=").append(this.getCurrencyType()).append("/").append(this.getC_Currency_ID()).append(" - ColumnType=").append(this.getColumnType());
        if (this.isColumnTypeCalculation()) {
            sb.append(" - Calculation=").append(this.getCalculationType()).append(" - ").append(this.getOper_1_ID()).append(" - ").append(this.getOper_2_ID());
        } else if (this.isColumnTypeRelativePeriod()) {
            sb.append(" - Period=").append(this.getRelativePeriod());
        } else {
            sb.append(" - SegmentValue ElementType=").append(this.getElementType());
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean isCalculationTypeRange() {
        return "R".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeAdd() {
        return "A".equals(this.getCalculationType());
    }

    public boolean isCalculationTypeSubtract() {
        return "S".equals(this.getCalculationType());
    }

    public boolean isCalculationTypePercent() {
        return AmountType_Period.equals(this.getCalculationType());
    }

    public boolean isColumnTypeCalculation() {
        return AmountType_CR.equals(this.getColumnType());
    }

    public boolean isColumnTypeRelativePeriod() {
        return "R".equals(this.getColumnType());
    }

    public boolean isColumnTypeSegmentValue() {
        return "S".equals(this.getColumnType());
    }

    public int getRelativePeriodAsInt() {
        BigDecimal bd = this.getRelativePeriod();
        if (bd == null) {
            return 0;
        }
        return bd.intValue();
    }

    public BigDecimal getRelativePeriod() {
        if (this.getColumnType().equals("R") || this.getColumnType().equals("S")) {
            return super.getRelativePeriod();
        }
        return null;
    }

    public String getElementType() {
        if (this.getColumnType().equals("S")) {
            return super.getElementType();
        }
        return null;
    }

    public String getCalculationType() {
        if (this.getColumnType().equals(AmountType_CR)) {
            return super.getCalculationType();
        }
        return null;
    }

    protected boolean beforeSave(boolean newRecord) {
        String ct = this.getColumnType();
        if (ct.equals("R")) {
            this.setElementType(null);
            this.setCalculationType(null);
        } else if (ct.equals(AmountType_CR)) {
            this.setElementType(null);
            this.setRelativePeriod(null);
        } else if (ct.equals("S")) {
            this.setCalculationType(null);
        }
        return true;
    }
}

