/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.model.X_PA_ReportColumnSet;
import org.compiere.report.MReportColumn;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class MReportColumnSet
extends X_PA_ReportColumnSet {
    private MReportColumn[] m_columns = null;

    public MReportColumnSet(Ctx ctx, int PA_ReportColumnSet_ID, String trxName) {
        super(ctx, PA_ReportColumnSet_ID, trxName);
        if (PA_ReportColumnSet_ID != 0) {
            this.loadColumns();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadColumns() {
        ArrayList<MReportColumn> list = new ArrayList<MReportColumn>();
        String sql = "SELECT * FROM PA_ReportColumn WHERE PA_ReportColumnSet_ID=? AND IsActive='Y' ORDER BY SeqNo";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getPA_ReportColumnSet_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MReportColumn(this.getCtx(), rs, null));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception e) {}
            pstmt = null;
        }
        this.m_columns = new MReportColumn[list.size()];
        list.toArray(this.m_columns);
        this.log.finest("ID=" + this.getPA_ReportColumnSet_ID() + " - Size=" + list.size());
    }

    public MReportColumn[] getColumns() {
        return this.m_columns;
    }

    public void list() {
        System.out.println(this.toString());
        if (this.m_columns == null) {
            return;
        }
        for (int i = 0; i < this.m_columns.length; ++i) {
            System.out.println("- " + this.m_columns[i].toString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MReportColumnSet[").append(this.get_ID()).append(" - ").append(this.getName()).append("]");
        return sb.toString();
    }
}

