/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.sla;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.compiere.model.MSLACriteria;
import org.compiere.model.MSLAGoal;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.sla.SLACriteria;
import org.compiere.util.CompiereUserException;

public class SLAGoalProcess
extends SvrProcess {
    private int p_PA_SLA_Goal_ID;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        for (int i = 0; i < para.length; ++i) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() == null) continue;
            this.log.log(Level.SEVERE, "prepare - Unknown Parameter: " + name);
        }
        this.p_PA_SLA_Goal_ID = this.getRecord_ID();
    }

    protected String doIt() throws Exception {
        this.log.info("PA_SLA_Goal_ID=" + this.p_PA_SLA_Goal_ID);
        MSLAGoal goal = new MSLAGoal(this.getCtx(), this.p_PA_SLA_Goal_ID, this.get_TrxName());
        if (goal.get_ID() == 0) {
            throw new CompiereUserException("@PA_SLA_Goal_ID@ " + this.p_PA_SLA_Goal_ID);
        }
        MSLACriteria criteria = MSLACriteria.get(this.getCtx(), goal.getPA_SLA_Criteria_ID(), this.get_TrxName());
        if (criteria.get_ID() == 0) {
            throw new CompiereUserException("@PA_SLA_Criteria_ID@ " + goal.getPA_SLA_Criteria_ID());
        }
        SLACriteria pgm = criteria.newInstance();
        int no = pgm.createMeasures(goal);
        goal.setMeasureActual(pgm.calculateMeasure(goal));
        goal.setDateLastRun(new Timestamp(System.currentTimeMillis()));
        goal.save();
        return "@Created@ " + no + " - @MeasureActual@=" + goal.getMeasureActual();
    }
}

