/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wf;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.framework.PO;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.X_AD_WF_Process;
import org.compiere.process.DocAction;
import org.compiere.process.ProcessInfo;
import org.compiere.process.StateEngine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWFResponsible;
import org.compiere.wf.MWorkflow;

public class MWFProcess
extends X_AD_WF_Process {
    private StateEngine m_state = null;
    private MWFActivity[] m_activities = null;
    private MWorkflow m_wf = null;
    private ProcessInfo m_pi = null;
    private PO m_po = null;
    private String m_processMsg = null;

    public MWFProcess(Ctx ctx, int AD_WF_Process_ID, String trxName) {
        super(ctx, AD_WF_Process_ID, trxName);
        if (AD_WF_Process_ID == 0) {
            throw new IllegalArgumentException("Cannot create new WF Process directly");
        }
        this.m_state = new StateEngine(this.getWFState());
    }

    public MWFProcess(Ctx ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        this.m_state = new StateEngine(this.getWFState());
    }

    public MWFProcess(MWorkflow wf, ProcessInfo pi) throws Exception {
        super(wf.getCtx(), 0, wf.get_TrxName());
        if (!TimeUtil.isValid((Timestamp)wf.getValidFrom(), (Timestamp)wf.getValidTo())) {
            throw new IllegalStateException("Workflow not valid");
        }
        this.m_wf = wf;
        this.m_pi = pi;
        this.setAD_Workflow_ID(wf.getAD_Workflow_ID());
        this.setPriority(wf.getPriority());
        super.setWFState("ON");
        this.setAD_Table_ID(wf.getAD_Table_ID());
        this.setRecord_ID(pi.getRecord_ID());
        if (this.getPO() == null) {
            this.setTextMsg("No PO with ID=" + pi.getRecord_ID());
            super.setWFState("CT");
        } else {
            this.setTextMsg(this.getPO());
        }
        if (wf.getAD_WF_Responsible_ID() == 0) {
            this.setAD_WF_Responsible_ID();
        } else {
            this.setAD_WF_Responsible_ID(wf.getAD_WF_Responsible_ID());
        }
        this.setUser_ID(pi.getAD_User_ID());
        this.m_state = new StateEngine(this.getWFState());
        this.setProcessed(false);
        this.getPO();
        if (this.m_po != null) {
            this.m_po.lock();
        }
    }

    public MWFActivity[] getActivities(boolean requery, boolean onlyActive) {
        if (!requery && this.m_activities != null) {
            return this.m_activities;
        }
        ArrayList<MWFActivity> list = new ArrayList<MWFActivity>();
        CPreparedStatement pstmt = null;
        String sql = "SELECT * FROM AD_WF_Activity WHERE AD_WF_Process_ID=?";
        if (onlyActive) {
            sql = sql + " AND Processed='N'";
        }
        try {
            pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
            pstmt.setInt(1, this.getAD_WF_Process_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MWFActivity(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, (Throwable)e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_activities = new MWFActivity[list.size()];
        list.toArray(this.m_activities);
        return this.m_activities;
    }

    public StateEngine getState() {
        return this.m_state;
    }

    public String[] getActionOptions() {
        return this.m_state.getActionOptions();
    }

    public void setWFState(String WFState) {
        if (this.m_state == null) {
            this.m_state = new StateEngine(this.getWFState());
        }
        if (this.m_state.isClosed()) {
            return;
        }
        if (this.getWFState().equals(WFState)) {
            return;
        }
        if (this.m_state.isValidNewState(WFState)) {
            this.log.fine(this.toString() + " => " + WFState);
            super.setWFState(WFState);
            this.m_state = new StateEngine(this.getWFState());
            if (this.m_state.isClosed()) {
                this.setProcessed(true);
            }
            this.save();
            if (this.m_state.isClosed()) {
                MWFActivity[] activities = this.getActivities(true, true);
                for (int i = 0; i < activities.length; ++i) {
                    if (!activities[i].isClosed()) {
                        activities[i].setTextMsg("Process:" + WFState);
                        activities[i].setWFState(WFState);
                    }
                    if (!activities[i].isProcessed()) {
                        activities[i].setProcessed(true);
                    }
                    activities[i].save();
                }
            }
        } else {
            this.log.log(Level.SEVERE, "Ignored Invalid Transformation " + this.toString() + " => " + WFState);
        }
    }

    public void checkActivities() {
        this.log.info(this.toString());
        if (this.m_state.isClosed()) {
            return;
        }
        MWFActivity[] activities = this.getActivities(true, true);
        String closedState = null;
        boolean suspended = false;
        boolean running = false;
        for (int i = 0; i < activities.length; ++i) {
            MWFActivity activity = activities[i];
            StateEngine activityState = activity.getState();
            if (activityState.isCompleted() && this.startNext(activity, activities)) continue;
            String activityWFState = activity.getWFState();
            if (activityState.isClosed()) {
                activity.setProcessed(true);
                activity.save();
                if (closedState == null) {
                    closedState = activityWFState;
                    continue;
                }
                if (closedState.equals(activityState)) continue;
                if ("CT".equals(activityState)) {
                    closedState = activityWFState;
                    continue;
                }
                if (!"CA".equals(activityState) || "CT".equals(closedState)) continue;
                closedState = activityWFState;
                continue;
            }
            closedState = null;
            if (activityState.isSuspended()) {
                suspended = true;
            }
            if (!activityState.isRunning()) continue;
            running = true;
        }
        if (activities.length == 0) {
            this.setTextMsg("No Active Processed found");
            closedState = "CT";
        }
        if (closedState != null) {
            this.setWFState(closedState);
            this.getPO();
            if (this.m_po != null) {
                this.m_po.unlock(this.get_TrxName());
            }
        } else if (suspended) {
            this.setWFState("OS");
        } else if (running) {
            this.setWFState("OR");
        }
    }

    private boolean startNext(MWFActivity last, MWFActivity[] activities) {
        this.log.config("Last=" + last);
        MWFNodeNext[] transitions = this.getWorkflow().getNodeNexts(last.getAD_WF_Node_ID(), last.getAD_Client_ID());
        if (transitions == null || transitions.length == 0) {
            this.log.config("none");
            return false;
        }
        if ("A".equals(last.getNode().getJoinElement())) {
            // empty if block
        }
        last.setProcessed(true);
        last.save();
        String split = last.getNode().getSplitElement();
        for (int i = 0; i < transitions.length; ++i) {
            if (!transitions[i].isValidFor(last)) continue;
            MWFActivity activity = new MWFActivity(this, transitions[i].getAD_WF_Next_ID());
            new Thread(activity).start();
            if (!"X".equals(split)) continue;
            return true;
        }
        return true;
    }

    public void setAD_WF_Responsible_ID() {
        int AD_WF_Responsible_ID = DB.getSQLValue(null, (String)MRole.getDefault((Ctx)this.getCtx(), (boolean)false).addAccessSQL("SELECT AD_WF_Responsible_ID FROM AD_WF_Responsible WHERE ResponsibleType='H' AND COALESCE(AD_User_ID,0)=0 ORDER BY AD_Client_ID DESC", "AD_WF_Responsible", false, false));
        this.setAD_WF_Responsible_ID(AD_WF_Responsible_ID);
    }

    private void setUser_ID(Integer User_ID) {
        MWFResponsible resp = MWFResponsible.get(this.getCtx(), this.getAD_WF_Responsible_ID());
        int AD_User_ID = resp.getAD_User_ID();
        if (AD_User_ID == 0 && resp.isInvoker()) {
            Object sr;
            this.getPO();
            if (this.m_po != null && this.m_po instanceof DocAction) {
                DocAction da = (DocAction)this.m_po;
                AD_User_ID = da.getDoc_User_ID();
            }
            if (AD_User_ID == 0 && this.m_po != null && this.m_po.get_ColumnIndex("SalesRep_ID") != -1 && (sr = this.m_po.get_Value("SalesRep_ID")) != null && sr instanceof Integer) {
                AD_User_ID = (Integer)sr;
            }
            if (AD_User_ID == 0 && this.m_po != null) {
                AD_User_ID = this.m_po.getUpdatedBy();
            }
        }
        if (AD_User_ID == 0 && User_ID != null) {
            AD_User_ID = User_ID;
        }
        if (AD_User_ID == 0) {
            AD_User_ID = this.getCtx().getAD_User_ID();
        }
        this.setAD_User_ID(AD_User_ID);
    }

    private MWorkflow getWorkflow() {
        if (this.m_wf == null) {
            this.m_wf = MWorkflow.get(this.getCtx(), this.getAD_Workflow_ID());
        }
        if (this.m_wf.get_ID() == 0) {
            throw new IllegalStateException("Not found - AD_Workflow_ID=" + this.getAD_Workflow_ID());
        }
        return this.m_wf;
    }

    public boolean perform(String action) {
        if (!this.m_state.isValidAction(action)) {
            this.log.log(Level.SEVERE, "Ignored Invalid Transformation - Action=" + action + " - " + this.toString());
            return false;
        }
        this.log.fine(action);
        if ("Start".equals(action)) {
            return this.startWork();
        }
        this.setWFState(this.m_state.getNewStateIfAction(action));
        return true;
    }

    public boolean startWork() {
        if (!this.m_state.isValidAction("Start")) {
            this.log.warning("State=" + this.getWFState() + " - cannot start");
            return false;
        }
        int AD_WF_Node_ID = this.getWorkflow().getAD_WF_Node_ID();
        this.log.fine("AD_WF_Node_ID=" + AD_WF_Node_ID);
        this.setWFState("OR");
        try {
            MWFActivity activity = new MWFActivity(this, AD_WF_Node_ID);
            new Thread(activity).start();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "AD_WF_Node_ID=" + AD_WF_Node_ID, (Throwable)e);
            this.setTextMsg(e.toString());
            this.setWFState("CT");
            return false;
        }
        return true;
    }

    public PO getPO() {
        if (this.m_po != null) {
            return this.m_po;
        }
        if (this.getRecord_ID() == 0) {
            return null;
        }
        MTable table2 = MTable.get((Ctx)this.getCtx(), (int)this.getAD_Table_ID());
        this.m_po = table2.getPO(this.getCtx(), this.getRecord_ID(), this.get_TrxName());
        return this.m_po;
    }

    public void setTextMsg(PO po) {
        if (po != null && po instanceof DocAction) {
            this.setTextMsg(((DocAction)po).getSummary());
        }
    }

    public void setTextMsg(String TextMsg) {
        String oldText = this.getTextMsg();
        if (oldText == null || oldText.length() == 0) {
            super.setTextMsg(TextMsg);
        } else if (TextMsg != null && TextMsg.length() > 0) {
            super.setTextMsg(oldText + "\n - " + TextMsg);
        }
    }

    public void setProcessMsg(String msg) {
        this.m_processMsg = msg;
        if (msg != null && msg.length() > 0) {
            this.setTextMsg(msg);
        }
    }

    public String getProcessMsg() {
        return this.m_processMsg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("MWFProcess[").append(this.get_ID()).append(", AD_Workflow_ID=").append(this.getAD_Workflow_ID()).append(", WFState=").append(this.getWFState()).append("]");
        return sb.toString();
    }
}

