/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.compiere.common.constants.Build;
import org.compiere.util.CLoggerSimple;
import org.compiere.util.CompiereLogger;
import org.compiere.util.Evaluatee;

public class Ctx
implements Map,
Evaluatee,
Serializable {
    private static final long serialVersionUID = -411257863402987484L;
    protected Map m_map = new HashMap();
    public static CompiereLogger log = new CLoggerSimple(Ctx.class);

    public Ctx() {
    }

    public Ctx(Map map) {
        this();
        this.load(map);
    }

    public Ctx(String stringRepresentation) {
        this();
        this.load(stringRepresentation);
    }

    public Ctx(Set set) {
        this();
        this.load(set);
    }

    protected void load(String stringRepresentation) {
        if (stringRepresentation == null || !stringRepresentation.startsWith("{") || !stringRepresentation.endsWith("}")) {
            throw new IllegalArgumentException("Cannot load: " + stringRepresentation);
        }
        String string = stringRepresentation.substring(1, stringRepresentation.length() - 1);
        StringTokenizer st = new StringTokenizer(string, ",");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken().trim();
            if (pair.length() == 0) continue;
            int index = pair.indexOf("=");
            if (index == -1) {
                log.warning("Load invalid format: " + pair);
                continue;
            }
            String key = pair.substring(0, index);
            String value = pair.substring(index + 1);
            this.m_map.put(key, value);
        }
        log.info(this.toString());
    }

    private void load(Set set) {
        for (Map.Entry entry : set) {
            String key = entry.getKey().toString();
            this.setContext(key, (String)entry.getValue());
        }
    }

    private void load(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            String key = entry.getKey().toString();
            this.setContext(key, (String)entry.getValue());
        }
    }

    public Object setContext(String context, String value) {
        if (context == null) {
            return null;
        }
        log.finer(context + "=" + value);
        if (value == null || value.equals("")) {
            return this.m_map.put(context, null);
        }
        return this.m_map.put(context, value);
    }

    public Object setContext(String context, Date value) {
        String stringValue = null;
        if (value != null) {
            long time = value.getTime();
            stringValue = String.valueOf(time);
        }
        return this.setContext(context, stringValue);
    }

    public Object setContext(String context, int value) {
        return this.setContext(context, String.valueOf(value));
    }

    public Object setContext(String context, boolean value) {
        return this.setContext(context, value ? "Y" : "N");
    }

    public void setContext(int WindowNo, String context, String value) {
        if (context == null) {
            return;
        }
        if (Build.isVerbose()) {
            log.finer("(" + WindowNo + "): " + context + "=" + value);
        }
        if (value == null || value.equals("")) {
            this.m_map.put(WindowNo + "|" + context, null);
        } else {
            this.m_map.put(WindowNo + "|" + context, value);
        }
    }

    public void setContext(int WindowNo, Map addContext) {
        if (addContext == null) {
            return;
        }
        for (String key : addContext.keySet()) {
            String value = (String)addContext.get(key);
            this.setContext(WindowNo, key, value);
        }
    }

    public void setContext(int WindowNo, String context, Date value) {
        String stringValue = null;
        if (value != null) {
            long time = value.getTime();
            stringValue = String.valueOf(time);
        }
        this.setContext(WindowNo, context, stringValue);
    }

    public void setContext(int WindowNo, String context, int value) {
        this.setContext(WindowNo, context, String.valueOf(value));
    }

    public void setContext(int WindowNo, String context, boolean value) {
        this.setContext(WindowNo, context, value ? "Y" : "N");
    }

    public void setContext(int WindowNo, int TabNo, String context, String value) {
        if (context == null) {
            return;
        }
        log.finest("C(" + WindowNo + "," + TabNo + "): " + context + "=" + value);
        if (value == null || value.equals("")) {
            this.m_map.put(WindowNo + "|" + TabNo + "|" + context, null);
        } else {
            this.m_map.put(WindowNo + "|" + TabNo + "|" + context, value);
        }
    }

    public void setAutoCommit(boolean autoCommit) {
        this.m_map.put("AutoCommit", autoCommit ? "Y" : "N");
    }

    public void setAutoCommit(int WindowNo, boolean autoCommit) {
        this.setContext(WindowNo, "AutoCommit", autoCommit ? "Y" : "N");
    }

    public void setAutoNew(boolean autoNew) {
        this.m_map.put("AutoNew", autoNew ? "Y" : "N");
    }

    public void setAutoNew(int WindowNo, boolean autoNew) {
        this.setContext(WindowNo, "AutoNew", autoNew ? "Y" : "N");
    }

    public void setIsSOTrx(boolean isSOTrx) {
        this.m_map.put("IsSOTrx", isSOTrx ? "Y" : "N");
    }

    public void setIsSOTrx(int WindowNo, boolean isSOTrx) {
        this.setContext(WindowNo, "IsSOTrx", isSOTrx ? "Y" : "N");
    }

    public int getStdPrecision() {
        return this.getContextAsInt("#StdPrecision");
    }

    public void setStdPrecision(int precision) {
        this.setContext("#StdPrecision", precision);
    }

    public void setPrinterName(String printerName) {
        this.setContext("#Printer", printerName);
    }

    public String getPrinterName() {
        return this.getContext("#Printer");
    }

    public String getContext(String context) {
        if (context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Object value = this.m_map.get(context);
        if (value == null) {
            if (context.equals("#AD_User_ID")) {
                return this.getContext("#" + context);
            }
            return "";
        }
        String retValue = value.toString();
        return retValue;
    }

    public String getContext(int WindowNo, String context, boolean onlyWindow) {
        if (context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String key = WindowNo + "|" + context;
        if (WindowNo == 0) {
            key = context;
        }
        Object value = this.m_map.get(key);
        if (!this.m_map.containsKey(key)) {
            if (context.startsWith("#") || context.startsWith("$")) {
                return this.getContext(context);
            }
            if (onlyWindow) {
                return "";
            }
            return this.getContext("#" + context);
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public String getContext(int WindowNo, String context) {
        return this.getContext(WindowNo, context, false);
    }

    public String getContext(int WindowNo, int TabNo, String context) {
        if (context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        Object value = this.m_map.get(WindowNo + "|" + TabNo + "|" + context);
        if (value == null) {
            return this.getContext(WindowNo, context, false);
        }
        return value.toString();
    }

    public int getContextAsInt(String context) {
        if (context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String value = this.getContext(context);
        if (value.length() == 0) {
            value = this.getContext(0, context, false);
        }
        if (value.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            log.warning("(" + context + ") = " + value + " - " + e.getMessage());
            return 0;
        }
    }

    public int getContextAsInt(int WindowNo, String context) {
        String s = this.getContext(WindowNo, context, false);
        if (s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            log.warning("(" + context + ") = " + s + " - " + e.getMessage());
            return 0;
        }
    }

    public int getContextAsInt(int WindowNo, int TabNo, String context) {
        String s = this.getContext(WindowNo, TabNo, context);
        if (s.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            log.warning("(" + context + ") = " + s + " - " + e.getMessage());
            return 0;
        }
    }

    public boolean isAutoCommit() {
        String s = this.getContext("AutoCommit");
        return s != null && s.equals("Y");
    }

    public boolean isAutoCommit(int WindowNo) {
        String s = this.getContext(WindowNo, "AutoCommit", false);
        if (s != null) {
            return s.equals("Y");
        }
        return this.isAutoCommit();
    }

    public boolean isAutoNew() {
        String s = this.getContext("AutoNew");
        return s != null && s.equals("Y");
    }

    public boolean isAutoNew(int WindowNo) {
        String s = this.getContext(WindowNo, "AutoNew", false);
        if (s != null) {
            return s.equals("Y");
        }
        return this.isAutoNew();
    }

    public boolean isSOTrx() {
        String s = this.getContext("IsSOTrx");
        return s == null || !s.equals("N");
    }

    public boolean isSOTrx(int WindowNo) {
        String s = this.getContext(WindowNo, "IsSOTrx", true);
        return s == null || !s.equals("N");
    }

    public long getContextAsTime(String context) {
        return this.getContextAsTime(0, context);
    }

    public long getContextAsTime(int WindowNo, String context) {
        if (context == null) {
            throw new IllegalArgumentException("Require Context");
        }
        String s = this.getContext(WindowNo, context, false);
        if (s == null || s.equals("")) {
            log.warning("No value for: " + context);
            return System.currentTimeMillis();
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            log.warning("(" + context + ") = " + s + " - " + e.getMessage());
            return System.currentTimeMillis();
        }
    }

    public int getAD_Client_ID() {
        return this.getContextAsInt("#AD_Client_ID");
    }

    public void setAD_Client_ID(int AD_Client_ID) {
        this.setContext("#AD_Client_ID", AD_Client_ID);
    }

    public int getAD_Client_ID(int WindowNo) {
        return this.getContextAsInt(WindowNo, "AD_Client_ID");
    }

    public int getAD_Org_ID() {
        return this.getContextAsInt("#AD_Org_ID");
    }

    public void setAD_Org_ID(int AD_Org_ID) {
        this.setContext("#AD_Org_ID", AD_Org_ID);
    }

    public int getAD_Org_ID(int WindowNo) {
        return this.getContextAsInt(WindowNo, "AD_Org_ID");
    }

    public int getAD_Org_ID(int WindowNo, int TabNo) {
        return this.getContextAsInt(WindowNo, TabNo, "AD_Org_ID");
    }

    public int getAD_User_ID() {
        return this.getContextAsInt("##AD_User_ID");
    }

    public void setAD_User_ID(int AD_User_ID) {
        this.setContext("##AD_User_ID", AD_User_ID);
    }

    public int getAD_Role_ID() {
        return this.getContextAsInt("#AD_Role_ID");
    }

    public void setAD_Role_ID(int AD_Role_ID) {
        this.setContext("#AD_Role_ID", AD_Role_ID);
    }

    public boolean isProcessed(int WindowNo) {
        return "Y".equals(this.getContext(WindowNo, "Processed"));
    }

    public boolean isProcessing(int WindowNo) {
        return "Y".equals(this.getContext(WindowNo, "Processing"));
    }

    public boolean isActive(int WindowNo) {
        return "Y".equals(this.getContext(WindowNo, "IsActive"));
    }

    public int size() {
        return this.m_map.size();
    }

    public String toStringShort() {
        StringBuffer sb = new StringBuffer("Ctx[#").append(this.m_map.size()).append("]");
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Ctx[#").append(this.m_map.size());
        sb.append(this.m_map.toString());
        sb.append("]");
        return sb.toString();
    }

    public String[] getEntireContext() {
        Iterator keyIterator = this.keySet().iterator();
        ArrayList<String> sList = new ArrayList<String>(this.size());
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            String s = key + " == " + this.get(key);
            sList.add(s);
        }
        Object[] retValue = new String[sList.size()];
        sList.toArray(retValue);
        Arrays.sort(retValue);
        return retValue;
    }

    public String get_ValueAsString(String variableName) {
        return this.getContext(variableName);
    }

    public Ctx getCtx(int windowNo) {
        Ctx newCtx = new Ctx(this.getMap(windowNo, false));
        return newCtx;
    }

    public Map getMap(int windowNo) {
        return this.getMap(windowNo, false);
    }

    public Map getMap(int windowNo, boolean convertNullToEmptyString) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        Set set = this.m_map.entrySet();
        String keyPart = windowNo + "|";
        String infoPart = "1113|";
        int keyPartIndex = keyPart.length();
        for (Map.Entry entry : set) {
            String key = entry.getKey().toString();
            int index = key.indexOf(keyPart);
            if (index == 0) {
                String newKey = key.substring(keyPartIndex);
                Object oo = entry.getValue();
                if (oo == null && convertNullToEmptyString) {
                    newMap.put(newKey, "");
                    continue;
                }
                newMap.put(newKey, (String)oo);
                continue;
            }
            index = key.indexOf(infoPart);
            if (index != 0) continue;
            newMap.put(key, (String)entry.getValue());
        }
        return newMap;
    }

    public void removeWindow(int windowNo) {
        Object[] keys = this.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i].toString();
            if (!key.startsWith(windowNo + "|")) continue;
            this.remove(key);
        }
    }

    public void addWindow(int windowNo, Map map) {
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            String key = entry.getKey().toString();
            String newKey = windowNo + "|" + key;
            if (key.indexOf(124) != -1) {
                newKey = key;
            }
            Object value = entry.getValue();
            String newValue = "NULLValue";
            if (value != null) {
                newValue = value.toString();
            }
            this.setContext(newKey, newValue);
        }
    }

    public void deletePreference(String attribute, String attributeValue) {
        for (String key : this.m_map.keySet()) {
            String value;
            if (!key.startsWith("P") || key.indexOf(attribute) == -1 || !(value = this.getContext(key)).equals(attributeValue)) continue;
            this.m_map.remove(key);
        }
    }

    public void clear() {
        this.m_map.clear();
    }

    public boolean containsKey(Object key) {
        return this.m_map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.m_map.containsValue(value);
    }

    public Set entrySet() {
        return this.m_map.entrySet();
    }

    public Object get(Object key) {
        return this.m_map.get(key);
    }

    public boolean isEmpty() {
        return this.m_map.isEmpty();
    }

    public Set keySet() {
        return this.m_map.keySet();
    }

    public Object put(Object key, Object value) {
        if (key == null) {
            return null;
        }
        if (value == null) {
            return this.setContext(key.toString(), (String)null);
        }
        String stringValue = null;
        if (value != null) {
            stringValue = value.toString();
        }
        return this.setContext(key.toString(), stringValue);
    }

    public void putAll(Map map) {
        this.load(map);
    }

    public Object remove(Object key) {
        return this.m_map.remove(key);
    }

    public Collection values() {
        return this.m_map.values();
    }

    protected Map getMap() {
        return this.m_map;
    }

    public void copyContext(int from_windowNO, int to_windowNO, String context) {
        if (to_windowNO != from_windowNO) {
            this.setContext(to_windowNO, context, this.getContext(from_windowNO, context));
        }
    }

    public String getUITheme() {
        return this.getContext("#UITheme");
    }

    public void setUITheme(String value) {
        this.setContext("#UITheme", value);
    }

    public boolean isShowAdvanced() {
        return this.getContext("#ShowAdvanced").equals("Y");
    }

    public void setShowAdvanced(boolean showAdvanced) {
        this.m_map.put("#ShowAdvanced", showAdvanced ? "Y" : "N");
    }
}

