/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.util;

import org.compiere.util.NamePair;

public final class KeyNamePair
extends NamePair {
    private int m_key = 0;

    public KeyNamePair() {
    }

    public KeyNamePair(int key, String name) {
        super(name);
        this.m_key = key;
    }

    public int getKey() {
        return this.m_key;
    }

    public String getID() {
        if (this.m_key == -1) {
            return null;
        }
        return String.valueOf(this.m_key);
    }

    public boolean equals(Object obj) {
        if (obj instanceof KeyNamePair) {
            KeyNamePair pp = (KeyNamePair)obj;
            return pp.getKey() == this.m_key && pp.getName() != null && pp.getName().equals(this.getName());
        }
        return false;
    }

    public int compare(KeyNamePair p1, KeyNamePair p2) {
        if (this.isSortByName()) {
            return super.compare(p1, p2);
        }
        Integer i1 = new Integer(p1.getKey());
        Integer i2 = new Integer(p2.getKey());
        return i1.compareTo(i2);
    }

    public int compareTo(KeyNamePair o) {
        if (this.isSortByName()) {
            return super.compare(this, o);
        }
        if (o == null) {
            return -1;
        }
        Integer i1 = new Integer(this.m_key);
        Integer i2 = new Integer(o.getKey());
        return i1.compareTo(i2);
    }

    public int hashCode() {
        return this.m_key;
    }
}

