/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import org.jboss.util.HashCode;
import org.jboss.util.MuNumber;
import org.jboss.util.NotCoercibleException;

public class MuLong
extends MuNumber {
    private long value;

    public MuLong() {
    }

    public MuLong(long l) {
        this.value = l;
    }

    public MuLong(Object obj) {
        this.setValue(obj);
    }

    public boolean commit(long assumed, long b) {
        boolean success;
        boolean bl = success = assumed == this.value;
        if (success) {
            this.value = b;
        }
        return success;
    }

    public long swap(MuLong b) {
        if (b == this) {
            return this.value;
        }
        long temp = this.value;
        this.value = b.value;
        b.value = temp;
        return this.value;
    }

    public long increment() {
        return ++this.value;
    }

    public long decrement() {
        return --this.value;
    }

    public long add(long amount) {
        return this.value += amount;
    }

    public long subtract(long amount) {
        return this.value -= amount;
    }

    public long multiply(long factor) {
        return this.value *= factor;
    }

    public long divide(long factor) {
        return this.value /= factor;
    }

    public long negate() {
        this.value = -this.value;
        return this.value;
    }

    public long complement() {
        this.value ^= 0xFFFFFFFFFFFFFFFFL;
        return this.value;
    }

    public long and(long b) {
        this.value &= b;
        return this.value;
    }

    public long or(long b) {
        this.value |= b;
        return this.value;
    }

    public long xor(long b) {
        this.value ^= b;
        return this.value;
    }

    public long shiftRight(int bits) {
        this.value >>= bits;
        return this.value;
    }

    public long shiftRightZero(int bits) {
        this.value >>>= bits;
        return this.value;
    }

    public long shiftLeft(int bits) {
        this.value <<= bits;
        return this.value;
    }

    public int compareTo(long other) {
        return this.value < other ? -1 : (this.value == other ? 0 : 1);
    }

    public int compareTo(Object obj) {
        return this.compareTo((MuLong)obj);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return HashCode.generate(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            return this.value == ((MuLong)obj).longValue();
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public void set(long value) {
        this.value = value;
    }

    public void setValue(Object obj) {
        if (!(obj instanceof Number)) {
            throw new NotCoercibleException("can not convert to 'long': " + obj);
        }
        this.value = ((Number)obj).longValue();
    }

    public Object getValue() {
        return new Long(this.value);
    }
}

