/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MClientInfo;
import org.compiere.model.MCurrency;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRequisitionLine;
import org.compiere.model.MTax;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Doc_Order
extends Doc {
    private DocTax[] m_taxes = null;
    private DocLine[] m_requisitions = null;
    private int m_precision = -1;

    public Doc_Order(MAcctSchema[] ass, ResultSet rs, String trxName) {
        super(ass, MOrder.class, rs, null, trxName);
    }

    @Override
    public String loadDocumentDetails() {
        MOrder order = (MOrder)this.getPO();
        this.setDateDoc(order.getDateOrdered());
        this.setIsTaxIncluded(order.isTaxIncluded());
        this.setAmount(0, order.getGrandTotal());
        this.setAmount(1, order.getTotalLines());
        this.setAmount(2, order.getChargeAmt());
        this.m_taxes = this.loadTaxes();
        this.p_lines = this.loadLines(order);
        return null;
    }

    private DocLine[] loadLines(MOrder order) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MOrderLine[] lines = order.getLines();
        for (int i = 0; i < lines.length; ++i) {
            MTax tax;
            MOrderLine line = lines[i];
            DocLine docLine = new DocLine(line, this);
            BigDecimal Qty = line.getQtyOrdered();
            docLine.setQty(Qty, order.isSOTrx());
            BigDecimal PriceCost = null;
            if (this.getDocumentType().equals("POO")) {
                PriceCost = line.getPriceCost();
            }
            BigDecimal LineNetAmt = null;
            LineNetAmt = PriceCost != null && PriceCost.signum() != 0 ? Qty.multiply(PriceCost) : line.getLineNetAmt();
            docLine.setAmount(LineNetAmt);
            BigDecimal PriceList = line.getPriceList();
            int C_Tax_ID = docLine.getC_Tax_ID();
            if (this.isTaxIncluded() && C_Tax_ID != 0 && !(tax = MTax.get(this.getCtx(), C_Tax_ID)).isZeroTax()) {
                BigDecimal LineNetAmtTax = tax.calculateTax(LineNetAmt, true, this.getStdPrecision());
                this.log.fine("LineNetAmt=" + LineNetAmt + " - Tax=" + LineNetAmtTax);
                LineNetAmt = LineNetAmt.subtract(LineNetAmtTax);
                for (int t = 0; t < this.m_taxes.length; ++t) {
                    if (this.m_taxes[t].getC_Tax_ID() != C_Tax_ID) continue;
                    this.m_taxes[t].addIncludedTax(LineNetAmtTax);
                    break;
                }
                BigDecimal PriceListTax = tax.calculateTax(PriceList, true, this.getStdPrecision());
                PriceList = PriceList.subtract(PriceListTax);
            }
            docLine.setAmount(LineNetAmt, PriceList, Qty);
            list.add(docLine);
        }
        DocLine[] dl = new DocLine[list.size()];
        list.toArray(dl);
        return dl;
    }

    private DocLine[] loadRequisitions() {
        MOrder order = (MOrder)this.getPO();
        MOrderLine[] oLines = order.getLines();
        HashMap<Integer, BigDecimal> qtys = new HashMap<Integer, BigDecimal>();
        for (int i = 0; i < oLines.length; ++i) {
            MOrderLine line = oLines[i];
            qtys.put(new Integer(line.getC_OrderLine_ID()), line.getQtyOrdered());
        }
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        String sql = "SELECT * FROM M_RequisitionLine rl WHERE EXISTS (SELECT * FROM C_Order o  INNER JOIN C_OrderLine ol ON (o.C_Order_ID=ol.C_Order_ID) WHERE ol.C_OrderLine_ID=rl.C_OrderLine_ID AND o.C_Order_ID=?) ORDER BY rl.C_OrderLine_ID";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, order.getC_Order_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MRequisitionLine line = new MRequisitionLine(this.getCtx(), rs, null);
                DocLine docLine = new DocLine(line, this);
                Integer key = new Integer(line.getC_OrderLine_ID());
                BigDecimal maxQty = (BigDecimal)qtys.get(key);
                BigDecimal Qty = line.getQty().max(maxQty);
                if (Qty.signum() == 0) continue;
                docLine.setQty(Qty, false);
                qtys.put(key, maxQty.subtract(Qty));
                BigDecimal PriceActual = line.getPriceActual();
                BigDecimal LineNetAmt = line.getLineNetAmt();
                if (line.getQty().compareTo(Qty) != 0) {
                    LineNetAmt = PriceActual.multiply(Qty);
                }
                docLine.setAmount(LineNetAmt);
                list.add(docLine);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    private int getStdPrecision() {
        if (this.m_precision == -1) {
            this.m_precision = MCurrency.getStdPrecision(this.getCtx(), this.getC_Currency_ID());
        }
        return this.m_precision;
    }

    private DocTax[] loadTaxes() {
        ArrayList<DocTax> list = new ArrayList<DocTax>();
        String sql = "SELECT it.C_Tax_ID, t.Name, t.Rate, it.TaxBaseAmt, it.TaxAmt, t.IsSalesTax FROM C_Tax t, C_OrderTax it WHERE t.C_Tax_ID=it.C_Tax_ID AND it.C_Order_ID=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, this.getTrxName());
            pstmt.setInt(1, this.get_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                int C_Tax_ID = rs.getInt(1);
                String name = rs.getString(2);
                BigDecimal rate = rs.getBigDecimal(3);
                BigDecimal taxBaseAmt = rs.getBigDecimal(4);
                BigDecimal amount = rs.getBigDecimal(5);
                boolean salesTax = "Y".equals(rs.getString(6));
                DocTax taxLine = new DocTax(C_Tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                list.add(taxLine);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        DocTax[] tl = new DocTax[list.size()];
        list.toArray(tl);
        return tl;
    }

    @Override
    public BigDecimal getBalance() {
        int i;
        BigDecimal retValue = new BigDecimal(0.0);
        StringBuffer sb = new StringBuffer(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        retValue = retValue.subtract(this.getAmount(2));
        sb.append("-").append(this.getAmount(2));
        if (this.m_taxes != null) {
            for (i = 0; i < this.m_taxes.length; ++i) {
                retValue = retValue.subtract(this.m_taxes[i].getAmount());
                sb.append("-").append(this.m_taxes[i].getAmount());
            }
        }
        if (this.p_lines != null) {
            for (i = 0; i < this.p_lines.length; ++i) {
                retValue = retValue.subtract(this.p_lines[i].getAmtSource());
                sb.append("-").append(this.p_lines[i].getAmtSource());
            }
            sb.append("]");
        }
        if (retValue.signum() != 0 && this.getDocumentType().equals("POO")) {
            this.log.fine(this.toString() + " Balance=" + retValue + sb.toString() + " (ignored)");
            retValue = Env.ZERO;
        } else {
            this.log.fine(this.toString() + " Balance=" + retValue + sb.toString());
        }
        return retValue;
    }

    @Override
    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (this.getDocumentType().equals("POO")) {
            MAccount expense;
            BigDecimal cost;
            DocLine line;
            BigDecimal total;
            Fact fact;
            this.updateProductPO(as);
            if (as.isCreateCommitment()) {
                fact = new Fact(this, as, "E");
                total = Env.ZERO;
                for (int i = 0; i < this.p_lines.length; ++i) {
                    line = this.p_lines[i];
                    cost = line.getAmtSource();
                    total = total.add(cost);
                    expense = line.getAccount(2, as);
                    fact.createLine(line, expense, this.getC_Currency_ID(), cost, null);
                }
                MAccount offset = this.getAccount(111, as);
                if (offset == null) {
                    this.p_Error = "@NotFound@ @CommitmentOffset_Acct@";
                    this.log.log(Level.SEVERE, this.p_Error);
                    return null;
                }
                fact.createLine(null, offset, this.getC_Currency_ID(), null, total);
                facts.add(fact);
            }
            if (as.isCreateReservation()) {
                fact = new Fact(this, as, "R");
                total = Env.ZERO;
                if (this.m_requisitions == null) {
                    this.m_requisitions = this.loadRequisitions();
                }
                for (int i = 0; i < this.m_requisitions.length; ++i) {
                    line = this.m_requisitions[i];
                    cost = line.getAmtSource();
                    total = total.add(cost);
                    expense = line.getAccount(2, as);
                    fact.createLine(line, expense, this.getC_Currency_ID(), null, cost);
                }
                MAccount offset = this.getAccount(111, as);
                if (offset == null) {
                    this.p_Error = "@NotFound@ @CommitmentOffset_Acct@";
                    this.log.log(Level.SEVERE, this.p_Error);
                    return null;
                }
                fact.createLine(null, offset, this.getC_Currency_ID(), total, null);
                facts.add(fact);
            }
        }
        return facts;
    }

    private void updateProductPO(MAcctSchema as) {
        MClientInfo ci = MClientInfo.get(this.getCtx(), as.getAD_Client_ID());
        if (ci.getC_AcctSchema1_ID() != as.getC_AcctSchema_ID()) {
            return;
        }
        StringBuffer sql = new StringBuffer("UPDATE M_Product_PO po SET PriceLastPO = (SELECT currencyConvert(ol.PriceActual,ol.C_Currency_ID,po.C_Currency_ID,o.DateOrdered,o.C_ConversionType_ID,o.AD_Client_ID,o.AD_Org_ID) FROM C_Order o, C_OrderLine ol WHERE o.C_Order_ID=ol.C_Order_ID AND po.M_Product_ID=ol.M_Product_ID AND po.C_BPartner_ID=o.C_BPartner_ID");
        if (DB.isOracle()) {
            sql.append(" AND ROWNUM=1) ");
        } else {
            sql.append(" AND o.UPDATED IN (SELECT MAX(o1.UPDATED) FROM C_Order o1, C_OrderLine ol1 WHERE o1.C_Order_ID=ol1.C_Order_ID AND po.M_Product_ID=ol1.M_Product_ID AND po.C_BPartner_ID=o1.C_BPartner_ID").append("  AND o1.C_Order_ID=").append(this.get_ID()).append(") ");
        }
        sql.append(" AND o.C_Order_ID=").append(this.get_ID()).append(") ").append("WHERE EXISTS (SELECT * FROM C_Order o, C_OrderLine ol WHERE o.C_Order_ID=ol.C_Order_ID AND po.M_Product_ID=ol.M_Product_ID AND po.C_BPartner_ID=o.C_BPartner_ID AND o.C_Order_ID=").append(this.get_ID()).append(")");
        int no = DB.executeUpdate(sql.toString(), this.getTrxName());
        this.log.fine("Updated=" + no);
    }

    protected static DocLine[] getCommitments(Doc doc, BigDecimal maxQty, int C_InvoiceLine_ID) {
        int precision = -1;
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        String sql = "SELECT * FROM C_OrderLine ol WHERE EXISTS (SELECT * FROM C_InvoiceLine il WHERE il.C_OrderLine_ID=ol.C_OrderLine_ID AND il.C_InvoiceLine_ID=?) OR EXISTS (SELECT * FROM M_MatchPO po WHERE po.C_OrderLine_ID=ol.C_OrderLine_ID AND po.C_InvoiceLine_ID=?)";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_InvoiceLine_ID);
            pstmt.setInt(2, C_InvoiceLine_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MTax tax;
                if (maxQty.signum() == 0) continue;
                MOrderLine line = new MOrderLine(doc.getCtx(), rs, null);
                DocLine docLine = new DocLine(line, doc);
                if (precision == -1) {
                    doc.setC_Currency_ID(docLine.getC_Currency_ID());
                    precision = MCurrency.getStdPrecision(doc.getCtx(), docLine.getC_Currency_ID());
                }
                BigDecimal Qty = line.getQtyOrdered().max(maxQty);
                docLine.setQty(Qty, false);
                BigDecimal PriceActual = line.getPriceActual();
                BigDecimal PriceCost = line.getPriceCost();
                BigDecimal LineNetAmt = null;
                LineNetAmt = PriceCost != null && PriceCost.signum() != 0 ? Qty.multiply(PriceCost) : (Qty.equals(maxQty) ? line.getLineNetAmt() : Qty.multiply(PriceActual));
                maxQty = maxQty.subtract(Qty);
                docLine.setAmount(LineNetAmt);
                BigDecimal PriceList = line.getPriceList();
                int C_Tax_ID = docLine.getC_Tax_ID();
                if (C_Tax_ID != 0 && line.getParent().isTaxIncluded() && !(tax = MTax.get(doc.getCtx(), C_Tax_ID)).isZeroTax()) {
                    BigDecimal LineNetAmtTax = tax.calculateTax(LineNetAmt, true, precision);
                    s_log.fine("LineNetAmt=" + LineNetAmt + " - Tax=" + LineNetAmtTax);
                    LineNetAmt = LineNetAmt.subtract(LineNetAmtTax);
                    BigDecimal PriceListTax = tax.calculateTax(PriceList, true, precision);
                    PriceList = PriceList.subtract(PriceListTax);
                }
                docLine.setAmount(LineNetAmt, PriceList, Qty);
                list.add(docLine);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        DocLine[] dl = new DocLine[list.size()];
        list.toArray(dl);
        return dl;
    }

    protected static Fact getCommitmentRelease(MAcctSchema as, Doc doc, BigDecimal Qty, int C_InvoiceLine_ID, BigDecimal multiplier) {
        Fact fact = new Fact(doc, as, "E");
        DocLine[] commitments = Doc_Order.getCommitments(doc, Qty, C_InvoiceLine_ID);
        BigDecimal total = Env.ZERO;
        int C_Currency_ID = -1;
        for (int i = 0; i < commitments.length; ++i) {
            DocLine line = commitments[i];
            if (C_Currency_ID == -1) {
                C_Currency_ID = line.getC_Currency_ID();
            } else if (C_Currency_ID != line.getC_Currency_ID()) {
                doc.p_Error = "Different Currencies of Order Lines";
                s_log.log(Level.SEVERE, doc.p_Error);
                return null;
            }
            BigDecimal cost = line.getAmtSource().multiply(multiplier);
            total = total.add(cost);
            MAccount expense = line.getAccount(2, as);
            fact.createLine(line, expense, C_Currency_ID, null, cost);
        }
        MAccount offset = doc.getAccount(111, as);
        if (offset == null) {
            doc.p_Error = "@NotFound@ @CommitmentOffset_Acct@";
            s_log.log(Level.SEVERE, doc.p_Error);
            return null;
        }
        fact.createLine(null, offset, C_Currency_ID, total, null);
        return fact;
    }
}

