/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import org.compiere.util.CLogger;

public class CompiereServerGroup
extends ThreadGroup {
    private static CompiereServerGroup s_group = null;
    protected CLogger log = CLogger.getCLogger(this.getClass());

    public static CompiereServerGroup get() {
        if (s_group == null || s_group.isDestroyed()) {
            s_group = new CompiereServerGroup();
        }
        return s_group;
    }

    private CompiereServerGroup() {
        super("CompiereServers");
        this.setDaemon(true);
        this.setMaxPriority(10);
        this.log.info(this.getName() + " - Parent=" + this.getParent());
    }

    public void uncaughtException(Thread t, Throwable e) {
        this.log.info("uncaughtException = " + e.toString());
        super.uncaughtException(t, e);
    }

    public String toString() {
        return this.getName();
    }

    public void dump() {
        this.log.fine(this.getName() + (this.isDestroyed() ? " (destroyed)" : ""));
        this.log.fine("- Parent=" + this.getParent());
        Thread[] list = new Thread[this.activeCount()];
        this.log.fine("- Count=" + this.enumerate(list, true));
        for (int i = 0; i < list.length; ++i) {
            this.log.fine("-- " + list[i]);
        }
    }
}

