/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import org.compiere.Compiere;
import org.compiere.model.MAcctProcessor;
import org.compiere.model.MAlertProcessor;
import org.compiere.model.MLdapProcessor;
import org.compiere.model.MRequestProcessor;
import org.compiere.model.MScheduler;
import org.compiere.model.MSession;
import org.compiere.server.CompiereServer;
import org.compiere.server.CompiereServerGroup;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Env;
import org.compiere.wf.MWorkflowProcessor;

public class CompiereServerMgr {
    private static CompiereServerMgr m_serverMgr = null;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private ArrayList<CompiereServer> m_servers = new ArrayList();
    private Ctx m_ctx = Env.getCtx();
    private Timestamp m_start = new Timestamp(System.currentTimeMillis());

    public static CompiereServerMgr get() {
        if (m_serverMgr == null) {
            m_serverMgr = new CompiereServerMgr();
            m_serverMgr.startServers();
            CompiereServerMgr.m_serverMgr.log.info(m_serverMgr.toString());
        }
        return m_serverMgr;
    }

    private CompiereServerMgr() {
        this.startEnvironment();
    }

    private boolean startEnvironment() {
        Compiere.startup(false, "ServerMgr");
        this.log.info("");
        MSession session = MSession.get(this.getCtx(), true);
        session.setWebStoreSession(false);
        session.setWebSession("Server");
        session.save();
        return true;
    }

    private boolean startServers() {
        this.log.info("");
        int noServers = 0;
        MAcctProcessor[] acctModels = MAcctProcessor.getActive(this.m_ctx);
        for (int i = 0; i < acctModels.length; ++i) {
            MAcctProcessor pModel = acctModels[i];
            CompiereServer server = CompiereServer.create(pModel);
            server.start();
            server.setPriority(3);
            this.m_servers.add(server);
        }
        MRequestProcessor[] requestModels = MRequestProcessor.getActive(this.m_ctx);
        for (int i = 0; i < requestModels.length; ++i) {
            MRequestProcessor pModel = requestModels[i];
            CompiereServer server = CompiereServer.create(pModel);
            server.start();
            server.setPriority(3);
            this.m_servers.add(server);
        }
        MWorkflowProcessor[] workflowModels = MWorkflowProcessor.getActive(this.m_ctx);
        for (int i = 0; i < workflowModels.length; ++i) {
            MWorkflowProcessor pModel = workflowModels[i];
            CompiereServer server = CompiereServer.create(pModel);
            server.start();
            server.setPriority(3);
            this.m_servers.add(server);
        }
        MAlertProcessor[] alertModels = MAlertProcessor.getActive(this.m_ctx);
        for (int i = 0; i < alertModels.length; ++i) {
            MAlertProcessor pModel = alertModels[i];
            CompiereServer server = CompiereServer.create(pModel);
            server.start();
            server.setPriority(3);
            this.m_servers.add(server);
        }
        MScheduler[] schedulerModels = MScheduler.getActive(this.m_ctx);
        for (int i = 0; i < schedulerModels.length; ++i) {
            MScheduler pModel = schedulerModels[i];
            CompiereServer server = CompiereServer.create(pModel);
            server.start();
            server.setPriority(3);
            this.m_servers.add(server);
        }
        MLdapProcessor[] ldapModels = MLdapProcessor.getActive(this.m_ctx);
        for (int i = 0; i < ldapModels.length; ++i) {
            MLdapProcessor lp = ldapModels[i];
            CompiereServer server = CompiereServer.create(lp);
            server.start();
            server.setPriority(4);
            this.m_servers.add(server);
        }
        this.log.fine("#" + noServers);
        return this.startAll();
    }

    public Ctx getCtx() {
        return this.m_ctx;
    }

    public boolean startAll() {
        this.log.info("");
        CompiereServer[] servers = this.getInActive();
        for (int i = 0; i < servers.length; ++i) {
            CompiereServer server = servers[i];
            try {
                if (server.isAlive()) continue;
                if (server.isInterrupted()) {
                    int maxWait = 10;
                    while (server.isAlive()) {
                        if (maxWait-- == 0) {
                            this.log.severe("Wait timeout for interruped " + server);
                            break;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            this.log.log(Level.SEVERE, "While sleeping", e);
                        }
                    }
                }
                if (server.isAlive()) continue;
                if ((server = CompiereServer.create(server.getModel())) == null) {
                    this.m_servers.remove(i);
                } else {
                    this.m_servers.set(i, server);
                }
                server.start();
                server.setPriority(3);
                continue;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "Server: " + server, e);
            }
        }
        int noRunning = 0;
        int noStopped = 0;
        for (int i = 0; i < servers.length; ++i) {
            CompiereServer server = servers[i];
            try {
                if (server.isAlive()) {
                    this.log.info("Alive: " + server);
                    ++noRunning;
                    continue;
                }
                this.log.warning("Dead: " + server);
                ++noStopped;
                continue;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(checking) - " + server, e);
                ++noStopped;
            }
        }
        this.log.fine("Running=" + noRunning + ", Stopped=" + noStopped);
        CompiereServerGroup.get().dump();
        return noStopped == 0;
    }

    public boolean start(String serverID) {
        CompiereServer server = this.getServer(serverID);
        if (server == null) {
            return false;
        }
        if (server.isAlive()) {
            return true;
        }
        try {
            int index = this.m_servers.indexOf(server);
            server = CompiereServer.create(server.getModel());
            if (server == null) {
                this.m_servers.remove(index);
            } else {
                this.m_servers.set(index, server);
            }
            server.start();
            server.setPriority(3);
            Thread.yield();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "Server=" + serverID, e);
            return false;
        }
        this.log.info(server.toString());
        CompiereServerGroup.get().dump();
        if (server == null) {
            return false;
        }
        return server.isAlive();
    }

    public boolean stopAll() {
        CompiereServer server;
        int i;
        this.log.info("");
        CompiereServer[] servers = this.getActive();
        for (i = 0; i < servers.length; ++i) {
            server = servers[i];
            try {
                if (!server.isAlive() || server.isInterrupted()) continue;
                server.setPriority(9);
                server.interrupt();
                continue;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(interrupting) - " + server, e);
            }
        }
        Thread.yield();
        block7: for (i = 0; i < servers.length; ++i) {
            server = servers[i];
            try {
                int maxWait = 10;
                while (server.isAlive()) {
                    if (maxWait-- == 0) {
                        this.log.severe("Wait timeout for interruped " + server);
                        continue block7;
                    }
                    Thread.sleep(100L);
                }
                continue;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(waiting) - " + server, e);
            }
        }
        int noRunning = 0;
        int noStopped = 0;
        for (int i2 = 0; i2 < servers.length; ++i2) {
            CompiereServer server2 = servers[i2];
            try {
                if (server2.isAlive()) {
                    this.log.warning("Alive: " + server2);
                    ++noRunning;
                    continue;
                }
                this.log.info("Stopped: " + server2);
                ++noStopped;
                continue;
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "(checking) - " + server2, e);
                ++noRunning;
            }
        }
        this.log.fine("Running=" + noRunning + ", Stopped=" + noStopped);
        CompiereServerGroup.get().dump();
        return noRunning == 0;
    }

    public boolean stop(String serverID) {
        CompiereServer server = this.getServer(serverID);
        if (server == null) {
            return false;
        }
        if (!server.isAlive()) {
            return true;
        }
        try {
            server.interrupt();
            Thread.sleep(10L);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "stop", e);
            return false;
        }
        this.log.info(server.toString());
        CompiereServerGroup.get().dump();
        return !server.isAlive();
    }

    public void destroy() {
        this.log.info("");
        this.stopAll();
        this.m_servers.clear();
    }

    protected CompiereServer[] getActive() {
        ArrayList<CompiereServer> list = new ArrayList<CompiereServer>();
        for (int i = 0; i < this.m_servers.size(); ++i) {
            CompiereServer server = this.m_servers.get(i);
            if (server == null || !server.isAlive() || server.isInterrupted()) continue;
            list.add(server);
        }
        CompiereServer[] retValue = new CompiereServer[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    protected CompiereServer[] getInActive() {
        ArrayList<CompiereServer> list = new ArrayList<CompiereServer>();
        for (int i = 0; i < this.m_servers.size(); ++i) {
            CompiereServer server = this.m_servers.get(i);
            if (server == null || server.isAlive() && server.isInterrupted()) continue;
            list.add(server);
        }
        CompiereServer[] retValue = new CompiereServer[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public CompiereServer[] getAll() {
        CompiereServer[] retValue = new CompiereServer[this.m_servers.size()];
        this.m_servers.toArray(retValue);
        return retValue;
    }

    public CompiereServer getServer(String serverID) {
        if (serverID == null) {
            return null;
        }
        for (int i = 0; i < this.m_servers.size(); ++i) {
            CompiereServer server = this.m_servers.get(i);
            if (!serverID.equals(server.getServerID())) continue;
            return server;
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("CompiereServerMgr[");
        sb.append("Servers=").append(this.m_servers.size()).append(",ContextSize=").append(this.m_ctx.size()).append(",Started=").append(this.m_start).append("]");
        return sb.toString();
    }

    public String getDescription() {
        return "$Revision: 1.1 $";
    }

    public String getServerCount() {
        int noRunning = 0;
        int noStopped = 0;
        for (int i = 0; i < this.m_servers.size(); ++i) {
            CompiereServer server = this.m_servers.get(i);
            if (server.isAlive()) {
                ++noRunning;
                continue;
            }
            ++noStopped;
        }
        String info = String.valueOf(this.m_servers.size()) + " - Running=" + noRunning + " - Stopped=" + noStopped;
        return info;
    }

    public Timestamp getStartTime() {
        return this.m_start;
    }
}

