/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.server;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.model.MChangeRequest;
import org.compiere.model.MClient;
import org.compiere.model.MGroup;
import org.compiere.model.MRequest;
import org.compiere.model.MRequestProcessor;
import org.compiere.model.MRequestProcessorLog;
import org.compiere.model.MRequestProcessorRoute;
import org.compiere.model.MStatus;
import org.compiere.model.MUser;
import org.compiere.model.X_R_Status;
import org.compiere.server.CompiereServer;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class RequestProcessor
extends CompiereServer {
    private MRequestProcessor m_model = null;
    private StringBuffer m_summary = new StringBuffer();
    private MClient m_client = null;

    public RequestProcessor(MRequestProcessor model) {
        super(model, 60);
        this.m_model = model;
        this.m_client = MClient.get(model.getCtx(), model.getAD_Client_ID());
    }

    protected void doWork() {
        this.m_summary = new StringBuffer();
        this.processEMail();
        this.findSalesRep();
        this.processRequests();
        this.processStatus();
        this.processECR();
        int no = this.m_model.deleteLog();
        this.m_summary.append("Logs deleted=").append(no);
        MRequestProcessorLog pLog = new MRequestProcessorLog(this.m_model, this.m_summary.toString());
        pLog.setReference("#" + String.valueOf(this.p_runCount) + " - " + TimeUtil.formatElapsed(new Timestamp(this.p_startWork)));
        pLog.save();
    }

    private void processRequests() {
        MRequest request;
        ResultSet rs;
        String sql = "SELECT * FROM R_Request WHERE DueType='7' AND Processed='N' AND DateNextAction > SysDate AND AD_Client_ID=?";
        if (this.m_model.getR_RequestType_ID() != 0) {
            sql = sql + " AND R_RequestType_ID=?";
        }
        CPreparedStatement pstmt = null;
        int count = 0;
        int countEMails = 0;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_model.getAD_Client_ID());
            if (this.m_model.getR_RequestType_ID() != 0) {
                pstmt.setInt(2, this.m_model.getR_RequestType_ID());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                request = new MRequest(this.getCtx(), rs, null);
                request.setDueType();
                if (!request.isDue()) continue;
                if (request.getRequestType().isEMailWhenDue() && this.sendEmail(request, "RequestDue")) {
                    request.setDateLastAlert();
                    ++countEMails;
                }
                request.save();
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        this.m_summary.append("New Due #").append(count);
        if (countEMails > 0) {
            this.m_summary.append(" (").append(countEMails).append(" EMail)");
        }
        this.m_summary.append(" - ");
        sql = "SELECT * FROM R_Request r WHERE r.DueType='5' AND r.Processed='N' AND AD_Client_ID=? AND EXISTS (SELECT * FROM R_RequestType rt WHERE r.R_RequestType_ID=rt.R_RequestType_ID AND addDays(r.DateNextAction,rt.DueDateTolerance) > SysDate)";
        if (this.m_model.getR_RequestType_ID() != 0) {
            sql = sql + " AND r.R_RequestType_ID=?";
        }
        count = 0;
        countEMails = 0;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_model.getAD_Client_ID());
            if (this.m_model.getR_RequestType_ID() != 0) {
                pstmt.setInt(2, this.m_model.getR_RequestType_ID());
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                request = new MRequest(this.getCtx(), rs, null);
                request.setDueType();
                if (!request.isOverdue()) continue;
                if (request.getRequestType().isEMailWhenOverdue() && !TimeUtil.isSameDay(request.getDateLastAlert(), null) && this.sendEmail(request, "RequestDue")) {
                    request.setDateLastAlert();
                    ++countEMails;
                }
                request.save();
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        this.m_summary.append("New Overdue #").append(count);
        if (countEMails > 0) {
            this.m_summary.append(" (").append(countEMails).append(" EMail)");
        }
        this.m_summary.append(" - ");
        if (this.m_model.getOverdueAlertDays() > 0) {
            sql = "SELECT * FROM R_Request WHERE Processed='N' AND AD_Client_ID=? AND addDays(DateNextAction," + this.m_model.getOverdueAlertDays() + ") > SysDate " + " AND (DateLastAlert IS NULL";
            if (this.m_model.getRemindDays() > 0) {
                sql = sql + " OR addDays(DateLastAlert," + this.m_model.getRemindDays() + ") > SysDate ";
            }
            sql = sql + ")";
            if (this.m_model.getR_RequestType_ID() != 0) {
                sql = sql + " AND R_RequestType_ID=?";
            }
            count = 0;
            countEMails = 0;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.m_model.getAD_Client_ID());
                if (this.m_model.getR_RequestType_ID() != 0) {
                    pstmt.setInt(2, this.m_model.getR_RequestType_ID());
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    request = new MRequest(this.getCtx(), rs, null);
                    request.setDueType();
                    if (request.getRequestType().isEMailWhenOverdue() && (request.getDateLastAlert() == null || !TimeUtil.isSameDay(request.getDateLastAlert(), null)) && this.sendEmail(request, "RequestAlert")) {
                        request.setDateLastAlert();
                        ++countEMails;
                    }
                    request.save();
                    ++count;
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            this.m_summary.append("Alerts #").append(count);
            if (countEMails > 0) {
                this.m_summary.append(" (").append(countEMails).append(" EMail)");
            }
            this.m_summary.append(" - ");
        }
        if (this.m_model.getOverdueAssignDays() > 0) {
            sql = "SELECT * FROM R_Request WHERE Processed='N' AND AD_Client_ID=? AND IsEscalated='N' AND addDays(DateNextAction," + this.m_model.getOverdueAssignDays() + ") > SysDate";
            if (this.m_model.getR_RequestType_ID() != 0) {
                sql = sql + " AND R_RequestType_ID=?";
            }
            count = 0;
            countEMails = 0;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.m_model.getAD_Client_ID());
                if (this.m_model.getR_RequestType_ID() != 0) {
                    pstmt.setInt(2, this.m_model.getR_RequestType_ID());
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    request = new MRequest(this.getCtx(), rs, null);
                    if (!this.escalate(request)) continue;
                    ++count;
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            this.m_summary.append("Escalated #").append(count).append(" - ");
        }
        if (this.m_model.getInactivityAlertDays() > 0) {
            sql = "SELECT * FROM R_Request WHERE Processed='N' AND AD_Client_ID=? AND addDays(Updated," + this.m_model.getInactivityAlertDays() + ") > SysDate " + " AND (DateLastAlert IS NULL";
            if (this.m_model.getRemindDays() > 0) {
                sql = sql + " OR addDays(DateLastAlert," + this.m_model.getRemindDays() + ") < SysDate ";
            }
            sql = sql + ")";
            if (this.m_model.getR_RequestType_ID() != 0) {
                sql = sql + " AND R_RequestType_ID=?";
            }
            count = 0;
            countEMails = 0;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.m_model.getAD_Client_ID());
                if (this.m_model.getR_RequestType_ID() != 0) {
                    pstmt.setInt(2, this.m_model.getR_RequestType_ID());
                }
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    request = new MRequest(this.getCtx(), rs, null);
                    request.setDueType();
                    if (request.getDateLastAlert() != null && TimeUtil.isSameDay(request.getDateLastAlert(), null)) continue;
                    if (this.sendEmail(request, "RequestInactive")) {
                        request.setDateLastAlert();
                        ++countEMails;
                    }
                    request.save();
                    ++count;
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
            this.m_summary.append("Inactivity #").append(count);
            if (countEMails > 0) {
                this.m_summary.append(" (").append(countEMails).append(" EMail)");
            }
            this.m_summary.append(" - ");
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
    }

    private boolean sendEmail(MRequest request, String AD_Message) {
        String subject = Msg.getMsg(this.m_client.getAD_Language(), AD_Message, (Object[])new String[]{request.getDocumentNo()});
        return this.m_client.sendEMail(request.getSalesRep_ID(), subject, request.getSummary(), request.createPDF());
    }

    private boolean escalate(MRequest request) {
        MUser supervisor = request.getSalesRep();
        int supervisor_ID = request.getSalesRep().getSupervisor_ID();
        if (supervisor_ID == 0 && this.m_model.getSupervisor_ID() != 0) {
            supervisor_ID = this.m_model.getSupervisor_ID();
        }
        if (supervisor_ID != 0 && supervisor_ID != request.getAD_User_ID()) {
            supervisor = MUser.get(this.getCtx(), supervisor_ID);
        }
        String subject = Msg.getMsg(this.m_client.getAD_Language(), "RequestEscalate", (Object[])new String[]{request.getDocumentNo(), supervisor.getName()});
        String to = request.getSalesRep().getEMail();
        if (to == null || to.length() == 0) {
            this.log.warning("SalesRep has no EMail - " + request.getSalesRep());
        } else {
            this.m_client.sendEMail(request.getSalesRep_ID(), subject, request.getSummary(), request.createPDF());
        }
        if (request.getSalesRep_ID() != supervisor.getAD_User_ID()) {
            to = supervisor.getEMail();
            if (to == null || to.length() == 0) {
                this.log.warning("Supervisor has no EMail - " + supervisor);
            } else {
                this.m_client.sendEMail(supervisor.getAD_User_ID(), subject, request.getSummary(), request.createPDF());
            }
        }
        request.setDueType();
        request.setIsEscalated(true);
        request.setResult(subject);
        return request.save();
    }

    private void processStatus() {
        int count = 0;
        String sql = "SELECT * FROM R_Request r WHERE EXISTS (SELECT * FROM R_Status s WHERE r.R_Status_ID=s.R_Status_ID AND s.TimeoutDays > 0 AND s.Next_Status_ID > 0 AND addDays(r.Updated,s.TimeoutDays) < SysDate ) ORDER BY R_Status_ID";
        CPreparedStatement pstmt = null;
        X_R_Status status = null;
        X_R_Status next = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MRequest r = new MRequest(this.getCtx(), rs, null);
                if (status == null || status.getR_Status_ID() != r.getR_Status_ID()) {
                    status = MStatus.get(this.getCtx(), r.getR_Status_ID());
                }
                if (status.getTimeoutDays() <= 0 || status.getNext_Status_ID() == 0) continue;
                if (next == null || next.getR_Status_ID() != status.getNext_Status_ID()) {
                    next = MStatus.get(this.getCtx(), status.getNext_Status_ID());
                }
                String result = Msg.getMsg(this.getCtx(), "RequestStatusTimeout") + ": " + status.getName() + " -> " + next.getName();
                r.setResult(result);
                r.setR_Status_ID(status.getNext_Status_ID());
                if (!r.save()) continue;
                ++count;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_summary.append("Status Timeout #").append(count).append(" - ");
    }

    private void processECR() {
        String sql = "SELECT * FROM R_Request r WHERE M_ChangeRequest_ID IS NULL AND EXISTS (SELECT * FROM R_RequestType rt WHERE rt.R_RequestType_ID=r.R_RequestType_ID AND rt.IsAutoChangeRequest='Y')AND EXISTS (SELECT * FROM R_Group g WHERE g.R_Group_ID=r.R_Group_ID AND (g.M_BOM_ID IS NOT NULL OR g.M_ChangeNotice_ID IS NOT NULL)\t)";
        int count = 0;
        int failure = 0;
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MRequest r = new MRequest(this.getCtx(), rs, null);
                MGroup rg = MGroup.get(this.getCtx(), r.getR_Group_ID());
                MChangeRequest ecr = new MChangeRequest(r, rg);
                if (r.save()) {
                    r.setM_ChangeRequest_ID(ecr.getM_ChangeRequest_ID());
                    if (r.save()) {
                        ++count;
                        continue;
                    }
                    ++failure;
                    continue;
                }
                ++failure;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        this.m_summary.append("Auto Change Request #").append(count);
        if (failure > 0) {
            this.m_summary.append("(fail=").append(failure).append(")");
        }
        this.m_summary.append(" - ");
    }

    private void processEMail() {
    }

    private void findSalesRep() {
        int changed = 0;
        int notFound = 0;
        Ctx ctx = new Ctx();
        String sql = "SELECT * FROM R_Request WHERE AD_Client_ID=? AND SalesRep_ID=0 AND Processed='N'";
        if (this.m_model.getR_RequestType_ID() != 0) {
            sql = sql + " AND R_RequestType_ID=?";
        }
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_model.getAD_Client_ID());
            if (this.m_model.getR_RequestType_ID() != 0) {
                pstmt.setInt(2, this.m_model.getR_RequestType_ID());
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MRequest request = new MRequest(ctx, rs, null);
                if (request.getSalesRep_ID() != 0) continue;
                int SalesRep_ID = this.findSalesRep(request);
                if (SalesRep_ID != 0) {
                    request.setSalesRep_ID(SalesRep_ID);
                    request.save();
                    ++changed;
                    continue;
                }
                ++notFound;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            this.log.log(Level.SEVERE, sql, ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (changed == 0 && notFound == 0) {
            this.m_summary.append("No unallocated Requests");
        } else {
            this.m_summary.append("Allocated SalesRep=").append(changed);
        }
        if (notFound > 0) {
            this.m_summary.append(",Not=").append(notFound);
        }
        this.m_summary.append(" - ");
    }

    private int findSalesRep(MRequest request) {
        String QText = request.getSummary();
        QText = QText == null ? "" : QText.toUpperCase();
        MRequestProcessorRoute[] routes = this.m_model.getRoutes(false);
        for (int i = 0; i < routes.length; ++i) {
            MRequestProcessorRoute route = routes[i];
            if (request.getR_RequestType_ID() == route.getR_RequestType_ID() && route.getR_RequestType_ID() != 0) {
                return route.getAD_User_ID();
            }
            String keyword = route.getKeyword();
            if (keyword == null) continue;
            StringTokenizer st = new StringTokenizer(keyword.toUpperCase(), " ,;\t\n\r\f");
            while (st.hasMoreElements()) {
                if (QText.indexOf(st.nextToken()) == -1) continue;
                return route.getAD_User_ID();
            }
        }
        return this.m_model.getSupervisor_ID();
    }

    public String getServerInfo() {
        return "#" + this.p_runCount + " - Last=" + this.m_summary.toString();
    }
}

