/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.util.LinkedList;
import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.jboss.logging.Logger;
import org.jboss.mq.SpyConsumer;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.SpyEncapsulatedMessage;
import org.jboss.mq.SpyJMSException;
import org.jboss.mq.SpyMessage;
import org.jboss.mq.SpySession;
import org.jboss.mq.Subscription;
import org.jboss.util.UnreachableStatementException;

public class SpyMessageConsumer
implements MessageConsumer,
SpyConsumer,
Runnable {
    static Logger log = Logger.getLogger(SpyMessageConsumer.class);
    static boolean trace = log.isTraceEnabled();
    public SpySession session;
    public Subscription subscription = new Subscription();
    protected boolean closed;
    protected Object stateLock = new Object();
    protected boolean receiving = false;
    protected boolean waitingForMessage = false;
    protected boolean listening = false;
    protected Thread listenerThread = null;
    MessageListener messageListener;
    LinkedList messages;
    boolean sessionConsumer;

    SpyMessageConsumer(SpySession s, boolean sessionConsumer) {
        trace = log.isTraceEnabled();
        this.session = s;
        this.sessionConsumer = sessionConsumer;
        this.messageListener = null;
        this.closed = false;
        this.messages = new LinkedList();
        if (trace) {
            log.trace("New message consumer " + this);
        }
    }

    SpyMessageConsumer(SpySession s, boolean sessionConsumer, SpyDestination destination, String selector, boolean noLocal) throws InvalidSelectorException {
        trace = log.isTraceEnabled();
        this.session = s;
        this.sessionConsumer = sessionConsumer;
        this.subscription.destination = destination;
        this.subscription.messageSelector = selector;
        this.subscription.noLocal = noLocal;
        if (this.subscription.messageSelector != null) {
            this.subscription.getSelector();
        }
        this.messageListener = null;
        this.closed = false;
        this.messages = new LinkedList();
        if (trace) {
            log.trace("New message consumer " + this);
        }
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(SpyMessage message) throws JMSException {
        if (this.closed) {
            if (trace) {
                log.trace("WARNING: NACK issued. message=" + message.header.jmsMessageID + " The message consumer was closed. " + this);
            }
            this.session.connection.send(message.getAcknowledgementRequest(false));
            return;
        }
        if (this.subscription.accepts(message.header)) {
            if (this.sessionConsumer) {
                this.sessionConsumerProcessMessage(message);
            } else {
                LinkedList linkedList = this.messages;
                synchronized (linkedList) {
                    if (this.waitingForMessage) {
                        if (trace) {
                            log.trace("Adding message=" + message.header.jmsMessageID + " " + this);
                        }
                        this.messages.addLast(message);
                        this.messages.notifyAll();
                    } else {
                        if (trace) {
                            log.trace("WARNING: NACK issued. message=" + message.header.jmsMessageID + " The message consumer was not waiting for a message. " + this);
                        }
                        this.session.connection.send(message.getAcknowledgementRequest(false));
                    }
                }
            }
        } else {
            if (trace) {
                log.trace("WARNING: NACK issued. message=" + message.header.jmsMessageID + " The subscription did not accept the message. " + this);
            }
            this.session.connection.send(message.getAcknowledgementRequest(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartProcessing() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            if (trace) {
                log.trace("Restarting processing " + this);
            }
            this.messages.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener listener) throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            if (trace) {
                log.trace("Set message listener=" + listener + " old listener=" + this.messageListener + " " + this);
            }
            boolean oldListening = this.listening;
            this.listening = listener != null;
            this.messageListener = listener;
            if (!this.sessionConsumer && this.listening && !oldListening && this.listenerThread == null) {
                this.listenerThread = new Thread((Runnable)this, "MessageListenerThread - " + this.subscription.destination.getName());
                this.listenerThread.start();
            }
        }
    }

    public String getMessageSelector() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        return this.subscription.messageSelector;
    }

    public MessageListener getMessageListener() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        return this.messageListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receive() throws JMSException {
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            if (this.listening) {
                throw new JMSException("A message listener is already registered");
            }
            this.receiving = true;
            if (trace) {
                log.trace("receive() " + this);
            }
        }
        object = this.messages;
        synchronized (object) {
            SpyMessage msg;
            Message message = this.getMessage();
            if (message != null) {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.receiving = false;
                    if (!trace) return message;
                    log.trace("receive() message in list " + message.getJMSMessageID() + " " + this);
                    return message;
                }
            }
            while ((msg = this.session.connection.receive(this.subscription, 0L)) != null) {
                Message mes = this.preProcessMessage(msg);
                if (mes == null) continue;
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.receiving = false;
                    if (!trace) return mes;
                    log.trace("receive() message from server " + mes.getJMSMessageID() + " " + this);
                    return mes;
                }
            }
            if (trace) {
                log.trace("No message in receive(), waiting " + this);
            }
            try {
                this.waitingForMessage = true;
                while (true) {
                    Message mes;
                    if (this.closed) {
                        if (trace) {
                            log.trace("Consumer closed in receive() " + this);
                        }
                        msg = null;
                        Object var8_8 = null;
                        this.waitingForMessage = false;
                        Object object4 = this.stateLock;
                        synchronized (object4) {
                            this.receiving = false;
                            return mes;
                        }
                    }
                    mes = this.getMessage();
                    if (mes != null) {
                        if (trace) {
                            log.trace("receive() message from list after wait " + this);
                        }
                        Message message2 = mes;
                        Object var8_9 = null;
                        this.waitingForMessage = false;
                        Object object5 = this.stateLock;
                        synchronized (object5) {
                            this.receiving = false;
                            return message2;
                        }
                    }
                    this.messages.wait();
                }
            }
            catch (Throwable t) {
                try {
                    SpyJMSException.rethrowAsJMSException("Receive interupted", t);
                    throw new UnreachableStatementException();
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    this.waitingForMessage = false;
                    Object object6 = this.stateLock;
                    synchronized (object6) {
                        this.receiving = false;
                        throw throwable;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receive(long timeOut) throws JMSException {
        if (timeOut == 0L) {
            if (!trace) return this.receive();
            log.trace("Timeout is zero in receive(long) using receive() " + this);
            return this.receive();
        }
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            if (this.listening) {
                throw new JMSException("A message listener is already registered");
            }
            this.receiving = true;
            if (trace) {
                log.trace("receive(long) " + this);
            }
        }
        long endTime = System.currentTimeMillis() + timeOut;
        if (trace) {
            log.trace("receive(long) endTime=" + endTime + " " + this);
        }
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            SpyMessage msg;
            Message message = this.getMessage();
            if (message != null) {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.receiving = false;
                    if (!trace) return message;
                    log.trace("receive(long) message in list " + message.getJMSMessageID() + " " + this);
                    return message;
                }
            }
            while ((msg = this.session.connection.receive(this.subscription, timeOut)) != null) {
                Message mes2 = this.preProcessMessage(msg);
                if (mes2 == null) continue;
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.receiving = false;
                    if (!trace) return mes2;
                    log.trace("receive(long) message from server " + mes2.getJMSMessageID() + " " + this);
                    return mes2;
                }
            }
            if (trace) {
                log.trace("No message in receive(), waiting " + this);
            }
            try {
                this.waitingForMessage = true;
                while (true) {
                    if (this.closed) {
                        if (trace) {
                            log.trace("Consumer closed in receive(long) " + this);
                        }
                        msg = null;
                        Object var12_13 = null;
                        this.waitingForMessage = false;
                        Object object4 = this.stateLock;
                        synchronized (object4) {
                            this.receiving = false;
                            return msg;
                        }
                    }
                    Message mes = this.getMessage();
                    if (mes != null) {
                        if (trace) {
                            log.trace("receive(long) message from list after wait " + this);
                        }
                        Message mes2 = mes;
                        Object var12_14 = null;
                        this.waitingForMessage = false;
                        Object object5 = this.stateLock;
                        synchronized (object5) {
                            this.receiving = false;
                            return mes2;
                        }
                    }
                    long att = endTime - System.currentTimeMillis();
                    if (att <= 0L) {
                        if (trace) {
                            log.trace("receive(long) timed out endTime=" + endTime + " " + this);
                        }
                        Message message2 = null;
                        Object var12_15 = null;
                        this.waitingForMessage = false;
                        Object object6 = this.stateLock;
                        synchronized (object6) {
                            this.receiving = false;
                            return message2;
                        }
                    }
                    this.messages.wait(att);
                }
            }
            catch (Throwable t) {
                try {
                    SpyJMSException.rethrowAsJMSException("Receive interupted", t);
                    throw new UnreachableStatementException();
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    this.waitingForMessage = false;
                    Object object7 = this.stateLock;
                    synchronized (object7) {
                        this.receiving = false;
                        throw throwable;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveNoWait() throws JMSException {
        SpyMessage msg;
        Message mes;
        if (this.closed) {
            throw new IllegalStateException("The MessageConsumer is closed");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.receiving) {
                throw new JMSException("Another thread is already in receive.");
            }
            if (this.listening) {
                throw new JMSException("A message listener is already registered");
            }
            this.receiving = true;
            if (trace) {
                log.trace("receiveNoWait() " + this);
            }
        }
        object = this.messages;
        synchronized (object) {
            mes = this.getMessage();
            if (mes != null) {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.receiving = false;
                    if (trace) {
                        log.trace("receiveNoWait() message in list " + mes.getJMSMessageID() + " " + this);
                    }
                }
                return mes;
            }
        }
        while ((msg = this.session.connection.receive(this.subscription, -1L)) != null) {
            mes = this.preProcessMessage(msg);
            if (mes == null) continue;
            Object object3 = this.stateLock;
            synchronized (object3) {
                this.receiving = false;
                if (trace) {
                    log.trace("receiveNoWait() message from server " + mes.getJMSMessageID() + " " + this);
                }
            }
            return mes;
        }
        Object object4 = this.stateLock;
        synchronized (object4) {
            this.receiving = false;
        }
        if (trace) {
            log.trace("receiveNoWait() no message " + this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            if (this.closed) {
                return;
            }
            if (trace) {
                log.trace("Message consumer closing. " + this);
            }
            this.closed = true;
            this.messages.notifyAll();
        }
        this.session.interruptDeliveryLockWaiters();
        if (this.listenerThread != null && !Thread.currentThread().equals(this.listenerThread)) {
            try {
                if (trace) {
                    log.trace("Joining listener thread. " + this);
                }
                this.listenerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.sessionConsumer) {
            this.session.removeConsumer(this);
        }
        if (trace) {
            log.trace("Closed. " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        SpyMessage mes = null;
        try {
            while (true) {
                MessageListener thisListener;
                if (mes == null) {
                    LinkedList linkedList = this.messages;
                    synchronized (linkedList) {
                        if (this.closed) {
                            this.waitingForMessage = false;
                            if (trace) {
                                log.trace("Consumer closed in run() " + this);
                            }
                            break;
                        }
                        if (this.messages.isEmpty()) {
                            mes = this.session.connection.receive(this.subscription, 0L);
                        }
                        if (mes == null) {
                            this.waitingForMessage = true;
                            if (trace) {
                                log.trace("waiting in run() " + this);
                            }
                            while (this.messages.isEmpty() && !this.closed || !this.session.running) {
                                try {
                                    this.messages.wait();
                                }
                                catch (InterruptedException e) {
                                    log.trace("Ignored interruption waiting for messages");
                                }
                            }
                            if (this.closed) {
                                this.waitingForMessage = false;
                                if (trace) {
                                    log.trace("Consumer closed while waiting in run() " + this);
                                }
                                break;
                            }
                            mes = (SpyMessage)this.messages.removeFirst();
                            this.waitingForMessage = false;
                        } else if (trace) {
                            log.trace("run() message from server mes=" + mes.getJMSMessageID() + " " + this);
                        }
                    }
                    mes.session = this.session;
                    if (!mes.isOutdated()) continue;
                    if (trace) {
                        log.trace("run() acking expired message mes=" + mes.getJMSMessageID() + " " + this);
                    }
                    mes.doAcknowledge();
                    mes = null;
                    continue;
                }
                Object e = this.stateLock;
                synchronized (e) {
                    if (!this.isListening()) {
                        if (mes != null) {
                            if (trace) {
                                log.trace("run() nacking not listening message mes=" + mes.getJMSMessageID() + " " + this);
                            }
                            this.session.connection.send(mes.getAcknowledgementRequest(false));
                        }
                        this.listenerThread = null;
                        mes = null;
                        break;
                    }
                    thisListener = this.messageListener;
                }
                Message message = mes;
                if (mes instanceof SpyEncapsulatedMessage) {
                    message = ((SpyEncapsulatedMessage)mes).getMessage();
                }
                if (this.session.transacted) {
                    if (trace) {
                        log.trace("run() acknowledging message in tx mes=" + mes.getJMSMessageID() + " " + this);
                    }
                    this.session.connection.spyXAResourceManager.ackMessage(this.session.getCurrentTransactionId(), mes);
                }
                boolean gotDeliveryLock = false;
                while (!gotDeliveryLock) {
                    gotDeliveryLock = this.session.tryDeliveryLock();
                    if (gotDeliveryLock) continue;
                    LinkedList linkedList = this.messages;
                    synchronized (linkedList) {
                        if (this.closed) {
                            break;
                        }
                    }
                }
                if (!gotDeliveryLock) {
                    if (trace) {
                        log.trace("run() nacking didn't get delivery lock mes=" + mes.getJMSMessageID() + " " + this);
                    }
                    this.session.connection.send(mes.getAcknowledgementRequest(false));
                    continue;
                }
                try {
                    this.session.addUnacknowlegedMessage((SpyMessage)message);
                    thisListener.onMessage(message);
                }
                catch (Throwable t) {
                    log.warn("Message listener " + thisListener + " threw a throwable.", t);
                }
                finally {
                    this.session.releaseDeliveryLock();
                }
                if (!(this.session.transacted || this.session.acknowledgeMode != 1 && this.session.acknowledgeMode != 3)) {
                    boolean recovered;
                    LinkedList linkedList = this.messages;
                    synchronized (linkedList) {
                        recovered = this.messages.contains(message);
                    }
                    if (!recovered) {
                        mes.doAcknowledge();
                    }
                }
                mes = null;
            }
        }
        catch (Throwable t) {
            log.warn("Message consumer closing due to error in listening thread.", t);
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.session.asynchFailure("Message consumer closing due to error in listening thread.", t);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("SpyMessageConsumer@").append(System.identityHashCode(this));
        buffer.append("[sub=").append(this.subscription);
        if (this.closed) {
            buffer.append(" CLOSED");
        }
        buffer.append(" listening=").append(this.listening);
        buffer.append(" receiving=").append(this.receiving);
        buffer.append(" sessionConsumer=").append(this.sessionConsumer);
        buffer.append(" waitingForMessage=").append(this.waitingForMessage);
        buffer.append(" messages=").append(this.messages.size());
        if (this.listenerThread != null) {
            buffer.append(" thread=").append(this.listenerThread);
        }
        if (this.messageListener != null) {
            buffer.append(" listener=").append(this.messageListener);
        }
        buffer.append(" session=").append(this.session);
        buffer.append(']');
        return buffer.toString();
    }

    Message getMessage() {
        LinkedList linkedList = this.messages;
        synchronized (linkedList) {
            if (trace) {
                log.trace("Getting message from list " + this);
            }
            while (true) {
                try {
                    SpyMessage mes;
                    Message rc;
                    do {
                        if (this.messages.size() != 0) continue;
                        return null;
                    } while ((rc = this.preProcessMessage(mes = (SpyMessage)this.messages.removeFirst())) == null);
                    return rc;
                }
                catch (Throwable t) {
                    log.error("Ignoring error", t);
                    continue;
                }
                break;
            }
        }
    }

    Message preProcessMessage(SpyMessage message) throws JMSException {
        message.session = this.session;
        this.session.addUnacknowlegedMessage(message);
        if (message.isOutdated()) {
            if (trace) {
                log.trace("preprocess() acking expired message=" + message.getJMSMessageID() + " " + this);
            }
            message.doAcknowledge();
            return null;
        }
        if (!this.isListening()) {
            if (this.session.transacted) {
                if (trace) {
                    log.trace("preprocess() acking message in tx message=" + message.getJMSMessageID() + " " + this);
                }
                this.session.connection.spyXAResourceManager.ackMessage(this.session.getCurrentTransactionId(), message);
            } else if (this.session.acknowledgeMode == 1 || this.session.acknowledgeMode == 3) {
                message.doAcknowledge();
            }
            if (message instanceof SpyEncapsulatedMessage) {
                return ((SpyEncapsulatedMessage)message).getMessage();
            }
            return message;
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isListening() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.listening;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sessionConsumerProcessMessage(SpyMessage message) throws JMSException {
        MessageListener thisListener;
        message.session = this.session;
        if (message.isOutdated()) {
            if (trace) {
                log.trace("consumer() acking message in tx message=" + message.getJMSMessageID() + " " + this);
            }
            message.doAcknowledge();
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            thisListener = this.messageListener;
        }
        Object anonymousTXID = null;
        if (this.session.transacted) {
            if (this.session.getCurrentTransactionId() == null) {
                anonymousTXID = this.session.connection.spyXAResourceManager.startTx();
                this.session.setCurrentTransactionId(anonymousTXID);
            }
            if (trace) {
                log.trace("consumer() acking message in tx message=" + message.getJMSMessageID() + " " + this);
            }
            this.session.connection.spyXAResourceManager.ackMessage(this.session.getCurrentTransactionId(), message);
        }
        if (thisListener != null) {
            Message mes = message;
            if (message instanceof SpyEncapsulatedMessage) {
                mes = ((SpyEncapsulatedMessage)message).getMessage();
            }
            this.session.addUnacknowlegedMessage((SpyMessage)mes);
            if (trace) {
                log.trace("consumer() before onMessage=" + message.getJMSMessageID() + " " + this);
            }
            thisListener.onMessage(mes);
            if (trace) {
                log.trace("consumer() after onMessage=" + message.getJMSMessageID() + " " + this);
            }
        }
        if (this.session.transacted) {
            if (anonymousTXID != null && this.session.getCurrentTransactionId() == anonymousTXID) {
                try {
                    if (trace) {
                        log.trace("XASession was not enlisted - Committing work using anonymous xid: " + anonymousTXID);
                    }
                    this.session.connection.spyXAResourceManager.endTx(anonymousTXID, true);
                    this.session.connection.spyXAResourceManager.commit(anonymousTXID, true);
                }
                catch (Throwable t) {
                    log.error("Could not commit", t);
                }
                finally {
                    this.session.unsetCurrentTransactionId(anonymousTXID);
                }
            }
        } else if (this.session.acknowledgeMode == 1 || this.session.acknowledgeMode == 3) {
            message.doAcknowledge();
        }
    }
}

