/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.util.NestedRuntimeException;

public class TxUtils {
    private TxUtils() {
    }

    public static boolean isActive(Transaction tx) {
        try {
            return tx != null && (tx.getStatus() == 0 || tx.getStatus() == 1);
        }
        catch (SystemException ignored) {
            throw new NestedRuntimeException(ignored);
        }
    }

    public static boolean isActive(TransactionManager tm) {
        try {
            return TxUtils.isActive(tm.getTransaction());
        }
        catch (SystemException ignored) {
            throw new NestedRuntimeException(ignored);
        }
    }

    public static boolean isActive(UserTransaction ut) {
        try {
            return ut.getStatus() == 0;
        }
        catch (SystemException ignored) {
            throw new NestedRuntimeException(ignored);
        }
    }

    public static boolean isCompleted(Transaction tx) {
        try {
            return tx == null || tx.getStatus() == 3 || tx.getStatus() == 4 || tx.getStatus() == 6;
        }
        catch (SystemException ignored) {
            throw new NestedRuntimeException(ignored);
        }
    }

    public static boolean isCompleted(TransactionManager tm) {
        try {
            return TxUtils.isCompleted(tm.getTransaction());
        }
        catch (SystemException ignored) {
            throw new NestedRuntimeException(ignored);
        }
    }

    public static boolean isCompleted(UserTransaction ut) {
        try {
            return ut.getStatus() == 3 || ut.getStatus() == 4 || ut.getStatus() == 6;
        }
        catch (SystemException ignored) {
            throw new NestedRuntimeException(ignored);
        }
    }
}

