/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetMetaData;
import oracle.jdbc.rowset.OracleRow;
import oracle.jdbc.rowset.OracleRowSetMetaData;
import oracle.jdbc.rowset.OracleWebRowSet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class OracleWebRowSetXmlReaderContHandler
extends DefaultHandler {
    private OracleWebRowSet wrset;
    private RowSetMetaData rsetMetaData;
    private Vector updates;
    private Vector keyCols;
    private String columnValue;
    private String propertyValue;
    private String metaDataValue;
    private boolean nullVal;
    private int idx;
    private Hashtable propertyNameTagMap;
    private Hashtable metadataNameTagMap;
    private Hashtable dataNameTagMap;
    private int state;
    private static final int INITIAL_STATE = 0;
    private static final int PROPERTIES_STATE = 1;
    private static final int METADATA_STATE = 2;
    private static final int DATA_STATE = 3;
    private int tag;
    private static final int NO_TAG = -1;
    private String[] propertyNames = new String[]{"command", "concurrency", "datasource", "escape-processing", "fetch-direction", "fetch-size", "isolation-level", "key-columns", "map", "max-field-size", "max-rows", "query-timeout", "read-only", "rowset-type", "show-deleted", "table-name", "url", "null", "column", "type", "class"};
    private boolean readReadOnlyValue;
    private static final int PROPERTY_COMMAND_TAG = 0;
    private static final int PROPERTY_CONCURRENCY_TAG = 1;
    private static final int PROPERTY_DATASOURCETAG = 2;
    private static final int PROPERTY_ESCAPEPROCESSING_TAG = 3;
    private static final int PROPERTY_FETCHDIRECTION_TAG = 4;
    private static final int PROPERTY_FETCHSIZE_TAG = 5;
    private static final int PROPERTY_ISOLATIONLEVEL_TAG = 6;
    private static final int PROPERTY_KEYCOLUMNS_TAG = 7;
    private static final int PROPERTY_MAP_TAG = 8;
    private static final int PROPERTY_MAXFIELDSIZE_TAG = 9;
    private static final int PROPERTY_MAXROWS_TAG = 10;
    private static final int PROPERTY_QUERYTIMEOUT_TAG = 11;
    private static final int PROPERTY_READONLY_TAG = 12;
    private static final int PROPERTY_ROWSETTYPE_TAG = 13;
    private static final int PROPERTY_SHOWDELETED_TAG = 14;
    private static final int PROPERTY_TABLENAME_TAG = 15;
    private static final int PROPERTY_URL_TAG = 16;
    private static final int PROPERTY_NULL_TAG = 17;
    private static final int PROPERTY_COLUMN_TAG = 18;
    private static final int PROPERTY_TYPE_TAG = 19;
    private static final int PROPERTY_CLASS_TAG = 20;
    private String[] metadataNames = new String[]{"column-count", "column-definition", "column-index", "auto-increment", "case-sensitive", "currency", "nullable", "signed", "searchable", "column-display-size", "column-label", "column-name", "schema-name", "column-precision", "column-scale", "table-name", "catalog-name", "column-type", "column-type-name", "null"};
    private static final int METADATA_COLUMNCOUNT_TAG = 0;
    private static final int METADATA_COLUMNDEFINITION_TAG = 1;
    private static final int METADATA_COLUMNINDEX_TAG = 2;
    private static final int METADATA_AUTOINCREMENt_TAG = 3;
    private static final int METADATA_CASESENSITIVE_TAG = 4;
    private static final int METADATA_CURRENCY_TAG = 5;
    private static final int METADATA_NULLABLE_TAG = 6;
    private static final int METADATA_SIGNED_TAG = 7;
    private static final int METADATA_SEARCHABLE_TAG = 8;
    private static final int METADATA_COLUMNDISPLAYSIZE_TAG = 9;
    private static final int METADATA_COLUMNLABEL_TAG = 10;
    private static final int METADATA_COLUMNNAME_TAG = 11;
    private static final int METADATA_SCHEMANAME_TAG = 12;
    private static final int METADATA_COLUMNPRECISION_TAG = 13;
    private static final int METADATA_COLUMNSCALE_TAG = 14;
    private static final int METADATA_TABLENAME_TAG = 15;
    private static final int METADATA_CATALOGNAME_TAG = 16;
    private static final int METADATA_COLUMNTYPE_TAG = 17;
    private static final int METADATA_COLUMNTYPENAME_TAG = 18;
    private static final int METADATA_NULL_TAG = 19;
    private String[] dataNames = new String[]{"row", "col", "ins", "del", "insdel", "upd", "null"};
    private static final int DATA_ROW_TAG = 0;
    private static final int DATA_COL_TAG = 1;
    private static final int DATA_INS_TAG = 2;
    private static final int DATA_DEL_TAG = 3;
    private static final int DATA_INSDEL_TAG = 4;
    private static final int DATA_UPD_TAG = 5;
    private static final int DATA_NULL_TAG = 6;

    OracleWebRowSetXmlReaderContHandler(RowSet rowSet) {
        this.wrset = (OracleWebRowSet)rowSet;
        this.initialize();
    }

    private void applyUpdates() throws SAXException {
        if (this.updates.size() > 0) {
            try {
                Iterator iterator = ((AbstractList)this.updates).iterator();
                while (iterator.hasNext()) {
                    Object[] objectArray = (Object[])iterator.next();
                    this.idx = (Integer)objectArray[0];
                    this.insertValue((String)objectArray[1]);
                }
                this.wrset.updateRow();
            }
            catch (SQLException sQLException) {
                throw new SAXException("Error updating row: " + sQLException.getMessage());
            }
            this.updates.removeAllElements();
        }
    }

    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        try {
            switch (this.getState()) {
                case 1: {
                    this.propertyValue = new String(cArray, n2, n3);
                    break;
                }
                case 2: {
                    this.metaDataValue = new String(cArray, n2, n3);
                    break;
                }
                case 3: {
                    this.setDataValue(cArray, n2, n3);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SAXException("characters: " + sQLException.getMessage());
        }
    }

    public void endDocument() throws SAXException {
        try {
            if (this.readReadOnlyValue) {
                this.wrset.setReadOnly(this.readReadOnlyValue);
            }
        }
        catch (SQLException sQLException) {
            throw new SAXException(sQLException.getMessage());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        block8 : switch (this.getState()) {
            case 1: {
                if (string3.equals("properties")) {
                    this.state = 0;
                    break;
                }
                try {
                    int n2 = (Integer)this.propertyNameTagMap.get(string3);
                    switch (n2) {
                        case 7: {
                            if (this.keyCols == null) break;
                            int[] nArray = new int[this.keyCols.size()];
                            int n3 = 0;
                            while (n3 < nArray.length) {
                                nArray[n3] = Integer.parseInt((String)this.keyCols.elementAt(n3));
                                ++n3;
                            }
                            break;
                        }
                    }
                    if (this.getNullValue()) {
                        this.setPropertyValue(null);
                        this.setNullValue(false);
                    } else {
                        this.setPropertyValue(this.propertyValue);
                    }
                }
                catch (SQLException sQLException) {
                    throw new SAXException(sQLException.getMessage());
                }
                this.propertyValue = new String("");
                this.setTag(-1);
                break;
            }
            case 2: {
                if (string3.equals("metadata")) {
                    try {
                        this.wrset.setMetaData(this.rsetMetaData);
                        this.wrset.setColumnCount(this.rsetMetaData.getColumnCount());
                        this.state = 0;
                    }
                    catch (SQLException sQLException) {
                        throw new SAXException("Error setting metadata in WebRowSet: " + sQLException.getMessage());
                    }
                }
                try {
                    if (this.getNullValue()) {
                        this.setMetaDataValue(null);
                        this.setNullValue(false);
                    } else {
                        this.setMetaDataValue(this.metaDataValue);
                    }
                }
                catch (SQLException sQLException) {
                    throw new SAXException("Error setting metadata value: " + sQLException.getMessage());
                }
                this.metaDataValue = new String("");
                this.setTag(-1);
                break;
            }
            case 3: {
                if (string3.equals("data")) {
                    this.state = 0;
                    return;
                }
                int n4 = (Integer)this.dataNameTagMap.get(string3);
                switch (n4) {
                    case 1: {
                        try {
                            ++this.idx;
                            if (this.getNullValue()) {
                                this.insertValue(null);
                                this.setNullValue(false);
                            } else {
                                this.insertValue(this.columnValue);
                            }
                            this.columnValue = new String("");
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error inserting column values: " + sQLException.getMessage());
                        }
                    }
                    case 0: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            OracleRow oracleRow = this.wrset.getCurrentRow();
                            oracleRow.setInsertedFlag(false);
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing row: " + sQLException.getMessage());
                        }
                    }
                    case 3: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            OracleRow oracleRow = this.wrset.getCurrentRow();
                            oracleRow.setInsertedFlag(false);
                            oracleRow.setRowDeleted(true);
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing deleted row: " + sQLException.getMessage());
                        }
                    }
                    case 2: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing inserted row: " + sQLException.getMessage());
                        }
                    }
                    case 4: {
                        try {
                            this.wrset.insertRow();
                            this.wrset.moveToCurrentRow();
                            this.wrset.next();
                            OracleRow oracleRow = this.wrset.getCurrentRow();
                            oracleRow.setRowDeleted(true);
                            this.applyUpdates();
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw new SAXException("Error constructing insdel row: " + sQLException.getMessage());
                        }
                    }
                }
            }
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    private BigDecimal getBigDecimalValue(String string) {
        return new BigDecimal(string);
    }

    private byte[] getBinaryValue(String string) {
        return string.getBytes();
    }

    private boolean getBooleanValue(String string) {
        return new Boolean(string);
    }

    private byte getByteValue(String string) {
        return Byte.parseByte(string);
    }

    private Date getDateValue(String string) {
        return new Date(this.getLongValue(string));
    }

    private double getDoubleValue(String string) {
        return Double.parseDouble(string);
    }

    private float getFloatValue(String string) {
        return Float.parseFloat(string);
    }

    private int getIntegerValue(String string) {
        return Integer.parseInt(string);
    }

    private long getLongValue(String string) {
        return Long.parseLong(string);
    }

    private boolean getNullValue() {
        return this.nullVal;
    }

    private short getShortValue(String string) {
        return Short.parseShort(string);
    }

    private int getState() {
        return this.state;
    }

    private String getStringValue(String string) {
        return string;
    }

    private int getTag() {
        return this.tag;
    }

    private Time getTimeValue(String string) {
        return new Time(this.getLongValue(string));
    }

    private Timestamp getTimestampValue(String string) {
        return new Timestamp(this.getLongValue(string));
    }

    private void initialize() {
        this.propertyNameTagMap = new Hashtable(30);
        int n2 = this.propertyNames.length;
        int n3 = 0;
        while (n3 < n2) {
            this.propertyNameTagMap.put(this.propertyNames[n3], new Integer(n3));
            ++n3;
        }
        this.metadataNameTagMap = new Hashtable(30);
        n2 = this.metadataNames.length;
        int n4 = 0;
        while (n4 < n2) {
            this.metadataNameTagMap.put(this.metadataNames[n4], new Integer(n4));
            ++n4;
        }
        this.dataNameTagMap = new Hashtable(10);
        n2 = this.dataNames.length;
        int n5 = 0;
        while (n5 < n2) {
            this.dataNameTagMap.put(this.dataNames[n5], new Integer(n5));
            ++n5;
        }
        this.updates = new Vector();
        this.columnValue = new String("");
        this.propertyValue = new String("");
        this.metaDataValue = new String("");
        this.nullVal = false;
        this.idx = 0;
        this.readReadOnlyValue = false;
    }

    private void insertValue(String string) throws SQLException {
        if (this.getNullValue()) {
            this.wrset.updateNull(this.idx);
            return;
        }
        int n2 = this.wrset.getMetaData().getColumnType(this.idx);
        switch (n2) {
            case -7: {
                this.wrset.updateByte(this.idx, this.getByteValue(string));
                break;
            }
            case 5: {
                this.wrset.updateShort(this.idx, this.getShortValue(string));
                break;
            }
            case 4: {
                this.wrset.updateInt(this.idx, this.getIntegerValue(string));
                break;
            }
            case -5: {
                this.wrset.updateLong(this.idx, this.getLongValue(string));
                break;
            }
            case 6: 
            case 7: {
                this.wrset.updateFloat(this.idx, this.getFloatValue(string));
                break;
            }
            case 8: {
                this.wrset.updateDouble(this.idx, this.getDoubleValue(string));
                break;
            }
            case 2: 
            case 3: {
                this.wrset.updateObject(this.idx, (Object)this.getBigDecimalValue(string));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                this.wrset.updateBytes(this.idx, this.getBinaryValue(string));
                break;
            }
            case 91: {
                this.wrset.updateDate(this.idx, this.getDateValue(string));
                break;
            }
            case 92: {
                this.wrset.updateTime(this.idx, this.getTimeValue(string));
                break;
            }
            case 93: {
                this.wrset.updateTimestamp(this.idx, this.getTimestampValue(string));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                this.wrset.updateString(this.idx, this.getStringValue(string));
                break;
            }
            default: {
                throw new SQLException("The type " + n2 + " is not supported currently.");
            }
        }
    }

    private void setDataValue(char[] cArray, int n2, int n3) throws SQLException {
        switch (this.getTag()) {
            case 1: {
                this.columnValue = new String(cArray, n2, n3);
                break;
            }
            case 5: {
                Object[] objectArray = new Object[2];
                objectArray[1] = new String(cArray, n2, n3);
                objectArray[0] = new Integer(this.idx);
                this.updates.add(objectArray);
            }
        }
    }

    private void setMetaDataValue(String string) throws SQLException {
        boolean bl = this.getNullValue();
        switch (this.getTag()) {
            case 0: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                int n2 = this.getIntegerValue(string);
                this.rsetMetaData = new OracleRowSetMetaData(n2);
                this.idx = 0;
                break;
            }
            case 2: {
                ++this.idx;
                break;
            }
            case 3: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.rsetMetaData.setAutoIncrement(this.idx, this.getBooleanValue(string));
                break;
            }
            case 4: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.rsetMetaData.setCaseSensitive(this.idx, this.getBooleanValue(string));
                break;
            }
            case 5: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.rsetMetaData.setCurrency(this.idx, this.getBooleanValue(string));
                break;
            }
            case 6: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.rsetMetaData.setNullable(this.idx, this.getIntegerValue(string));
                break;
            }
            case 7: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.rsetMetaData.setSigned(this.idx, this.getBooleanValue(string));
                break;
            }
            case 8: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.rsetMetaData.setSearchable(this.idx, this.getBooleanValue(string));
                break;
            }
            case 9: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.rsetMetaData.setColumnDisplaySize(this.idx, this.getIntegerValue(string));
                break;
            }
            case 10: {
                if (bl) {
                    this.rsetMetaData.setColumnLabel(this.idx, null);
                    break;
                }
                this.rsetMetaData.setColumnLabel(this.idx, string);
                break;
            }
            case 11: {
                if (bl) {
                    this.rsetMetaData.setColumnName(this.idx, null);
                    break;
                }
                this.rsetMetaData.setColumnName(this.idx, string);
                break;
            }
            case 12: {
                if (bl) {
                    this.rsetMetaData.setSchemaName(this.idx, null);
                    break;
                }
                this.rsetMetaData.setSchemaName(this.idx, string);
                break;
            }
            case 13: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.rsetMetaData.setPrecision(this.idx, this.getIntegerValue(string));
                break;
            }
            case 14: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.rsetMetaData.setScale(this.idx, this.getIntegerValue(string));
                break;
            }
            case 15: {
                if (bl) {
                    this.rsetMetaData.setTableName(this.idx, null);
                    break;
                }
                this.rsetMetaData.setTableName(this.idx, string);
                break;
            }
            case 16: {
                if (bl) {
                    this.rsetMetaData.setCatalogName(this.idx, null);
                    break;
                }
                this.rsetMetaData.setCatalogName(this.idx, string);
                break;
            }
            case 17: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable metadata");
                }
                this.rsetMetaData.setColumnType(this.idx, this.getIntegerValue(string));
                break;
            }
            case 18: {
                if (bl) {
                    this.rsetMetaData.setColumnTypeName(this.idx, null);
                    break;
                }
                this.rsetMetaData.setColumnTypeName(this.idx, string);
            }
        }
    }

    private void setNullValue(boolean bl) {
        this.nullVal = bl;
    }

    private void setPropertyValue(String string) throws SQLException {
        boolean bl = this.getNullValue();
        switch (this.getTag()) {
            case 0: {
                if (bl) {
                    this.wrset.setCommand(null);
                    break;
                }
                this.wrset.setCommand(string);
                break;
            }
            case 1: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.wrset.setConcurrency(this.getIntegerValue(string));
                break;
            }
            case 2: {
                if (bl) {
                    this.wrset.setDataSourceName(null);
                    break;
                }
                this.wrset.setDataSourceName(string);
                break;
            }
            case 3: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.wrset.setEscapeProcessing(this.getBooleanValue(string));
                break;
            }
            case 4: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                int n2 = this.wrset.getType();
                if (n2 == 1005) break;
                this.wrset.setFetchDirection(this.getIntegerValue(string));
                break;
            }
            case 5: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.wrset.setFetchSize(this.getIntegerValue(string));
                break;
            }
            case 6: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.wrset.setTransactionIsolation(this.getIntegerValue(string));
                break;
            }
            case 18: {
                if (this.keyCols == null) {
                    this.keyCols = new Vector();
                }
                this.keyCols.add(string);
                break;
            }
            case 9: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.wrset.setMaxFieldSize(this.getIntegerValue(string));
                break;
            }
            case 10: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.wrset.setMaxRows(this.getIntegerValue(string));
                break;
            }
            case 11: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.wrset.setQueryTimeout(this.getIntegerValue(string));
                break;
            }
            case 12: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.readReadOnlyValue = this.getBooleanValue(string);
                break;
            }
            case 13: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.wrset.setType(this.getIntegerValue(string));
                break;
            }
            case 14: {
                if (bl) {
                    throw new SQLException("Bad value; non-nullable property");
                }
                this.wrset.setShowDeleted(this.getBooleanValue(string));
                break;
            }
            case 16: {
                if (bl) {
                    this.wrset.setUrl(null);
                    break;
                }
                this.wrset.setUrl(string);
            }
        }
    }

    private void setState(String string) throws SAXException {
        if (string.equals("RowSet")) {
            this.state = 0;
        } else if (string.equals("properties")) {
            this.state = this.state != 1 ? 1 : 0;
        } else if (string.equals("metadata")) {
            this.state = this.state != 2 ? 2 : 0;
        } else if (string.equals("data")) {
            this.state = this.state != 3 ? 3 : 0;
        }
    }

    private void setTag(int n2) {
        this.tag = n2;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        switch (this.getState()) {
            case 1: {
                int n2 = (Integer)this.propertyNameTagMap.get(string3);
                if (n2 == 17) {
                    this.setNullValue(true);
                    break;
                }
                this.setTag(n2);
                break;
            }
            case 2: {
                int n3 = (Integer)this.metadataNameTagMap.get(string3);
                if (n3 == 19) {
                    this.setNullValue(true);
                    break;
                }
                this.setTag(n3);
                break;
            }
            case 3: {
                int n4 = (Integer)this.dataNameTagMap.get(string3);
                if (n4 == 6) {
                    this.setNullValue(true);
                    break;
                }
                this.setTag(n4);
                if (n4 != 0 && n4 != 2 && n4 != 3) break;
                this.idx = 0;
                try {
                    this.wrset.moveToInsertRow();
                }
                catch (SQLException sQLException) {}
                break;
            }
            default: {
                this.setState(string3);
            }
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }
}

