/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.net.bsd.RExecClient;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class RExecTask
extends Task {
    private String userid = null;
    private String password = null;
    private String command = null;
    private String server = null;
    private int port = 512;
    private Vector rexecTasks = new Vector();
    private boolean addCarriageReturn = false;
    private Integer defaultTimeout = null;

    public RExecSubTask createRead() {
        RExecRead task = new RExecRead();
        this.rexecTasks.addElement(task);
        return task;
    }

    public RExecSubTask createWrite() {
        RExecWrite task = new RExecWrite();
        this.rexecTasks.addElement(task);
        return task;
    }

    public void execute() throws BuildException {
        if (this.server == null) {
            throw new BuildException("No Server Specified");
        }
        if (this.userid == null && this.password != null) {
            throw new BuildException("No Userid Specified");
        }
        if (this.password == null && this.userid != null) {
            throw new BuildException("No Password Specified");
        }
        AntRExecClient rexec = null;
        try {
            rexec = new AntRExecClient();
            try {
                rexec.connect(this.server, this.port);
            }
            catch (IOException e) {
                throw new BuildException("Can't connect to " + this.server);
            }
            if (this.userid != null && this.password != null && this.command != null && this.rexecTasks.size() == 0) {
                rexec.rexec(this.userid, this.password, this.command);
            } else {
                this.handleMultipleTasks(rexec);
            }
            rexec.waitForEOF(this.defaultTimeout);
        }
        catch (IOException e) {
            throw new BuildException("Error r-executing command", e);
        }
        finally {
            if (rexec != null && rexec.isConnected()) {
                try {
                    rexec.disconnect();
                }
                catch (IOException e) {
                    throw new BuildException("Error disconnecting from " + this.server);
                }
            }
        }
    }

    private void login(AntRExecClient rexec) {
        if (this.addCarriageReturn) {
            rexec.sendString("\n", true);
        }
        rexec.waitForString("ogin:");
        rexec.sendString(this.userid, true);
        rexec.waitForString("assword:");
        rexec.sendString(this.password, false);
    }

    public void setCommand(String c) {
        this.command = c;
    }

    public void setInitialCR(boolean b) {
        this.addCarriageReturn = b;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setServer(String m) {
        this.server = m;
    }

    public void setTimeout(Integer i) {
        this.defaultTimeout = i;
    }

    public void setUserid(String u) {
        this.userid = u;
    }

    private void handleMultipleTasks(AntRExecClient rexec) {
        if (this.userid != null && this.password != null) {
            this.login(rexec);
        }
        Enumeration tasksToRun = this.rexecTasks.elements();
        while (tasksToRun != null && tasksToRun.hasMoreElements()) {
            RExecSubTask task = (RExecSubTask)tasksToRun.nextElement();
            if (task instanceof RExecRead && this.defaultTimeout != null) {
                ((RExecRead)task).setDefaultTimeout(this.defaultTimeout);
            }
            task.execute(rexec);
        }
    }

    public class AntRExecClient
    extends RExecClient {
        public void waitForString(String s) {
            this.waitForString(s, null);
        }

        public void waitForString(String s, Integer timeout) {
            InputStream is = this.getInputStream();
            try {
                StringBuffer sb = new StringBuffer();
                if (timeout == null || timeout == 0) {
                    while (sb.toString().indexOf(s) == -1) {
                        sb.append((char)is.read());
                    }
                } else {
                    Calendar endTime = Calendar.getInstance();
                    endTime.add(13, timeout);
                    while (sb.toString().indexOf(s) == -1) {
                        while (Calendar.getInstance().before(endTime) && is.available() == 0) {
                            Thread.sleep(250L);
                        }
                        if (is.available() == 0) {
                            throw new BuildException("Response timed-out waiting for \"" + s + '\"', RExecTask.this.getLocation());
                        }
                        sb.append((char)is.read());
                    }
                }
                RExecTask.this.log(sb.toString(), 2);
            }
            catch (BuildException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BuildException(e, RExecTask.this.getLocation());
            }
        }

        public void sendString(String s, boolean echoString) {
            OutputStream os = this.getOutputStream();
            try {
                os.write((s + "\n").getBytes());
                if (echoString) {
                    RExecTask.this.log(s, 2);
                }
                os.flush();
            }
            catch (Exception e) {
                throw new BuildException(e, RExecTask.this.getLocation());
            }
        }

        public void waitForEOF(Integer timeout) {
            InputStream is = this.getInputStream();
            try {
                StringBuffer sb = new StringBuffer();
                if (timeout == null || timeout == 0) {
                    int read;
                    while ((read = is.read()) != -1) {
                        char c = (char)read;
                        sb.append(c);
                        if (c != '\n') continue;
                        RExecTask.this.log(sb.toString(), 2);
                        sb.delete(0, sb.length());
                    }
                } else {
                    Calendar endTime = Calendar.getInstance();
                    endTime.add(13, timeout);
                    int read = 0;
                    while (read != -1) {
                        while (Calendar.getInstance().before(endTime) && is.available() == 0) {
                            Thread.sleep(250L);
                        }
                        if (is.available() == 0) {
                            RExecTask.this.log(sb.toString(), 2);
                            throw new BuildException("Response timed-out waiting for EOF", RExecTask.this.getLocation());
                        }
                        read = is.read();
                        if (read == -1) continue;
                        char c = (char)read;
                        sb.append(c);
                        if (c != '\n') continue;
                        RExecTask.this.log(sb.toString(), 2);
                        sb.delete(0, sb.length());
                    }
                }
                if (sb.length() > 0) {
                    RExecTask.this.log(sb.toString(), 2);
                }
            }
            catch (BuildException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BuildException(e, RExecTask.this.getLocation());
            }
        }
    }

    public class RExecRead
    extends RExecSubTask {
        private Integer timeout = null;

        public void execute(AntRExecClient rexec) throws BuildException {
            rexec.waitForString(this.taskString, this.timeout);
        }

        public void setTimeout(Integer i) {
            this.timeout = i;
        }

        public void setDefaultTimeout(Integer defaultTimeout) {
            if (this.timeout == null) {
                this.timeout = defaultTimeout;
            }
        }
    }

    public class RExecWrite
    extends RExecSubTask {
        private boolean echoString = true;

        public void execute(AntRExecClient rexec) throws BuildException {
            rexec.sendString(this.taskString, this.echoString);
        }

        public void setEcho(boolean b) {
            this.echoString = b;
        }
    }

    public class RExecSubTask {
        protected String taskString = "";

        public void execute(AntRExecClient rexec) throws BuildException {
            throw new BuildException("Shouldn't be able instantiate a SubTask directly");
        }

        public void addText(String s) {
            this.setString(RExecTask.this.getProject().replaceProperties(s));
        }

        public void setString(String s) {
            this.taskString = this.taskString + s;
        }
    }
}

