/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.regex.Pattern;
import oracle.jdbc.OracleDriver;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;

public class ConfigOracle
extends Config {
    private static OracleDriver s_oracleDriver = null;
    private String[] p_discovered = null;
    private Connection m_con = null;
    private boolean m_XE = false;

    public ConfigOracle(ConfigurationData data, boolean XE) {
        super(data);
        this.m_XE = XE;
    }

    public void init() {
        this.p_data.setDatabasePort(String.valueOf(1521));
        this.p_data.setDatabaseSystemPassword(true);
        this.p_data.setDatabaseName(true);
        this.p_data.setDatabaseDiscovered(!this.m_XE);
        this.p_data.setDatabaseUser(true);
    }

    public String[] discoverDatabases(String selected) {
        String serviceName;
        if (this.p_discovered != null) {
            return this.p_discovered;
        }
        ArrayList<String> list = new ArrayList<String>();
        String def = selected;
        if (def != null && def.trim().length() == 0) {
            def = null;
        }
        if (def != null) {
            list.add(def.toLowerCase());
        }
        if (this.m_XE && !list.contains(serviceName = "xe")) {
            list.add(serviceName);
        }
        String path = System.getProperty("java.library.path");
        String[] entries = path.split(File.pathSeparator);
        for (int e = 0; e < entries.length; ++e) {
            StringBuffer sb;
            String[] serviceNames;
            String entry = entries[e].toLowerCase();
            if (entry.indexOf("ora") == -1 || !entry.endsWith("bin") || (serviceNames = this.getTNS_Names(sb = this.getTNS_File(entries[e].substring(0, entries[e].length() - 4)))) == null) continue;
            for (int i = 0; i < serviceNames.length; ++i) {
                String serviceName2 = serviceNames[i].toLowerCase();
                if (list.contains(serviceName2)) continue;
                list.add(serviceName2);
            }
            break;
        }
        this.p_discovered = new String[list.size()];
        list.toArray(this.p_discovered);
        return this.p_discovered;
    }

    private StringBuffer getTNS_File(String oraHome) {
        String tnsnames = oraHome + File.separator + "network" + File.separator + "admin" + File.separator + "tnsnames.ora";
        File tnsfile = new File(tnsnames);
        if (!tnsfile.exists()) {
            return null;
        }
        this.log.fine(tnsnames);
        StringBuffer sb = new StringBuffer();
        try {
            int c;
            FileReader fr = new FileReader(tnsfile);
            while ((c = fr.read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (IOException ex) {
            this.log.warning("Error Reading " + tnsnames);
            ex.printStackTrace();
            return null;
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb;
    }

    private String[] getTNS_Names(StringBuffer tnsnames) {
        if (tnsnames == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile("$", 8);
        String[] lines = pattern.split(tnsnames);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            this.log.finest(i + ": " + line);
            if (line.length() <= 0 || line.toUpperCase().indexOf("SERVICE_NAME") == -1) continue;
            String entry = line.substring(line.indexOf(61) + 1).trim().toLowerCase();
            int index = entry.indexOf(41);
            if (index != 0) {
                entry = entry.substring(0, index).trim();
            }
            this.log.fine(entry);
            list.add(entry);
        }
        if (list.size() == 0) {
            return null;
        }
        String[] retValue = new String[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public String test() {
        String server = this.p_data.getDatabaseServer();
        boolean pass = server != null && server.length() > 0 && server.toLowerCase().indexOf("localhost") == -1 && !server.equals("127.0.0.1");
        String error = "Not correct: DB Server = " + server;
        InetAddress databaseServer = null;
        try {
            if (pass) {
                databaseServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = error + " - " + e.getMessage();
            pass = false;
        }
        this.signalOK(this.getPanel().okDatabaseServer, "ErrorDatabaseServer", pass, true, error);
        this.log.info("OK: Database Server = " + databaseServer);
        this.setProperty("COMPIERE_DB_SERVER", databaseServer.getHostName());
        this.setProperty("COMPIERE_DB_TYPE", this.p_data.getDatabaseType());
        this.setProperty("COMPIERE_DB_PATH", "oracle");
        int databasePort = this.p_data.getDatabasePort();
        pass = this.p_data.testPort(databaseServer, databasePort, true);
        error = "DB Server Port = " + databasePort;
        this.signalOK(this.getPanel().okDatabaseServer, "ErrorDatabasePort", pass, true, error);
        if (!pass) {
            return error;
        }
        this.log.info("OK: Database Port = " + databasePort);
        this.setProperty("COMPIERE_DB_PORT", String.valueOf(databasePort));
        String databaseName = this.p_data.getDatabaseName();
        String systemPassword = this.p_data.getDatabaseSystemPassword();
        pass = systemPassword != null && systemPassword.length() > 0;
        error = "No Database System Password entered";
        this.signalOK(this.getPanel().okDatabaseSystem, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        String url = "jdbc:oracle:thin:@//" + databaseServer.getHostName() + ":" + databasePort + "/" + databaseName;
        pass = this.testJDBC(url, "system", systemPassword);
        error = "Error connecting: " + url + " - as system/" + systemPassword;
        this.signalOK(this.getPanel().okDatabaseSystem, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        this.log.info("OK: Connection = " + url);
        this.setProperty("COMPIERE_DB_URL", url);
        this.log.info("OK: Database System User " + databaseName);
        this.setProperty("COMPIERE_DB_NAME", databaseName);
        this.setProperty("COMPIERE_DB_SYSTEM", systemPassword);
        String databaseUser = this.p_data.getDatabaseUser();
        String databasePassword = this.p_data.getDatabasePassword();
        pass = databasePassword != null && databasePassword.length() > 0;
        error = "Invalid Database User Password";
        this.signalOK(this.getPanel().okDatabaseUser, "ErrorJDBC", pass, true, error);
        if (!pass) {
            return error;
        }
        pass = this.testJDBC(url, databaseUser, databasePassword);
        error = "Cannot connect to User: " + databaseUser + "/" + databasePassword + " - Database may not be imported yet (OK on initial run).";
        this.signalOK(this.getPanel().okDatabaseUser, "ErrorJDBC", pass, false, error);
        if (pass) {
            this.log.info("OK: Database User = " + databaseUser);
            if (this.m_con != null) {
                this.setProperty("COMPIERE_WEBSTORES", this.getWebStores(this.m_con));
            }
            this.setProperty("COMPIERE_DB_USER_EXISTS", "Y");
        } else {
            this.setProperty("COMPIERE_DB_USER_EXISTS", "N");
            this.log.warning(error);
        }
        this.setProperty("COMPIERE_DB_USER", databaseUser);
        this.setProperty("COMPIERE_DB_PASSWORD", databasePassword);
        if (System.getProperty("TestOCI", "N").equals("Y")) {
            url = "jdbc:oracle:oci8:@" + databaseName;
            pass = this.testJDBC(url, "system", systemPassword);
            if (pass) {
                this.log.info("OK: Connection = " + url);
            } else {
                this.log.warning("Cannot connect via Net8: " + url);
            }
        }
        this.log.info("OCI Test Skipped");
        this.m_con = null;
        return null;
    }

    private boolean testJDBC(String url, String uid, String pwd) {
        this.log.fine("Url=" + url + ", UID=" + uid);
        try {
            if (s_oracleDriver == null) {
                s_oracleDriver = new OracleDriver();
                DriverManager.registerDriver((Driver)s_oracleDriver);
            }
            this.m_con = DriverManager.getConnection(url, uid, pwd);
        }
        catch (UnsatisfiedLinkError ule) {
            this.log.warning("Check [ORACLE_HOME]/jdbc/Readme.txt for (OCI) driver setup");
            this.log.warning(ule.toString());
        }
        catch (Exception e) {
            this.log.warning(e.toString());
            return false;
        }
        return true;
    }
}

