/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.io.File;
import java.util.Properties;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;
import org.compiere.install.Setup;
import org.compiere.util.CLogMgt;

public class ConfigVMIBM
extends Config {
    public ConfigVMIBM(ConfigurationData data) {
        super(data);
    }

    public void init() {
        String javaHome = System.getProperty("java.home");
        this.log.fine(javaHome);
        if (javaHome.endsWith("jre")) {
            javaHome = javaHome.substring(0, javaHome.length() - 4);
        }
        this.p_data.setJavaHome(javaHome);
        this.p_data.setAppsServerJNPPortLabel(Setup.res.getString("JNDIPort"));
        this.p_data.setAppsServerType("ibmWAS");
    }

    public String test() {
        File javaHome = new File(this.p_data.getJavaHome());
        boolean pass = javaHome.exists();
        String error = "Not found: Java Home";
        this.signalOK(this.getPanel().okJavaHome, "ErrorJavaHome", pass, true, error);
        if (!pass) {
            return error;
        }
        File tools = new File(this.p_data.getJavaHome() + File.separator + "lib" + File.separator + "tools.jar");
        pass = tools.exists();
        error = "Not found: Java SDK = " + tools;
        this.signalOK(this.getPanel().okJavaHome, "ErrorJavaHome", pass, true, error);
        if (!pass) {
            return error;
        }
        if (CLogMgt.isLevelFinest()) {
            CLogMgt.printProperties((Properties)System.getProperties(), (String)"System", (boolean)true);
        }
        this.log.info("OK: JavaHome=" + javaHome.getAbsolutePath());
        this.setProperty("JAVA_HOME", javaHome.getAbsolutePath());
        System.setProperty("JAVA_HOME", javaHome.getAbsolutePath());
        this.setProperty("COMPIERE_JAVA_TYPE", this.p_data.getJavaType());
        return null;
    }
}

