/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.compiere.Compiere;
import org.compiere.apps.SwingWorker;
import org.compiere.install.ComponentFileFilter;
import org.compiere.install.ComponentInfo;
import org.compiere.install.ConfigurationData;
import org.compiere.install.Setup;
import org.compiere.install.Setup_Help;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CPassword;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;

public class ConfigurationPanel
extends CPanel
implements ActionListener,
ListSelectionListener {
    private static CLogger log = CLogger.getCLogger(ConfigurationPanel.class);
    String m_errorString;
    volatile boolean m_success = false;
    volatile boolean m_testing = false;
    JLabel m_statusBar;
    private ConfigurationData m_data;
    private static ImageIcon iOpen = new ImageIcon(ConfigurationPanel.class.getResource("openFile.gif"));
    private static ImageIcon iSave = new ImageIcon(Compiere.class.getResource("images/Save16.gif"));
    private static ImageIcon iHelp = new ImageIcon(Compiere.class.getResource("images/Help16.gif"));
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private static final int FIELDLENGTH = 15;
    private CLabel lJavaHome = new CLabel();
    CTextField fJavaHome = new CTextField(15);
    CCheckBox okJavaHome = new CCheckBox();
    private CButton bJavaHome = new CButton((Icon)iOpen);
    private CLabel lJavaType = new CLabel();
    CComboBox fJavaType = new CComboBox((Object[])ConfigurationData.JAVATYPE);
    private CLabel lCompiereHome = new CLabel();
    CTextField fCompiereHome = new CTextField(15);
    CCheckBox okCompiereHome = new CCheckBox();
    private CButton bCompiereHome = new CButton((Icon)iOpen);
    private CLabel lKeyStore = new CLabel();
    CPassword fKeyStore = new CPassword();
    CCheckBox okKeyStore = new CCheckBox();
    CLabel lAppsServer = new CLabel();
    CTextField fAppsServer = new CTextField(15);
    CCheckBox okAppsServer = new CCheckBox();
    private CLabel lAppsType = new CLabel();
    CComboBox fAppsType = new CComboBox((Object[])ConfigurationData.APPSTYPE);
    private CLabel lDeployDir = new CLabel();
    CTextField fDeployDir = new CTextField(15);
    CCheckBox okDeployDir = new CCheckBox();
    CButton bDeployDir = new CButton((Icon)iOpen);
    CLabel lJNPPort = new CLabel();
    CTextField fJNPPort = new CTextField(15);
    CCheckBox okJNPPort = new CCheckBox();
    private CLabel lWebPort = new CLabel();
    CTextField fWebPort = new CTextField(15);
    CCheckBox okWebPort = new CCheckBox();
    private CLabel lSSLPort = new CLabel();
    CTextField fSSLPort = new CTextField(15);
    CCheckBox okSSLPort = new CCheckBox();
    private CLabel lDatabaseType = new CLabel();
    CComboBox fDatabaseType = new CComboBox((Object[])ConfigurationData.DBTYPE);
    CLabel lDatabaseServer = new CLabel();
    CTextField fDatabaseServer = new CTextField(15);
    private CLabel lDatabaseName = new CLabel();
    CTextField fDatabaseName = new CTextField(15);
    CLabel lDatabaseDiscovered = new CLabel();
    CComboBox fDatabaseDiscovered = new CComboBox();
    private CLabel lDatabasePort = new CLabel();
    CTextField fDatabasePort = new CTextField(15);
    private CLabel lSystemPassword = new CLabel();
    CPassword fSystemPassword = new CPassword();
    private CLabel lDatabaseUser = new CLabel();
    CTextField fDatabaseUser = new CTextField(15);
    private CLabel lDatabasePassword = new CLabel();
    CPassword fDatabasePassword = new CPassword();
    CCheckBox okDatabaseServer = new CCheckBox();
    CCheckBox okDatabaseUser = new CCheckBox();
    CCheckBox okDatabaseSystem = new CCheckBox();
    CCheckBox okDatabaseSQL = new CCheckBox();
    CLabel lMailServer = new CLabel();
    CTextField fMailServer = new CTextField(15);
    private CLabel lAdminEMail = new CLabel();
    CTextField fAdminEMail = new CTextField(15);
    private CLabel lMailUser = new CLabel();
    CTextField fMailUser = new CTextField(15);
    private CLabel lMailPassword = new CLabel();
    CPassword fMailPassword = new CPassword();
    CCheckBox okMailServer = new CCheckBox();
    CCheckBox okMailUser = new CCheckBox();
    CLabel lComponent = new CLabel();
    CLabel noComponents = new CLabel();
    CButton bComponentAdd = new CButton();
    DefaultListModel componentListModel = new DefaultListModel();
    JList componentList = new JList(this.componentListModel);
    JScrollPane componentPane = new JScrollPane(this.componentList);
    CCheckBox okComponents = new CCheckBox();
    private CButton bHelp = new CButton((Icon)iHelp);
    CButton bTest = new CButton();
    private CButton bSave = new CButton((Icon)iSave);

    public ConfigurationPanel(JLabel statusBar, Properties properties) {
        this.m_statusBar = statusBar;
        this.m_data = new ConfigurationData(this, properties);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        Insets bInsets = new Insets(0, 5, 0, 5);
        int rowNum = 0;
        this.lJavaHome.setToolTipText(Setup.res.getString("JavaHomeInfo"));
        this.lJavaHome.setText(Setup.res.getString("JavaHome"));
        this.fJavaHome.setText(".");
        this.okJavaHome.setReadWrite(false);
        this.okJavaHome.setOpaque(true);
        this.bJavaHome.setMargin(bInsets);
        this.bJavaHome.setToolTipText(Setup.res.getString("JavaHomeInfo"));
        this.lJavaType.setToolTipText(Setup.res.getString("JavaTypeInfo"));
        this.lJavaType.setText(Setup.res.getString("JavaType"));
        this.fJavaType.setPreferredSize(this.fJavaHome.getPreferredSize());
        this.add((Component)this.lJavaHome, new GridBagConstraints(0, rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fJavaHome, new GridBagConstraints(1, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.okJavaHome, new GridBagConstraints(2, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.bJavaHome, new GridBagConstraints(3, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lJavaType, new GridBagConstraints(4, rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fJavaType, new GridBagConstraints(5, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.lCompiereHome.setToolTipText(Setup.res.getString("CompiereHomeInfo"));
        this.lCompiereHome.setText(Setup.res.getString("CompiereHome"));
        this.fCompiereHome.setText(".");
        this.okCompiereHome.setReadWrite(false);
        this.okCompiereHome.setOpaque(true);
        this.bCompiereHome.setMargin(bInsets);
        this.bCompiereHome.setToolTipText(Setup.res.getString("CompiereHomeInfo"));
        this.lKeyStore.setText(Setup.res.getString("KeyStorePassword"));
        this.lKeyStore.setToolTipText(Setup.res.getString("KeyStorePasswordInfo"));
        this.fKeyStore.setText("");
        this.okKeyStore.setReadWrite(false);
        this.okKeyStore.setOpaque(true);
        this.add((Component)this.lCompiereHome, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fCompiereHome, new GridBagConstraints(1, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.okCompiereHome, new GridBagConstraints(2, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.bCompiereHome, new GridBagConstraints(3, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lKeyStore, new GridBagConstraints(4, rowNum, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.fKeyStore, new GridBagConstraints(5, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.okKeyStore, new GridBagConstraints(6, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.lAppsServer.setToolTipText(Setup.res.getString("AppsServerInfo"));
        this.lAppsServer.setText(Setup.res.getString("AppsServer"));
        this.lAppsServer.setFont(this.lAppsServer.getFont().deriveFont(1));
        this.fAppsServer.setText(".");
        this.okAppsServer.setReadWrite(false);
        this.okAppsServer.setOpaque(true);
        this.lAppsType.setToolTipText(Setup.res.getString("AppsTypeInfo"));
        this.lAppsType.setText(Setup.res.getString("AppsType"));
        this.fAppsType.setPreferredSize(this.fAppsServer.getPreferredSize());
        this.add((Component)this.lAppsServer, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.fAppsServer, new GridBagConstraints(1, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
        this.add((Component)this.okAppsServer, new GridBagConstraints(2, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 5, 5), 0, 0));
        this.add((Component)this.lAppsType, new GridBagConstraints(4, rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.fAppsType, new GridBagConstraints(5, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
        this.lDeployDir.setToolTipText(Setup.res.getString("DeployDirInfo"));
        this.lDeployDir.setText(Setup.res.getString("DeployDir"));
        this.fDeployDir.setText(".");
        this.okDeployDir.setReadWrite(false);
        this.okDeployDir.setOpaque(true);
        this.bDeployDir.setMargin(bInsets);
        this.bDeployDir.setToolTipText(Setup.res.getString("DeployDirInfo"));
        this.lJNPPort.setToolTipText(Setup.res.getString("JNPPortInfo"));
        this.lJNPPort.setText(Setup.res.getString("JNPPort"));
        this.fJNPPort.setText(".");
        this.okJNPPort.setReadWrite(false);
        this.okJNPPort.setOpaque(true);
        this.add((Component)this.lDeployDir, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fDeployDir, new GridBagConstraints(1, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.okDeployDir, new GridBagConstraints(2, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.bDeployDir, new GridBagConstraints(3, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lJNPPort, new GridBagConstraints(4, rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fJNPPort, new GridBagConstraints(5, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.okJNPPort, new GridBagConstraints(6, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.lWebPort.setToolTipText(Setup.res.getString("WebPortInfo"));
        this.lWebPort.setText(Setup.res.getString("WebPort"));
        this.fWebPort.setText(".");
        this.okWebPort.setReadWrite(false);
        this.okWebPort.setOpaque(true);
        this.lSSLPort.setText("SSL");
        this.fSSLPort.setText(".");
        this.okSSLPort.setReadWrite(false);
        this.okSSLPort.setOpaque(true);
        this.add((Component)this.lWebPort, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fWebPort, new GridBagConstraints(1, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.okWebPort, new GridBagConstraints(2, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.lSSLPort, new GridBagConstraints(4, rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fSSLPort, new GridBagConstraints(5, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.okSSLPort, new GridBagConstraints(6, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.lDatabaseServer.setToolTipText(Setup.res.getString("DatabaseServerInfo"));
        this.lDatabaseServer.setText(Setup.res.getString("DatabaseServer"));
        this.lDatabaseServer.setFont(this.lDatabaseServer.getFont().deriveFont(1));
        this.okDatabaseServer.setReadWrite(false);
        this.okDatabaseServer.setOpaque(true);
        this.lDatabaseType.setToolTipText(Setup.res.getString("DatabaseTypeInfo"));
        this.lDatabaseType.setText(Setup.res.getString("DatabaseType"));
        this.fDatabaseType.setPreferredSize(this.fDatabaseServer.getPreferredSize());
        this.add((Component)this.lDatabaseServer, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.fDatabaseServer, new GridBagConstraints(1, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
        this.add((Component)this.okDatabaseServer, new GridBagConstraints(2, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 5, 5), 0, 0));
        this.add((Component)this.lDatabaseType, new GridBagConstraints(4, rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.fDatabaseType, new GridBagConstraints(5, rowNum, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
        this.lDatabaseName.setToolTipText(Setup.res.getString("DatabaseNameInfo"));
        this.lDatabaseName.setText(Setup.res.getString("DatabaseName"));
        this.fDatabaseName.setText(".");
        this.lDatabaseDiscovered.setToolTipText(Setup.res.getString("TNSNameInfo"));
        this.lDatabaseDiscovered.setText(Setup.res.getString("TNSName"));
        this.fDatabaseDiscovered.setEditable(true);
        this.fDatabaseDiscovered.setPreferredSize(this.fDatabaseName.getPreferredSize());
        this.okDatabaseSQL.setReadWrite(false);
        this.okDatabaseSQL.setOpaque(true);
        this.add((Component)this.lDatabaseName, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fDatabaseName, new GridBagConstraints(1, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.lDatabaseDiscovered, new GridBagConstraints(4, rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.fDatabaseDiscovered, new GridBagConstraints(5, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.lDatabasePort.setToolTipText(Setup.res.getString("DatabasePortInfo"));
        this.lDatabasePort.setText(Setup.res.getString("DatabasePort"));
        this.fDatabasePort.setText(".");
        this.lSystemPassword.setToolTipText(Setup.res.getString("SystemPasswordInfo"));
        this.lSystemPassword.setText(Setup.res.getString("SystemPassword"));
        this.fSystemPassword.setText(".");
        this.okDatabaseSystem.setReadWrite(false);
        this.okDatabaseSystem.setOpaque(true);
        this.add((Component)this.lDatabasePort, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fDatabasePort, new GridBagConstraints(1, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.lSystemPassword, new GridBagConstraints(4, rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fSystemPassword, new GridBagConstraints(5, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.okDatabaseSystem, new GridBagConstraints(6, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.lDatabaseUser.setToolTipText(Setup.res.getString("DatabaseUserInfo"));
        this.lDatabaseUser.setText(Setup.res.getString("DatabaseUser"));
        this.fDatabaseUser.setText(".");
        this.lDatabasePassword.setToolTipText(Setup.res.getString("DatabasePasswordInfo"));
        this.lDatabasePassword.setText(Setup.res.getString("DatabasePassword"));
        this.fDatabasePassword.setText(".");
        this.okDatabaseUser.setReadWrite(false);
        this.okDatabaseUser.setOpaque(true);
        this.add((Component)this.lDatabaseUser, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fDatabaseUser, new GridBagConstraints(1, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.lDatabasePassword, new GridBagConstraints(4, rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fDatabasePassword, new GridBagConstraints(5, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.okDatabaseUser, new GridBagConstraints(6, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.lMailServer.setToolTipText(Setup.res.getString("MailServerInfo"));
        this.lMailServer.setText(Setup.res.getString("MailServer"));
        this.lMailServer.setFont(this.lMailServer.getFont().deriveFont(1));
        this.fMailServer.setText(".");
        this.lAdminEMail.setToolTipText(Setup.res.getString("AdminEMailInfo"));
        this.lAdminEMail.setText(Setup.res.getString("AdminEMail"));
        this.fAdminEMail.setText(".");
        this.okMailServer.setReadWrite(false);
        this.okMailServer.setOpaque(true);
        this.add((Component)this.lMailServer, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.fMailServer, new GridBagConstraints(1, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
        this.add((Component)this.okMailServer, new GridBagConstraints(2, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 5, 5), 0, 0));
        this.add((Component)this.lAdminEMail, new GridBagConstraints(4, rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        this.add((Component)this.fAdminEMail, new GridBagConstraints(5, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(10, 5, 5, 0), 0, 0));
        this.lMailUser.setToolTipText(Setup.res.getString("MailUserInfo"));
        this.lMailUser.setText(Setup.res.getString("MailUser"));
        this.fMailUser.setText(".");
        this.lMailPassword.setToolTipText(Setup.res.getString("MailPasswordInfo"));
        this.lMailPassword.setText(Setup.res.getString("MailPassword"));
        this.fMailPassword.setText(".");
        this.okMailUser.setReadWrite(false);
        this.okMailUser.setOpaque(true);
        this.add((Component)this.lMailUser, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fMailUser, new GridBagConstraints(1, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.lMailPassword, new GridBagConstraints(4, rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.fMailPassword, new GridBagConstraints(5, rowNum, 1, 1, 0.5, 0.0, 17, 2, new Insets(5, 5, 5, 0), 0, 0));
        this.add((Component)this.okMailUser, new GridBagConstraints(6, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.lComponent.setText(Setup.res.getString("SelectComponent"));
        this.lComponent.setToolTipText(Setup.res.getString("SelectComponentInfo"));
        this.bComponentAdd.setText(Setup.res.getString("AddComponent"));
        this.componentList.setSelectionMode(2);
        this.componentList.setLayoutOrientation(0);
        this.componentList.setVisibleRowCount(3);
        this.componentList.addListSelectionListener(this);
        this.okComponents.setReadWrite(false);
        this.okComponents.setOpaque(true);
        this.add((Component)this.lComponent, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.componentPane, new GridBagConstraints(1, rowNum, 5, 3, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.okComponents, new GridBagConstraints(6, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.add((Component)this.bComponentAdd, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.noComponents, new GridBagConstraints(6, rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        ++rowNum;
        this.bTest.setToolTipText(Setup.res.getString("TestInfo"));
        this.bTest.setText(Setup.res.getString("Test"));
        this.bSave.setToolTipText(Setup.res.getString("SaveInfo"));
        this.bSave.setText(Setup.res.getString("Save"));
        this.bHelp.setToolTipText(Setup.res.getString("HelpInfo"));
        this.add((Component)this.bTest, new GridBagConstraints(0, ++rowNum, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)this.bHelp, new GridBagConstraints(3, rowNum, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.add((Component)this.bSave, new GridBagConstraints(5, rowNum, 2, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 10, 5), 0, 0));
        this.bCompiereHome.addActionListener((ActionListener)this);
        this.bJavaHome.addActionListener((ActionListener)this);
        this.bDeployDir.addActionListener((ActionListener)this);
        this.fJavaType.addActionListener((ActionListener)this);
        this.fAppsType.addActionListener((ActionListener)this);
        this.fDatabaseType.addActionListener((ActionListener)this);
        this.fDatabaseDiscovered.addActionListener((ActionListener)this);
        this.bComponentAdd.addActionListener((ActionListener)this);
        this.bHelp.addActionListener((ActionListener)this);
        this.bTest.addActionListener((ActionListener)this);
        this.bSave.addActionListener((ActionListener)this);
    }

    public boolean dynInit() {
        return this.m_data.load();
    }

    protected void setStatusBar(String text) {
        this.m_statusBar.setText(text);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.m_testing) {
            return;
        }
        if (e.getSource() == this.fDatabaseDiscovered) {
            String dbName = (String)this.fDatabaseDiscovered.getSelectedItem();
            if (dbName != null && dbName.length() > 0) {
                this.fDatabaseName.setText(dbName);
            }
        } else if (e.getSource() == this.fJavaType) {
            this.m_data.initJava();
        } else if (e.getSource() == this.fAppsType) {
            this.m_data.initAppsServer();
        } else if (e.getSource() == this.fDatabaseType) {
            this.m_data.initDatabase("");
        } else if (e.getSource() == this.bJavaHome) {
            this.setPath(this.fJavaHome);
        } else if (e.getSource() == this.bCompiereHome) {
            this.setPath(this.fCompiereHome);
        } else if (e.getSource() == this.bDeployDir) {
            this.setPath(this.fDeployDir);
        } else if (e.getSource() == this.bComponentAdd) {
            this.addComponent();
        } else if (e.getSource() == this.bHelp) {
            new Setup_Help((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else if (e.getSource() == this.bTest) {
            this.startTest(false);
        } else if (e.getSource() == this.bSave) {
            this.startTest(true);
        }
        this.showComponentCount();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.showComponentCount();
    }

    private void showComponentCount() {
        int total = this.componentListModel.getSize();
        int selected = 0;
        for (int i = 0; i < total; ++i) {
            if (!this.componentList.isSelectedIndex(i)) continue;
            ++selected;
        }
        StringBuffer sb = new StringBuffer("(").append(selected).append("/").append(total).append(")");
        this.noComponents.setText(sb.toString());
    }

    private void setPath(CTextField field) {
        JFileChooser fc = new JFileChooser(field.getText());
        fc.setDialogType(0);
        fc.setFileSelectionMode(1);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle(field.getToolTipText());
        if (fc.showOpenDialog((Component)((Object)this)) == 0) {
            String dirName = fc.getSelectedFile().getAbsolutePath();
            field.setText(dirName);
        }
    }

    private void addComponent() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogType(0);
        fc.setFileSelectionMode(2);
        fc.setMultiSelectionEnabled(false);
        fc.setDialogTitle(this.lComponent.getToolTipText());
        fc.setFileFilter(new ComponentFileFilter());
        if (fc.showOpenDialog((Component)((Object)this)) == 0) {
            File selectedFile = fc.getSelectedFile();
            ComponentInfo info = new ComponentInfo(selectedFile);
            this.componentListModel.addElement(info);
        }
    }

    private SwingWorker startTest(final boolean saveIt) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                ConfigurationPanel.this.m_testing = true;
                ConfigurationPanel.this.setCursor(Cursor.getPredefinedCursor(3));
                ConfigurationPanel.this.bTest.setEnabled(false);
                ConfigurationPanel.this.m_success = false;
                ConfigurationPanel.this.m_errorString = null;
                try {
                    ConfigurationPanel.this.test(saveIt);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    ConfigurationPanel.this.m_errorString = ConfigurationPanel.this.m_errorString + "\n" + ex.toString();
                }
                ConfigurationPanel.this.setCursor(Cursor.getDefaultCursor());
                if (ConfigurationPanel.this.m_errorString == null) {
                    ConfigurationPanel.this.m_success = true;
                }
                ConfigurationPanel.this.bTest.setEnabled(true);
                ConfigurationPanel.this.m_testing = false;
                return new Boolean(ConfigurationPanel.this.m_success);
            }

            public void finished() {
                if (ConfigurationPanel.this.m_errorString != null) {
                    log.severe(ConfigurationPanel.this.m_errorString);
                    JOptionPane.showConfirmDialog(ConfigurationPanel.this.m_statusBar.getParent(), ConfigurationPanel.this.m_errorString, Setup.res.getString("ServerError"), -1, 0);
                } else if (saveIt) {
                    ConfigurationPanel.this.save();
                }
            }
        };
        worker.start();
        return worker;
    }

    void test(boolean finalIteration) throws Exception {
        this.bSave.setEnabled(false);
        if (!this.m_data.test(finalIteration)) {
            return;
        }
        this.m_statusBar.setText(Setup.res.getString("Ok"));
        this.bSave.setEnabled(true);
        this.m_errorString = null;
    }

    void signalOK(CCheckBox cb, String resString, boolean pass, boolean critical, String errorMsg) {
        this.m_errorString = Setup.res.getString(resString);
        cb.setSelected(pass);
        if (pass) {
            cb.setToolTipText(null);
        } else {
            cb.setToolTipText(errorMsg);
            this.m_errorString = this.m_errorString + " \n(" + errorMsg + ")";
        }
        if (!pass && critical) {
            cb.setBackground(Color.RED);
        } else {
            cb.setBackground(Color.GREEN);
        }
    }

    void save() {
        if (!this.m_success) {
            return;
        }
        this.bSave.setEnabled(false);
        this.bTest.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!this.m_data.save()) {
            return;
        }
        this.firePropertyChange("switchCards", "configuration", "progress");
    }
}

