/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import com.edb.Driver;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.border.Border;
import oracle.jdbc.OracleDriver;
import org.compiere.apps.SwingWorker;
import org.compiere.install.CompiereAntMain;
import org.compiere.install.DatabaseCreate;
import org.compiere.install.Setup;
import org.compiere.swing.CButton;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextArea;
import org.compiere.swing.PublishInterface;
import org.compiere.util.CLogger;
import org.compiere.util.ZipUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProgressPanel
extends CPanel
implements ActionListener,
PublishInterface {
    static final boolean SKIP_SERVERINSTALL = false;
    private Setup m_setup = null;
    private Properties m_properties = null;
    private boolean m_canMigrate = false;
    boolean m_success = false;
    private static final int WHAT_SERVERINSTALL = 0;
    private static final int WHAT_IMPORT = 1;
    private static final int WHAT_MIGRATE = 2;
    private int m_what = -1;
    private String m_serverInstallTitle;
    private String m_importTitle;
    private String m_migrateTitle;
    private String m_start;
    private String m_done;
    private String m_select;
    private int m_totalSteps = 0;
    private int m_completedSteps = 0;
    static CLogger log = CLogger.getCLogger(ProgressPanel.class);
    private CPanel serverInstallPanel = new CPanel((LayoutManager)new BorderLayout());
    private CTextArea serverInstallText = new CTextArea();
    private CButton serverInstallButton = new CButton();
    private JProgressBar serverInstallProgress = new JProgressBar(0);
    private CPanel importPanel = new CPanel((LayoutManager)new BorderLayout());
    private CTextArea importText = new CTextArea();
    private CButton importButton = new CButton();
    private JProgressBar importProgress = new JProgressBar(0);
    private CPanel migratePanel = new CPanel((LayoutManager)new BorderLayout());
    private CTextArea migrateText = new CTextArea();
    private CButton migrateButton = new CButton();
    private JProgressBar migrateProgress = new JProgressBar(0);
    List<String> m_gzipList = null;
    static final String RETURN_CODE = "CompiereRetCode=";
    static final int RETURN_CODE_LENGTH = "CompiereRetCode=".length();

    public ProgressPanel() {
        super((LayoutManager)new BorderLayout());
    }

    protected void init(Setup setup, Properties properties) {
        this.m_setup = setup;
        this.m_properties = properties;
        this.m_canMigrate = "Y".equals(this.m_properties.getProperty("COMPIERE_DB_USER_EXISTS", "N"));
        this.initCar();
        this.staticInit();
    }

    private void initCar() {
        String compiereHome = this.m_properties.getProperty("COMPIERE_HOME");
        String dataDir = compiereHome + File.separator + "data";
        this.removeFiles(dataDir, ".gzip");
        String extDir = compiereHome + File.separator + "lib" + File.separator + "ext";
        this.removeFiles(extDir, null);
        String deployDir = compiereHome + File.separator + "lib" + File.separator + "deploy";
        this.removeFiles(deployDir, null);
        String carList = this.m_properties.getProperty("COMPIERE_COMPONENTS");
        StringTokenizer st = new StringTokenizer(carList, ";");
        String carName = null;
        String gzipName = null;
        String fileName = null;
        this.m_gzipList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            carName = st.nextToken();
            gzipName = this.unpackCar(carName);
            if (gzipName == null) continue;
            fileName = gzipName.substring(gzipName.lastIndexOf(File.separator) + 1);
            if (fileName.equals("cdata.gzip")) {
                this.m_gzipList.add(0, gzipName);
                continue;
            }
            if (!fileName.startsWith("ccomponent_")) continue;
            this.m_gzipList.add(gzipName);
        }
    }

    private void removeFiles(String path, String suffix) {
        File[] files;
        File dir = new File(path);
        if (!dir.exists() && !dir.mkdir()) {
            throw new RuntimeException("Unable to create dir: " + path);
        }
        for (File file : files = dir.listFiles()) {
            if (suffix != null && !file.getName().endsWith(suffix) || file.delete()) continue;
            log.warning("Unable to remove file: " + file.getAbsolutePath());
        }
    }

    private void writeToFile(InputStream in, String path) {
        File file = null;
        FileOutputStream fOut = null;
        FilterOutputStream bOut = null;
        BufferedInputStream bIn = null;
        try {
            file = new File(path);
            if (file.exists()) {
                log.info("Overwriting: " + path);
                file.delete();
            }
            fOut = new FileOutputStream(file);
            bOut = new BufferedOutputStream(fOut);
            bIn = new BufferedInputStream(in);
            while (bIn.available() > 0) {
                ((BufferedOutputStream)bOut).write(bIn.read());
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to write to  " + path);
        }
        finally {
            try {
                if (bOut != null) {
                    bOut.close();
                }
                if (bIn != null) {
                    bIn.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String unpackCar(String carFile) {
        if (carFile == null || carFile.length() <= 0) {
            throw new RuntimeException("Invalid CAR file name: " + carFile);
        }
        File f = new File(carFile);
        if (!f.exists()) {
            throw new RuntimeException("CAR file name not exists: " + carFile);
        }
        ZipUtil zipUtil = null;
        ZipEntry entry = null;
        String fileName = null;
        String gzipName = null;
        String filePath = null;
        InputStream in = null;
        zipUtil = new ZipUtil(carFile);
        String compiereHome = this.m_properties.getProperty("COMPIERE_HOME");
        Enumeration e = zipUtil.entries();
        try {
            while (e.hasMoreElements()) {
                entry = (ZipEntry)e.nextElement();
                fileName = entry.getName();
                if (fileName.equals("cdata.gzip") || fileName.startsWith("ccomponent_")) {
                    filePath = gzipName = compiereHome + File.separator + "data" + File.separator + fileName;
                } else if (fileName.endsWith(".jar") || fileName.endsWith(".zip")) {
                    filePath = compiereHome + File.separator + "lib" + File.separator + "ext" + File.separator + fileName;
                } else if (fileName.endsWith(".war") || fileName.endsWith(".ear")) {
                    filePath = compiereHome + File.separator + "lib" + File.separator + "deploy" + File.separator + fileName;
                } else {
                    if (fileName.equals("CAR_PROPERTIES") || fileName.equals("EntityType_VO")) continue;
                    log.warning("Invalid CAR entry: " + fileName);
                    continue;
                }
                in = zipUtil.getInputStream(entry);
                this.writeToFile(in, filePath);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            String string = null;
            return string;
        }
        finally {
            zipUtil.close();
        }
        return gzipName;
    }

    private void staticInit() {
        Dimension textSize = new Dimension(300, 200);
        this.initPublish();
        this.m_start = Setup.res.getString("Start");
        this.m_done = Setup.res.getString("Done");
        this.m_select = Setup.res.getString("SelectOption");
        this.m_setup.statusBar.setText(this.m_select);
        this.m_serverInstallTitle = Setup.res.getString("ServerInstall");
        this.serverInstallPanel.setBorder((Border)BorderFactory.createTitledBorder(this.m_serverInstallTitle));
        this.serverInstallButton.setText(this.m_start + " " + this.m_serverInstallTitle);
        this.serverInstallButton.addActionListener((ActionListener)this);
        this.serverInstallPanel.add((Component)this.serverInstallButton, (Object)"North");
        this.serverInstallText.setPreferredSize(textSize);
        this.serverInstallText.setReadWrite(false);
        this.serverInstallPanel.add((Component)this.serverInstallText, (Object)"Center");
        this.serverInstallPanel.add((Component)this.serverInstallProgress, (Object)"South");
        this.add((Component)this.serverInstallPanel, "North");
        this.m_importTitle = Setup.res.getString("CreateNewDatabase");
        if (this.m_canMigrate) {
            this.m_importTitle = Setup.res.getString("DropOldCreateNewDatabase");
        }
        this.importPanel.setBorder((Border)BorderFactory.createTitledBorder(this.m_importTitle));
        this.importButton.setText(this.m_start + " " + this.m_importTitle);
        this.importButton.addActionListener((ActionListener)this);
        this.importButton.setEnabled(false);
        this.importPanel.add((Component)this.importButton, (Object)"North");
        this.importText.setText(this.m_importTitle);
        this.importText.setPreferredSize(textSize);
        this.importText.setReadWrite(false);
        this.importPanel.add((Component)this.importText, (Object)"Center");
        this.importPanel.add((Component)this.importProgress, (Object)"South");
        CPanel center = new CPanel((LayoutManager)new BorderLayout(0, 0));
        if (this.m_canMigrate) {
            center.add((Component)this.importPanel, (Object)"Center");
            this.add((Component)center, "Center");
        } else {
            this.add((Component)this.importPanel, "Center");
        }
        if (this.m_canMigrate) {
            this.m_migrateTitle = Setup.res.getString("MigrateExistingDatabase");
            this.migratePanel.setBorder((Border)BorderFactory.createTitledBorder(this.m_migrateTitle));
            this.migrateButton.setText(this.m_start + " " + this.m_migrateTitle);
            this.migrateButton.addActionListener((ActionListener)this);
            this.migratePanel.add((Component)this.migrateButton, (Object)"North");
            this.migrateText.setText(this.m_migrateTitle);
            this.migrateText.setPreferredSize(textSize);
            this.migrateText.setReadWrite(false);
            this.migratePanel.add((Component)this.migrateText, (Object)"Center");
            this.migratePanel.add((Component)this.migrateProgress, (Object)"South");
            center.add((Component)this.migratePanel, (Object)"East");
        }
        this.migrateButton.setEnabled(false);
        this.serverInstallButton.setDefaultCapable(true);
        this.m_setup.getRootPane().setDefaultButton((JButton)this.serverInstallButton);
        this.serverInstallButton.requestFocus();
    }

    public Properties getProperties() {
        return this.m_properties;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.m_setup.menuFileExit.isEnabled()) {
            return;
        }
        Object source = e.getSource();
        if (source == this.serverInstallButton) {
            this.cmd(0);
        } else if (source == this.importButton) {
            this.cmd(1);
        } else if (source == this.migrateButton) {
            this.cmd(2);
        }
    }

    private void cmd(int what) {
        if (what == 1 && this.m_canMigrate && JOptionPane.showConfirmDialog((Component)((Object)this), Setup.res.getString("DropExistingDatabase"), this.m_importTitle, 0) != 0) {
            return;
        }
        this.enableUI(false);
        if (what == 0) {
            this.m_what = 0;
            log.info(this.m_serverInstallTitle);
            this.m_setup.statusBar.setText(this.m_serverInstallTitle);
            this.serverInstallProgress.setIndeterminate(true);
            this.startWork(0);
        } else if (what == 1) {
            this.m_what = 1;
            log.info(this.m_importTitle);
            this.migratePanel.setVisible(false);
            this.invalidate();
            this.m_setup.statusBar.setText(this.m_importTitle);
            this.importProgress.setIndeterminate(true);
            this.startWork(1);
        } else if (what == 2 && this.m_canMigrate) {
            this.m_what = 2;
            log.info(this.m_migrateTitle);
            this.importPanel.setVisible(false);
            this.invalidate();
            this.m_setup.statusBar.setText(this.m_migrateTitle);
            this.migrateProgress.setIndeterminate(true);
            this.startWork(2);
        } else {
            log.severe("Unknown What=" + what);
        }
    }

    void enableUI(boolean enable) {
        if (this.m_success) {
            log.info("" + enable);
        } else if (enable) {
            JOptionPane.showMessageDialog((Component)((Object)this), Setup.res.getString("ErrorProcess"), Setup.res.getString("CompiereServerSetup"), 0);
        }
        this.m_setup.menuFileExit.setEnabled(enable);
        if (enable) {
            this.setCursor(Cursor.getDefaultCursor());
            if (this.m_what == 0 && this.m_success) {
                this.importButton.setEnabled(true);
                if (this.m_canMigrate) {
                    this.migrateButton.setEnabled(true);
                    this.migrateButton.setDefaultCapable(true);
                    this.m_setup.getRootPane().setDefaultButton((JButton)this.migrateButton);
                    this.migrateButton.requestFocus();
                } else {
                    this.importButton.setDefaultCapable(true);
                    this.m_setup.getRootPane().setDefaultButton((JButton)this.importButton);
                    this.importButton.requestFocus();
                }
            }
            this.serverInstallProgress.setIndeterminate(false);
            this.importProgress.setIndeterminate(false);
            this.migrateProgress.setIndeterminate(false);
        } else {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.serverInstallButton.setEnabled(false);
            this.importButton.setEnabled(false);
            this.migrateButton.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cmd_serverInstall() {
        int retCode;
        block19: {
            final String compiereHome = this.m_properties.getProperty("COMPIERE_HOME");
            System.setProperty("COMPIERE_HOME", compiereHome);
            log.info(compiereHome);
            this.publish(Level.INFO, "** " + this.m_start, 0, 0);
            retCode = -1;
            PrintStream stdOut = System.out;
            PrintStream stdErr = System.err;
            PipedInputStream pIn = null;
            PipedOutputStream pOut = null;
            this.m_totalSteps = 24;
            this.m_completedSteps = 0;
            try {
                pIn = new PipedInputStream();
                pOut = new PipedOutputStream(pIn);
                final PrintStream ps = new PrintStream(pOut);
                Thread antThread = new Thread(){

                    public void run() {
                        try {
                            System.setOut(ps);
                            System.setErr(ps);
                            log.info("Starting Ant ... " + compiereHome);
                            System.setProperty("ant.home", compiereHome);
                            String[] args = new String[]{"-buildfile", compiereHome + File.separator + "build.xml", "setup"};
                            CompiereAntMain compiereMain = new CompiereAntMain();
                            int rc = compiereMain.startAnt(args);
                            System.out.println(ProgressPanel.RETURN_CODE + rc);
                            ps.close();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                };
                antThread.start();
                byte[] buffer = new byte[10000];
                while (true) {
                    try {
                        while (true) {
                            int amount;
                            if ((amount = pIn.read(buffer)) < 0) {
                                break block19;
                            }
                            String msg = new String(buffer, 0, amount);
                            if (msg.indexOf(RETURN_CODE) != -1) {
                                int index = msg.indexOf(RETURN_CODE);
                                retCode = Integer.parseInt(msg.substring(index + RETURN_CODE_LENGTH, index + RETURN_CODE_LENGTH + 1));
                                msg = msg.substring(0, index);
                                this.publishInstall(msg);
                                break block19;
                            }
                            this.publishInstall(msg);
                        }
                    }
                    catch (IOException ex) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.publish(Level.SEVERE, e.toString(), this.m_totalSteps, this.m_totalSteps);
            }
            finally {
                System.setOut(stdOut);
                System.setErr(stdErr);
                try {
                    if (pOut != null) {
                        pOut.close();
                    }
                    if (pIn != null) {
                        pIn.close();
                    }
                }
                catch (Exception ex) {}
            }
        }
        this.publish(Level.INFO, "** " + this.m_done, this.m_totalSteps, this.m_totalSteps);
        this.m_setup.statusBar.setText(this.m_select);
        return retCode == 0;
    }

    boolean cmd_import() {
        boolean success;
        block14: {
            success = false;
            this.m_totalSteps = 10;
            this.m_completedSteps = 0;
            String dbType = this.m_properties.getProperty("COMPIERE_DB_TYPE");
            String systemPwd = this.m_properties.getProperty("COMPIERE_DB_SYSTEM");
            String dbName = this.m_properties.getProperty("COMPIERE_DB_NAME");
            String dbUid = this.m_properties.getProperty("COMPIERE_DB_USER");
            String dbPwd = this.m_properties.getProperty("COMPIERE_DB_PASSWORD");
            String dbHost = this.m_properties.getProperty("COMPIERE_DB_SERVER");
            String dbPort = this.m_properties.getProperty("COMPIERE_DB_PORT");
            this.publish(Level.INFO, "** " + this.m_start + "(" + dbHost + " " + dbUid + ")", 0, 0);
            Connection con = null;
            try {
                OracleDriver s_driver;
                String url = null;
                if ("oracle".equals(dbType) || "oracleXE".equals(dbType)) {
                    s_driver = new OracleDriver();
                    DriverManager.registerDriver((java.sql.Driver)s_driver);
                    url = "jdbc:oracle:thin:@//" + dbHost + ":" + dbPort + "/" + dbName;
                    con = DriverManager.getConnection(url, "System", systemPwd);
                } else if ("postgreSQL".equals(dbType)) {
                    s_driver = new Driver();
                    DriverManager.registerDriver((java.sql.Driver)s_driver);
                    url = "jdbc:edb://" + dbHost + ":" + dbPort + "/mgmtsvr";
                    con = DriverManager.getConnection(url, "enterprisedb", systemPwd);
                } else if ("sqlServer".equals(dbType)) {
                    s_driver = new SQLServerDriver();
                    DriverManager.registerDriver((java.sql.Driver)s_driver);
                    url = "jdbc:sqlserver://" + dbHost + ":" + dbPort;
                    con = DriverManager.getConnection(url, "sa", systemPwd);
                } else {
                    throw new IllegalArgumentException("Database not supported: " + dbType);
                }
                log.info(url);
                DatabaseCreate dbc = new DatabaseCreate(con, dbType, dbName, dbUid, dbPwd, this, this.m_canMigrate);
                dbc.run();
                success = dbc.isSuccess();
                con.close();
            }
            catch (Exception e) {
                this.publish(Level.SEVERE, e.toString(), this.m_totalSteps, this.m_totalSteps);
                success = false;
                if (con == null) break block14;
                try {
                    con.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (success) {
            log.info("");
            String compiereHome = this.m_properties.getProperty("COMPIERE_HOME");
            String srcDir = compiereHome + File.separator + "data";
            Map<String, String> map = this.getInfo();
            Object info = null;
            try {
                Class<?> c = Class.forName("com.compiere.client.StartSupport");
                Object instance = c.newInstance();
                Method m = c.getMethod("startImport", String.class, ProgressPanel.class, List.class, Map.class);
                info = m.invoke(instance, srcDir, this, this.m_gzipList, map);
                if (info.toString().equals("false")) {
                    return false;
                }
            }
            catch (Exception e) {
                this.publish(Level.SEVERE, "** " + e.getMessage(), this.m_totalSteps, this.m_totalSteps);
                return false;
            }
        }
        this.publish(Level.INFO, "** " + this.m_done, this.m_totalSteps, this.m_totalSteps);
        this.m_setup.statusBar.setText(this.m_done);
        return true;
    }

    boolean cmd_migrate() {
        this.publish(Level.INFO, "** " + this.m_start + " " + this.m_migrateTitle + " **", 0, 0);
        this.m_totalSteps = 4;
        this.m_completedSteps = 0;
        try {
            Class<?> c = Class.forName("com.compiere.client.StartSupport");
            Object instance = c.newInstance();
            Method m = c.getMethod("startMigrate", ProgressPanel.class, List.class);
            m.invoke(instance, this, this.m_gzipList);
        }
        catch (Exception e) {
            this.publish(Level.SEVERE, "** " + e.getMessage(), this.m_totalSteps, this.m_totalSteps);
            log.log(Level.SEVERE, "migration exception. e.getMessage = " + e.getMessage(), (Throwable)e);
            return false;
        }
        this.publish(Level.INFO, "** " + this.m_done, 0, 0);
        this.m_setup.statusBar.setText(this.m_done);
        return true;
    }

    public void initPublish() {
        this.serverInstallText.initPublish();
        this.importText.initPublish();
        this.migrateText.initPublish();
    }

    private void publishInstall(String info) {
        if (info == null || info.trim().length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(info, "\r\n", false);
        while (st.hasMoreTokens()) {
            boolean mainOutput;
            String s = st.nextToken();
            if (s == null || s.length() == 0 || s.trim().length() == 0) continue;
            Level level = Level.INFO;
            boolean bl = mainOutput = !Character.isWhitespace(s.charAt(0));
            if (!mainOutput) {
                level = Level.CONFIG;
            }
            if (this.m_totalSteps != 0 && mainOutput) {
                ++this.m_completedSteps;
            }
            this.publish(level, s, this.m_completedSteps, this.m_totalSteps);
        }
    }

    public void publish(Level level, String info, int step, int totalSteps) {
        JProgressBar progress;
        if (info == null || info.trim().length() == 0) {
            return;
        }
        CTextArea text = null;
        if (this.m_what == 0) {
            text = this.serverInstallText;
            progress = this.serverInstallProgress;
        } else if (this.m_what == 1) {
            text = this.importText;
            progress = this.importProgress;
        } else if (this.m_what == 2) {
            text = this.migrateText;
            progress = this.migrateProgress;
        } else {
            log.warning("What=" + this.m_what + " - " + info);
            return;
        }
        log.log(level, info);
        if (!(Level.FINE.equals(level) || Level.FINER.equals(level) || Level.FINEST.equals(level))) {
            text.publish(level, info, step, totalSteps);
        }
        if (totalSteps == 0) {
            progress.setIndeterminate(true);
        } else {
            progress.setIndeterminate(false);
            if (progress.getMaximum() != totalSteps) {
                progress.setMaximum(totalSteps);
            }
            progress.setValue(step);
        }
    }

    private Map<String, String> getInfo() {
        Properties prop = this.getProperties();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("COMPIERE_DB_TYPE", prop.getProperty("COMPIERE_DB_TYPE"));
        map.put("COMPIERE_MAIN_VERSION", prop.getProperty("COMPIERE_MAIN_VERSION"));
        map.put("COMPIERE_DATE_VERSION", prop.getProperty("COMPIERE_DATE_VERSION"));
        return map;
    }

    private SwingWorker startWork(final int what) {
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                ProgressPanel.this.m_success = false;
                try {
                    if (what == 0) {
                        ProgressPanel.this.m_success = ProgressPanel.this.cmd_serverInstall();
                    } else if (what == 1) {
                        ProgressPanel.this.m_success = ProgressPanel.this.cmd_import();
                    } else if (what == 2) {
                        ProgressPanel.this.m_success = ProgressPanel.this.cmd_migrate();
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "", (Throwable)e);
                    ProgressPanel.this.m_success = false;
                }
                return new Boolean(ProgressPanel.this.m_success);
            }

            public void finished() {
                log.info("Worker success=" + ProgressPanel.this.m_success);
                ProgressPanel.this.enableUI(true);
            }
        };
        worker.start();
        return worker;
    }
}

