/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.compiere.Compiere;
import org.compiere.apps.AEnv;
import org.compiere.install.ConfigurationPanel;
import org.compiere.install.ProgressPanel;
import org.compiere.install.Setup_Help;
import org.compiere.plaf.CompierePLAF;
import org.compiere.swing.CFrame;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogErrorBuffer;
import org.compiere.util.CLogFile;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;

public class Setup
extends CFrame
implements ActionListener,
PropertyChangeListener {
    private static CLogger log = CLogger.getCLogger(Setup.class);
    static ResourceBundle res = ResourceBundle.getBundle("org.compiere.translate.SetupRes");
    private JMenuBar menuBar = new JMenuBar();
    private JMenu menuFile = new JMenu();
    CMenuItem menuFileExit = new CMenuItem();
    private JMenu menuHelp = new JMenu();
    private CMenuItem menuHelpInfo = new CMenuItem();
    JLabel statusBar = new JLabel();
    protected Properties p_properties = new Properties();
    private ConfigurationPanel configurationPanel = new ConfigurationPanel(this.statusBar, this.p_properties);
    private ProgressPanel progressPanel = new ProgressPanel();
    private CardLayout cardLayout = new CardLayout();
    private CPanel cards = new CPanel((LayoutManager)this.cardLayout);
    protected static final String SWITCHCARDS = "switchCards";
    protected static final String CONFIGURATION = "configuration";
    protected static final String PROGRESS = "progress";

    public Setup() {
        log.info(Compiere.getSummaryAscii());
        this.enableEvents(64L);
        this.setDefaultCloseOperation(3);
        CLogErrorBuffer eb = CLogErrorBuffer.get((boolean)true);
        if (eb != null && eb.isIssueError()) {
            eb.setIssueError(false);
        }
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        AEnv.showCenterScreen((Window)((Object)this));
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.configurationPanel.dynInit();
            AEnv.positionCenterScreen((Window)((Object)this));
            this.setCursor(Cursor.getDefaultCursor());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void jbInit() throws Exception {
        this.setIconImage(Compiere.getImage16());
        this.setTitle(res.getString("CompiereServerSetup"));
        JPanel contentPane = (JPanel)this.getContentPane();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(5);
        borderLayout.setVgap(5);
        contentPane.setLayout(borderLayout);
        this.configurationPanel.addPropertyChangeListener(SWITCHCARDS, this);
        this.cards.add((Component)((Object)this.configurationPanel), (Object)CONFIGURATION);
        this.cards.add((Component)((Object)this.progressPanel), (Object)PROGRESS);
        contentPane.add((Component)this.cards, "Center");
        this.cardLayout.show((Container)this.cards, CONFIGURATION);
        this.statusBar.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBar.setText(" ");
        contentPane.add((Component)this.statusBar, "South");
        this.menuFile.setText(res.getString("File"));
        this.menuFileExit.setText(res.getString("Exit"));
        this.menuFileExit.addActionListener((ActionListener)this);
        this.menuHelp.setText(res.getString("Help"));
        this.menuHelpInfo.setText(res.getString("Help"));
        this.menuHelpInfo.addActionListener((ActionListener)this);
        this.menuFile.add((JMenuItem)this.menuFileExit);
        this.menuHelp.add((JMenuItem)this.menuHelpInfo);
        this.menuBar.add(this.menuFile);
        this.menuBar.add(this.menuHelp);
        this.setJMenuBar(this.menuBar);
    }

    public void dispose() {
        super.dispose();
        log.info("");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.menuFileExit) {
            System.exit(0);
        } else if (e.getSource() == this.menuHelpInfo) {
            new Setup_Help((Frame)((Object)this));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        log.config(evt.getOldValue() + "->" + evt.getNewValue());
        this.progressPanel.init(this, this.p_properties);
        String newCard = PROGRESS;
        this.cardLayout.show((Container)this.cards, newCard);
    }

    public static void main(String[] args) {
        CLogMgt.initialize((boolean)true);
        CLogFile fileHandler = new CLogFile(System.getProperty("user.dir"), false, false);
        CLogMgt.addHandler((Handler)fileHandler);
        if (args.length > 0) {
            CLogMgt.setLevel((String)args[0]);
        } else {
            CLogMgt.setLevel((Level)Level.INFO);
        }
        if (fileHandler.getLevel().intValue() > Level.FINE.intValue()) {
            fileHandler.setLevel(Level.FINE);
        }
        CompierePLAF.setPLAF(null);
        new Setup();
    }
}

