/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.services;

import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.services.Event;
import org.apache.commons.services.EventModule;
import org.apache.commons.services.EventRegistration;

public class EventFactory
extends BaseKeyedPoolableObjectFactory {
    protected EventModule eventModule = null;

    public EventModule getEventModule() {
        return this.eventModule;
    }

    public void setEventModule(EventModule eventModule) {
        this.eventModule = eventModule;
    }

    public Object makeObject(Object key) {
        EventRegistration eventRegistration = this.eventModule.getEventRegistration((String)key);
        Event event = null;
        try {
            Class<?> clazz = Class.forName(eventRegistration.getType());
            event = (Event)clazz.newInstance();
        }
        catch (Exception e) {
            this.eventModule.getServiceManager().getLog().error((Object)("Can not create event of type - '" + eventRegistration.getType() + "'"), (Throwable)e);
            event = new Event();
        }
        event.setParentModule(this.eventModule);
        event.setEventRegistration(eventRegistration);
        return event;
    }

    public void destroyObject(Object key, Object obj) {
        ((Event)obj).destroy();
    }
}

