/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.connectionmanager;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.RemoveException;
import javax.management.MBeanServer;
import javax.resource.ResourceException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.EntityPersistenceManager;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.logging.Logger;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.ResourceRefMetaData;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.resource.connectionmanager.CachedConnectionManager;
import org.jboss.resource.connectionmanager.CachedConnectionManagerMBean;

public class CachedConnectionInterceptor
extends AbstractInterceptor
implements EntityPersistenceManager {
    private final CachedConnectionManager ccm;
    private final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private Container container;
    private EntityPersistenceManager pm;
    private Set unsharableResources = new HashSet();

    public CachedConnectionInterceptor() throws Exception {
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            this.ccm = (CachedConnectionManager)server.getAttribute(CachedConnectionManagerMBean.OBJECT_NAME, "Instance");
        }
        catch (Exception e) {
            JMXExceptionDecoder.rethrow((Exception)e);
            throw e;
        }
    }

    public void start() throws Exception {
        this.log.debug((Object)"start called in CachedConnectionInterceptor");
        if (this.container == null) {
            this.log.info((Object)"container is null, can't steal persistence manager");
            return;
        }
        if (this.container instanceof EntityContainer) {
            EntityContainer ec = (EntityContainer)this.container;
            if (ec.getPersistenceManager() == null) {
                this.log.info((Object)"no persistence manager in container!");
                return;
            }
            if (ec.getPersistenceManager() == this) {
                this.log.info((Object)" persistence manager in container already set!");
                return;
            }
            this.pm = ec.getPersistenceManager();
            ec.setPersistenceManager((EntityPersistenceManager)this);
        }
        BeanMetaData bmd = this.container.getBeanMetaData();
        ApplicationMetaData appMetaData = bmd.getApplicationMetaData();
        Iterator iter = bmd.getResourceReferences();
        while (iter.hasNext()) {
            ResourceRefMetaData resRefMetaData = (ResourceRefMetaData)iter.next();
            String jndiName = resRefMetaData.getJndiName();
            if (jndiName == null) {
                jndiName = appMetaData.getResourceByName(resRefMetaData.getResourceName());
            }
            if (jndiName == null || resRefMetaData.isShareable()) continue;
            int i = jndiName.indexOf(58);
            if (jndiName.charAt(i + 1) == '/') {
                ++i;
            }
            this.unsharableResources.add(jndiName.substring(i + 1));
        }
    }

    public void stop() {
        if (this.container != null && this.pm != null && ((EntityContainer)this.container).getPersistenceManager() == this) {
            ((EntityContainer)this.container).setPersistenceManager(this.pm);
            this.pm = null;
        }
        this.unsharableResources.clear();
    }

    public void destroy() {
    }

    public void create() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Invocation mi) throws Exception {
        Object key = ((EnterpriseContext)mi.getEnterpriseContext()).getInstance();
        this.ccm.pushMetaAwareObject(key, this.unsharableResources);
        try {
            Object object = this.getNext().invoke(mi);
            return object;
        }
        finally {
            this.ccm.popMetaAwareObject(this.unsharableResources);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeHome(Invocation mi) throws Exception {
        EnterpriseContext ctx = (EnterpriseContext)mi.getEnterpriseContext();
        if (ctx == null) {
            return this.getNext().invokeHome(mi);
        }
        Object key = ctx.getInstance();
        this.ccm.pushMetaAwareObject(key, this.unsharableResources);
        try {
            Object object = this.getNext().invokeHome(mi);
            return object;
        }
        finally {
            this.ccm.popMetaAwareObject(this.unsharableResources);
        }
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public Container getContainer() {
        return this.container;
    }

    public Object createBeanClassInstance() throws Exception {
        return this.pm.createBeanClassInstance();
    }

    public void createEntity(Method m, Object[] args, EntityEnterpriseContext instance) throws Exception {
        this.pm.createEntity(m, args, instance);
    }

    public void postCreateEntity(Method m, Object[] args, EntityEnterpriseContext instance) throws Exception {
        this.pm.postCreateEntity(m, args, instance);
    }

    public Object findEntity(Method finderMethod, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory) throws Exception {
        return this.pm.findEntity(finderMethod, args, instance, factory);
    }

    public Collection findEntities(Method finderMethod, Object[] args, EntityEnterpriseContext instance, GenericEntityObjectFactory factory) throws Exception {
        return this.pm.findEntities(finderMethod, args, instance, factory);
    }

    public void activateEntity(EntityEnterpriseContext instance) throws RemoteException {
        this.pm.activateEntity(instance);
    }

    public void loadEntity(EntityEnterpriseContext instance) throws RemoteException {
        this.pm.loadEntity(instance);
    }

    public boolean isStoreRequired(EntityEnterpriseContext instance) throws Exception {
        return this.pm.isStoreRequired(instance);
    }

    public boolean isModified(EntityEnterpriseContext ctx) throws Exception {
        return this.pm.isModified(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeEntity(EntityEnterpriseContext ctx) throws RemoteException {
        Object key = ctx.getInstance();
        try {
            this.ccm.pushMetaAwareObject(key, this.unsharableResources);
            try {
                this.pm.storeEntity(ctx);
            }
            finally {
                this.ccm.popMetaAwareObject(this.unsharableResources);
            }
        }
        catch (ResourceException e) {
            throw new RemoteException("Could not store!: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeEjbStore(EntityEnterpriseContext ctx) throws RemoteException {
        Object key = ctx.getInstance();
        try {
            this.ccm.pushMetaAwareObject(key, this.unsharableResources);
            try {
                this.pm.invokeEjbStore(ctx);
            }
            finally {
                this.ccm.popMetaAwareObject(this.unsharableResources);
            }
        }
        catch (ResourceException e) {
            throw new RemoteException("Could not store!: ", e);
        }
    }

    public void passivateEntity(EntityEnterpriseContext instance) throws RemoteException {
        this.pm.passivateEntity(instance);
    }

    public void removeEntity(EntityEnterpriseContext instance) throws RemoteException, RemoveException {
        this.pm.removeEntity(instance);
    }
}

