/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.chartData.processors;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;

public class TextProcessor {
    private float[] labelWidths;
    private float[] labelHeights;
    private float widestLabel = Float.MIN_VALUE;
    private float tallestLabel = Float.MIN_VALUE;
    private float totalLabelWidths = 0.0f;
    private float fontDescent;
    private int counter = 0;

    public TextProcessor(int n) {
        this.labelWidths = new float[n];
        this.labelHeights = new float[n];
    }

    public void processLabel(String string, Font font, FontRenderContext fontRenderContext) {
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        this.labelWidths[this.counter] = textLayout.getAdvance();
        this.widestLabel = Math.max(this.labelWidths[this.counter], this.widestLabel);
        this.totalLabelWidths += this.labelWidths[this.counter];
        this.labelHeights[this.counter] = textLayout.getAscent() + textLayout.getDescent();
        this.tallestLabel = Math.max(this.labelHeights[this.counter], this.tallestLabel);
        this.fontDescent = textLayout.getDescent();
        ++this.counter;
    }

    public float getWidestLabel() {
        return this.widestLabel;
    }

    public float getTallestLabel() {
        return this.tallestLabel;
    }

    public float getLabelWidth(int n) {
        return this.labelWidths[n];
    }

    public float getLabelHeight(int n) {
        return this.labelHeights[n];
    }

    public float getTotalLabelWidths() {
        return this.totalLabelWidths;
    }

    public float getFontDescent() {
        return this.fontDescent;
    }
}

