/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.io.FileWriter;

public final class HTMLGenerator {
    private String fileName;
    private StringBuffer stringBuffer;

    public HTMLGenerator(String string) {
        this.fileName = string;
        this.stringBuffer = new StringBuffer(1024);
        this.stringBuffer.append("<HTML><BODY>");
    }

    public void addField(String string, Object object) {
        if (object instanceof boolean[]) {
            this.addTableRow(string, HTMLGenerator.arrayToString((boolean[])object));
        } else if (object instanceof int[]) {
            this.addTableRow(string, HTMLGenerator.arrayToString((int[])object));
        } else if (object instanceof double[]) {
            this.addTableRow(string, HTMLGenerator.arrayToString((double[])object));
        } else if (object instanceof float[]) {
            this.addTableRow(string, HTMLGenerator.arrayToString((float[])object));
        } else if (object instanceof Object[]) {
            this.addTableRow(string, HTMLGenerator.arrayToString((Object[])object));
        } else {
            this.addTableRow(string, object);
        }
    }

    public void addString(Object object) {
        this.stringBuffer.append(object != null ? object.toString() : "NULL");
    }

    public void addString(String string, Object object) {
        this.addString("<B>");
        this.stringBuffer.append(string);
        this.addString("</B>");
        this.stringBuffer.append(object.toString());
    }

    public static String arrayToString(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        int n = 0;
        while (n < objectArray.length) {
            stringBuffer.append(objectArray[n].toString());
            if (n < objectArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String arrayToString(boolean[] blArray) {
        StringBuffer stringBuffer = new StringBuffer(100);
        int n = 0;
        while (n < blArray.length) {
            stringBuffer.append(new Boolean(blArray[n]).toString());
            if (n < blArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String arrayToString(double[] dArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        int n = 0;
        while (n < dArray.length) {
            stringBuffer.append(Double.toString(dArray[n]));
            if (n < dArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String arrayToString(double[][] dArray) {
        StringBuffer stringBuffer = new StringBuffer(400);
        int n = 0;
        while (n < dArray.length) {
            stringBuffer.append(" { ");
            int n2 = 0;
            while (n2 < dArray[0].length) {
                stringBuffer.append(dArray[n][n2]);
                if (n2 < dArray[0].length - 1) {
                    stringBuffer.append(", ");
                }
                ++n2;
            }
            stringBuffer.append(" }<BR> ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String arrayToString(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        int n = 0;
        while (n < fArray.length) {
            stringBuffer.append(Float.toString(fArray[n]));
            if (n < fArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String arrayToString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(200);
        int n = 0;
        while (n < nArray.length) {
            stringBuffer.append(Integer.toString(nArray[n]));
            if (n < nArray.length - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void addImage(String string) {
        this.stringBuffer.append("<IMG SRC=\"" + string + "\">");
    }

    public void addLineBreak() {
        this.stringBuffer.append("<BR>");
    }

    public void saveFile() {
        this.stringBuffer.append("</BODY></HTML>");
        try {
            FileWriter fileWriter = new FileWriter(this.fileName);
            fileWriter.write(this.stringBuffer.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void addTableRow(String string, Object object) {
        this.addString("<TR><TD NOWRAP BGCOLOR=#FFFFFF>");
        this.addString(string);
        this.addString("</TD><TD NOWRAP BGCOLOR=#FFFFFF>");
        this.addString(object);
        this.addString("</TD></TR>");
    }

    public void propertiesTableStart(String string) {
        this.addString("<TABLE BGCOLOR=#000000 BORDER=0 CELLSPACING=1 CELLPADDING=3>");
        this.addString("<TR><TD BGCOLOR=#D0FBCE COLSPAN=2><B>" + string + "</B></TD></TR>");
    }

    public void propertiesTableEnd() {
        this.addString("</TABLE>");
    }

    public void propertiesTableRowStart() {
        this.addString("<TR><TD WIDTH=100% BGCOLOR=#AAAAAA>");
    }

    public void propertiesTableRowEnd() {
        this.addString("</TD></TR>");
    }

    public void chartTableStart(String string, String string2) {
        this.addString("<TABLE BGCOLOR=#000000 BORDER=0 CELLSPACING=1 CELLPADDING=3>");
        this.addString("<TR><TD BGCOLOR=#FDFEC2 COLSPAN=1><B>" + string + "</B></TD></TR>");
        this.addString("<TR><TD WIDTH=100% BGCOLOR=#AAAAAA>");
        this.addImage(string2);
        this.addString("</TD></TR>");
    }

    public void chartTableEnd() {
        this.addString("</TABLE>");
    }

    public void chartTableRowStart() {
        this.addString("<TR><TD WIDTH=100% BGCOLOR=#AAAAAA>");
    }

    public void chartTableRowEnd() {
        this.addString("</TD></TR>");
    }

    public void legendTableStart() {
        this.addString("<TABLE BGCOLOR=#000000 BORDER=0 CELLSPACING=1 CELLPADDING=3>");
        this.addString("<TR><TD BGCOLOR=#FDFEC2 COLSPAN=2><B>Legend</B></TD></TR>");
    }

    public void legendTableEnd() {
        this.addString("</TABLE>");
    }

    public void legendTableRowStart() {
        this.addString("<TR><TD WIDTH=100% COLSPAN=2 BGCOLOR=#777777>");
    }

    public void legendTableRowEnd() {
        this.addString("</TD></TR>");
    }
}

