/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.Descriptor;
import org.apache.commons.betwixt.NodeDescriptor;
import org.apache.commons.betwixt.TextDescriptor;
import org.apache.commons.betwixt.expression.Expression;

public class ElementDescriptor
extends NodeDescriptor {
    private AttributeDescriptor[] attributeDescriptors;
    private ElementDescriptor[] elementDescriptors;
    private Descriptor[] contentDescriptors;
    private List attributeList;
    private List elementList;
    private List contentList;
    private Expression contextExpression;
    private boolean primitiveType;
    private boolean wrapCollectionsInElement = true;
    private Class implementationClass = null;

    public ElementDescriptor() {
    }

    public ElementDescriptor(boolean primitiveType) {
        this.primitiveType = primitiveType;
    }

    public ElementDescriptor(String localName) {
        super(localName);
    }

    public ElementDescriptor(String localName, String qualifiedName, String uri) {
        super(localName, qualifiedName, uri);
    }

    public boolean hasChildren() {
        return this.getElementDescriptors().length > 0;
    }

    public boolean hasAttributes() {
        return this.getAttributeDescriptors().length > 0;
    }

    public boolean hasContent() {
        return this.getContentDescriptors().length > 0;
    }

    public void setWrapCollectionsInElement(boolean wrapCollectionsInElement) {
        this.wrapCollectionsInElement = wrapCollectionsInElement;
    }

    public boolean isWrapCollectionsInElement() {
        return this.wrapCollectionsInElement;
    }

    public void addAttributeDescriptor(AttributeDescriptor descriptor) {
        if (this.attributeList == null) {
            this.attributeList = new ArrayList();
        }
        this.getAttributeList().add(descriptor);
        this.attributeDescriptors = null;
    }

    public AttributeDescriptor[] getAttributeDescriptors() {
        if (this.attributeDescriptors == null) {
            if (this.attributeList == null) {
                this.attributeDescriptors = new AttributeDescriptor[0];
            } else {
                this.attributeDescriptors = new AttributeDescriptor[this.attributeList.size()];
                this.attributeList.toArray(this.attributeDescriptors);
                this.attributeList = null;
            }
        }
        return this.attributeDescriptors;
    }

    public void setAttributeDescriptors(AttributeDescriptor[] attributeDescriptors) {
        this.attributeDescriptors = attributeDescriptors;
        this.attributeList = null;
    }

    public void addElementDescriptor(ElementDescriptor descriptor) {
        if (this.elementList == null) {
            this.elementList = new ArrayList();
        }
        this.getElementList().add(descriptor);
        this.elementDescriptors = null;
        this.addContentDescriptor(descriptor);
    }

    public ElementDescriptor[] getElementDescriptors() {
        if (this.elementDescriptors == null) {
            if (this.elementList == null) {
                this.elementDescriptors = new ElementDescriptor[0];
            } else {
                this.elementDescriptors = new ElementDescriptor[this.elementList.size()];
                this.elementList.toArray(this.elementDescriptors);
                this.elementList = null;
            }
        }
        return this.elementDescriptors;
    }

    public void setElementDescriptors(ElementDescriptor[] elementDescriptors) {
        this.elementDescriptors = elementDescriptors;
        this.elementList = null;
        this.setContentDescriptors(elementDescriptors);
    }

    public void addContentDescriptor(Descriptor descriptor) {
        if (this.contentList == null) {
            this.contentList = new ArrayList();
        }
        this.getContentList().add(descriptor);
        this.contentDescriptors = null;
    }

    public Descriptor[] getContentDescriptors() {
        if (this.contentDescriptors == null) {
            if (this.contentList == null) {
                this.contentDescriptors = new Descriptor[0];
            } else {
                this.contentDescriptors = new Descriptor[this.contentList.size()];
                this.contentList.toArray(this.contentDescriptors);
                this.contentList = null;
            }
        }
        return this.contentDescriptors;
    }

    public TextDescriptor getPrimaryBodyTextDescriptor() {
        Descriptor[] descriptors = this.getContentDescriptors();
        int size = descriptors.length;
        for (int i = 0; i < size; ++i) {
            if (!(descriptors[i] instanceof TextDescriptor)) continue;
            return (TextDescriptor)descriptors[i];
        }
        return null;
    }

    public void setContentDescriptors(Descriptor[] contentDescriptors) {
        this.contentDescriptors = contentDescriptors;
        this.contentList = null;
    }

    public Expression getContextExpression() {
        return this.contextExpression;
    }

    public void setContextExpression(Expression contextExpression) {
        this.contextExpression = contextExpression;
    }

    public boolean isPrimitiveType() {
        return this.primitiveType;
    }

    public void setPrimitiveType(boolean primitiveType) {
        this.primitiveType = primitiveType;
    }

    protected List getAttributeList() {
        if (this.attributeList == null) {
            if (this.attributeDescriptors != null) {
                int size = this.attributeDescriptors.length;
                this.attributeList = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    this.attributeList.add(this.attributeDescriptors[i]);
                }
                this.attributeDescriptors = null;
            } else {
                this.attributeList = new ArrayList();
            }
        }
        return this.attributeList;
    }

    protected List getElementList() {
        if (this.elementList == null) {
            if (this.elementDescriptors != null) {
                int size = this.elementDescriptors.length;
                this.elementList = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    this.elementList.add(this.elementDescriptors[i]);
                }
                this.elementDescriptors = null;
            } else {
                this.elementList = new ArrayList();
            }
        }
        return this.elementList;
    }

    protected List getContentList() {
        if (this.contentList == null) {
            if (this.contentDescriptors != null) {
                int size = this.contentDescriptors.length;
                this.contentList = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    this.contentList.add(this.contentDescriptors[i]);
                }
                this.contentDescriptors = null;
            } else {
                this.contentList = new ArrayList();
            }
        }
        return this.contentList;
    }

    public Class getImplementationClass() {
        return this.implementationClass;
    }

    public void setImplementationClass(Class implementationClass) {
        this.implementationClass = implementationClass;
    }

    public String toString() {
        return "ElementDescriptor[qname=" + this.getQualifiedName() + ",pname=" + this.getPropertyName() + ",class=" + this.getPropertyType() + ",singular=" + this.getSingularPropertyType() + ",updater=" + this.getUpdater() + ",wrap=" + this.isWrapCollectionsInElement() + "]";
    }
}

