/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.digester;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.apache.commons.betwixt.AttributeDescriptor;
import org.apache.commons.betwixt.ElementDescriptor;
import org.apache.commons.betwixt.XMLUtils;
import org.apache.commons.betwixt.digester.RuleSupport;
import org.apache.commons.betwixt.digester.XMLIntrospectorHelper;
import org.apache.commons.betwixt.expression.ConstantExpression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AttributeRule
extends RuleSupport {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$betwixt$digester$AttributeRule == null ? (class$org$apache$commons$betwixt$digester$AttributeRule = AttributeRule.class$("org.apache.commons.betwixt.digester.AttributeRule")) : class$org$apache$commons$betwixt$digester$AttributeRule));
    private ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
    private Class beanClass;
    static /* synthetic */ Class class$org$apache$commons$betwixt$digester$AttributeRule;

    public void begin(Attributes attributes) throws SAXException {
        AttributeDescriptor descriptor = new AttributeDescriptor();
        String name = attributes.getValue("name");
        if (!XMLUtils.isWellFormedXMLName(name)) {
            throw new SAXException("'" + name + "' would not be a well formed xml attribute name.");
        }
        descriptor.setQualifiedName(name);
        descriptor.setLocalName(name);
        String uri = attributes.getValue("uri");
        if (uri != null) {
            descriptor.setURI(uri);
        }
        String propertyName = attributes.getValue("property");
        descriptor.setPropertyName(propertyName);
        descriptor.setPropertyType(this.loadClass(attributes.getValue("type")));
        if (propertyName != null && propertyName.length() > 0) {
            this.configureDescriptor(descriptor);
        } else {
            String value = attributes.getValue("value");
            if (value != null) {
                descriptor.setTextExpression(new ConstantExpression(value));
            }
        }
        Object top = this.digester.peek();
        if (!(top instanceof ElementDescriptor)) {
            throw new SAXException("Invalid use of <attribute>. It should be nested inside an <element> element");
        }
        ElementDescriptor parent = (ElementDescriptor)top;
        parent.addAttributeDescriptor(descriptor);
        this.digester.push((Object)descriptor);
    }

    public void end() {
        Object top = this.digester.pop();
    }

    protected Class loadClass(String name) {
        if (name != null) {
            try {
                return this.classLoader.loadClass(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected void configureDescriptor(AttributeDescriptor attributeDescriptor) {
        block4: {
            Class beanClass = this.getBeanClass();
            if (beanClass != null) {
                String name = attributeDescriptor.getPropertyName();
                try {
                    BeanInfo beanInfo = Introspector.getBeanInfo(beanClass);
                    PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
                    if (descriptors == null) break block4;
                    int size = descriptors.length;
                    for (int i = 0; i < size; ++i) {
                        PropertyDescriptor descriptor = descriptors[i];
                        if (!name.equals(descriptor.getName())) continue;
                        XMLIntrospectorHelper.configureProperty(attributeDescriptor, descriptor);
                        this.getProcessedPropertyNameSet().add(name);
                        break;
                    }
                }
                catch (Exception e) {
                    log.warn((Object)"Caught introspection exception", (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

