/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.expression;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.betwixt.expression.Context;
import org.apache.commons.betwixt.expression.Expression;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.iterators.EnumerationIterator;

public class IteratorExpression
implements Expression {
    private Expression expression;

    public IteratorExpression(Expression expression) {
        this.expression = expression;
    }

    public Object evaluate(Context context) {
        Class<?> type;
        Object value = this.expression.evaluate(context);
        if (value instanceof Iterator) {
            return (Iterator)value;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.iterator();
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return map.entrySet().iterator();
        }
        if (value instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)value);
        }
        if (value != null && (type = value.getClass()).isArray()) {
            return new ArrayIterator(value);
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public void update(Context context, String newValue) {
    }

    public String toString() {
        return "IteratorExpression [expression=" + this.expression + "]";
    }
}

