/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.ButtonBase;
import com.google.gwt.user.client.ui.HasName;

public class CheckBox
extends ButtonBase
implements HasName {
    private static int uniqueId;
    private Element inputElem;
    private Element labelElem;

    public CheckBox() {
        this(DOM.createInputCheck());
        this.setStyleName("gwt-CheckBox");
    }

    public CheckBox(String label) {
        this();
        this.setText(label);
    }

    public CheckBox(String label, boolean asHTML) {
        this();
        if (asHTML) {
            this.setHTML(label);
        } else {
            this.setText(label);
        }
    }

    protected CheckBox(Element elem) {
        super(DOM.createSpan());
        this.inputElem = elem;
        this.labelElem = DOM.createLabel();
        DOM.sinkEvents(this.inputElem, DOM.getEventsSunk(this.getElement()));
        DOM.sinkEvents(this.getElement(), 0);
        DOM.appendChild(this.getElement(), this.inputElem);
        DOM.appendChild(this.getElement(), this.labelElem);
        String uid = "check" + ++uniqueId;
        DOM.setElementProperty(this.inputElem, "id", uid);
        DOM.setElementProperty(this.labelElem, "htmlFor", uid);
    }

    public String getHTML() {
        return DOM.getInnerHTML(this.labelElem);
    }

    public String getName() {
        return DOM.getElementProperty(this.inputElem, "name");
    }

    public int getTabIndex() {
        return CheckBox.getFocusImpl().getTabIndex(this.inputElem);
    }

    public String getText() {
        return DOM.getInnerText(this.labelElem);
    }

    public boolean isChecked() {
        String propName = this.isAttached() ? "checked" : "defaultChecked";
        return DOM.getElementPropertyBoolean(this.inputElem, propName);
    }

    public boolean isEnabled() {
        return !DOM.getElementPropertyBoolean(this.inputElem, "disabled");
    }

    public void setAccessKey(char key) {
        DOM.setElementProperty(this.inputElem, "accessKey", "" + key);
    }

    public void setChecked(boolean checked) {
        DOM.setElementPropertyBoolean(this.inputElem, "checked", checked);
        DOM.setElementPropertyBoolean(this.inputElem, "defaultChecked", checked);
    }

    public void setEnabled(boolean enabled) {
        DOM.setElementPropertyBoolean(this.inputElem, "disabled", !enabled);
    }

    public void setFocus(boolean focused) {
        if (focused) {
            CheckBox.getFocusImpl().focus(this.inputElem);
        } else {
            CheckBox.getFocusImpl().blur(this.inputElem);
        }
    }

    public void setHTML(String html) {
        DOM.setInnerHTML(this.labelElem, html);
    }

    public void setName(String name) {
        DOM.setElementProperty(this.inputElem, "name", name);
    }

    public void setTabIndex(int index) {
        CheckBox.getFocusImpl().setTabIndex(this.inputElem, index);
    }

    public void setText(String text) {
        DOM.setInnerText(this.labelElem, text);
    }

    protected void onLoad() {
        DOM.setEventListener(this.inputElem, this);
    }

    protected void onUnload() {
        DOM.setEventListener(this.inputElem, null);
        this.setChecked(this.isChecked());
    }

    protected void replaceInputElement(Element elem) {
        int tabIndex = this.getTabIndex();
        boolean checked = this.isChecked();
        boolean enabled = this.isEnabled();
        String uid = DOM.getElementProperty(this.inputElem, "id");
        String accessKey = DOM.getElementProperty(this.inputElem, "accessKey");
        this.setChecked(false);
        DOM.setElementProperty(this.inputElem, "id", "");
        DOM.setElementProperty(this.inputElem, "accessKey", "");
        DOM.removeChild(this.getElement(), this.inputElem);
        DOM.insertChild(this.getElement(), elem, 0);
        this.inputElem = elem;
        DOM.sinkEvents(this.inputElem, DOM.getEventsSunk(this.getElement()));
        DOM.setEventListener(this.inputElem, this);
        DOM.setElementProperty(this.inputElem, "id", uid);
        if (accessKey != "") {
            DOM.setElementProperty(this.inputElem, "accessKey", accessKey);
        }
        this.setTabIndex(tabIndex);
        this.setChecked(checked);
        this.setEnabled(enabled);
    }
}

