/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.MouseListener;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Iterator;

public class MouseListenerCollection
extends ArrayList {
    public void fireMouseDown(Widget sender, int x, int y) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            MouseListener listener = (MouseListener)it.next();
            listener.onMouseDown(sender, x, y);
        }
    }

    public void fireMouseEnter(Widget sender) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            MouseListener listener = (MouseListener)it.next();
            listener.onMouseEnter(sender);
        }
    }

    public void fireMouseEvent(Widget sender, Event event) {
        Element senderElem = sender.getElement();
        int x = DOM.eventGetClientX(event) - DOM.getAbsoluteLeft(senderElem) + DOM.getElementPropertyInt(senderElem, "scrollLeft") + Window.getScrollLeft();
        int y = DOM.eventGetClientY(event) - DOM.getAbsoluteTop(senderElem) + DOM.getElementPropertyInt(senderElem, "scrollTop") + Window.getScrollTop();
        switch (DOM.eventGetType(event)) {
            case 4: {
                this.fireMouseDown(sender, x, y);
                break;
            }
            case 8: {
                this.fireMouseUp(sender, x, y);
                break;
            }
            case 64: {
                this.fireMouseMove(sender, x, y);
                break;
            }
            case 16: {
                Element from = DOM.eventGetFromElement(event);
                if (DOM.isOrHasChild(senderElem, from)) break;
                this.fireMouseEnter(sender);
                break;
            }
            case 32: {
                Element to = DOM.eventGetToElement(event);
                if (DOM.isOrHasChild(senderElem, to)) break;
                this.fireMouseLeave(sender);
            }
        }
    }

    public void fireMouseLeave(Widget sender) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            MouseListener listener = (MouseListener)it.next();
            listener.onMouseLeave(sender);
        }
    }

    public void fireMouseMove(Widget sender, int x, int y) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            MouseListener listener = (MouseListener)it.next();
            listener.onMouseMove(sender, x, y);
        }
    }

    public void fireMouseUp(Widget sender, int x, int y) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            MouseListener listener = (MouseListener)it.next();
            listener.onMouseUp(sender, x, y);
        }
    }
}

