/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.core.client.JavaScriptObject;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

class PrefixTree
extends AbstractCollection {
    protected final int prefixLength;
    protected JavaScriptObject suffixes;
    protected JavaScriptObject subtrees;
    protected int size = 0;

    protected static PrefixTree createPrefixTree(int prefixLength) {
        return new PrefixTree(prefixLength);
    }

    private static String safe(String s) {
        return ':' + s;
    }

    private static String unsafe(String s) {
        return s.substring(1);
    }

    public PrefixTree() {
        this(2, null);
    }

    public PrefixTree(Collection source) {
        this(2, source);
    }

    public PrefixTree(int prefixLength) {
        this(prefixLength, null);
    }

    public PrefixTree(int prefixLength, Collection source) {
        this.prefixLength = prefixLength;
        this.clear();
        if (source != null) {
            this.addAll(source);
        }
    }

    public boolean add(Object o) throws UnsupportedOperationException {
        if (o instanceof String) {
            return this.add((String)o);
        }
        throw new UnsupportedOperationException("Cannot add non-Strings to PrefixTree");
    }

    public native boolean add(String var1);

    public native void clear();

    public boolean contains(Object o) {
        if (o instanceof String) {
            return this.contains((String)o);
        }
        return false;
    }

    public boolean contains(String s) {
        return this.getSuggestions(s, 1).contains(s);
    }

    public List getSuggestions(String search, int limit) {
        ArrayList toReturn = new ArrayList();
        if (search != null && limit > 0) {
            this.suggestImpl(search, "", toReturn, limit);
        }
        return toReturn;
    }

    public Iterator iterator() {
        return new PrefixTreeIterator(this);
    }

    public int size() {
        return this.size;
    }

    protected native void suggestImpl(String var1, String var2, Collection var3, int var4);

    private void dump(Collection output, String prefix) {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            output.add(prefix + (String)i.next());
        }
    }

    private static class PrefixTreeIterator
    implements Iterator {
        private JavaScriptObject stack;

        public PrefixTreeIterator(PrefixTree tree) {
            this.init();
            this.addTree(tree, "");
        }

        public boolean hasNext() {
            return this.nextImpl(true) != null;
        }

        public Object next() {
            Object toReturn = this.nextImpl(false);
            if (toReturn == null) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements in the iterator");
                }
                throw new RuntimeException("nextImpl() returned null, but hasNext says otherwise");
            }
            return toReturn;
        }

        public void remove() {
            throw new UnsupportedOperationException("PrefixTree does not support removal.  Use clear()");
        }

        private native void addTree(PrefixTree var1, String var2);

        private native void init();

        private native Object nextImpl(boolean var1);
    }
}

