/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.util.Map;

public class StandardSerializationPolicy
extends SerializationPolicy {
    private final Map whitelist;

    public StandardSerializationPolicy(Map whitelist) {
        if (whitelist == null) {
            throw new NullPointerException("whitelist");
        }
        this.whitelist = whitelist;
    }

    public boolean shouldDeserializeFields(Class clazz) {
        return this.isFieldSerializable(clazz);
    }

    public boolean shouldSerializeFields(Class clazz) {
        return this.isFieldSerializable(clazz);
    }

    public void validateDeserialize(Class clazz) throws SerializationException {
        if (!this.isInstantiable(clazz)) {
            throw new SerializationException("Type '" + clazz.getName() + "' was not included in the set of types which can be deserialized by this SerializationPolicy. For security purposes, this type will not be deserialized.");
        }
    }

    public void validateSerialize(Class clazz) throws SerializationException {
        if (!this.isInstantiable(clazz)) {
            throw new SerializationException("Type '" + clazz.getName() + "' was not included in the set of types which can be serialized by this SerializationPolicy. For security purposes, this type will not be serialized.");
        }
    }

    private boolean isFieldSerializable(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return this.whitelist.containsKey(clazz);
    }

    private boolean isInstantiable(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        Boolean instantiable = (Boolean)this.whitelist.get(clazz);
        return instantiable != null && instantiable != false;
    }
}

