/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.soap.MimeHeader;

public class MimeHeaders {
    private LinkedList headers = new LinkedList();

    public void addHeader(String name, String value) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid null or empty header name");
        }
        MimeHeader header = new MimeHeader(name, value);
        this.headers.add(header);
    }

    public Iterator getAllHeaders() {
        return this.headers.iterator();
    }

    public String[] getHeader(String name) {
        ArrayList<String> tmp = new ArrayList<String>();
        for (int n = 0; n < this.headers.size(); ++n) {
            MimeHeader mh = (MimeHeader)this.headers.get(n);
            if (!mh.getName().equalsIgnoreCase(name)) continue;
            tmp.add(mh.getValue());
        }
        String[] values = null;
        if (tmp.size() > 0) {
            values = new String[tmp.size()];
            tmp.toArray(values);
        }
        return values;
    }

    public Iterator getMatchingHeaders(String[] names) {
        MatchingIter iter = new MatchingIter(this.headers, names, true);
        return iter;
    }

    public Iterator getNonMatchingHeaders(String[] names) {
        MatchingIter iter = new MatchingIter(this.headers, names, false);
        return iter;
    }

    public void removeAllHeaders() {
        this.headers.clear();
    }

    public void removeHeader(String name) {
        Iterator iter = this.headers.iterator();
        while (iter.hasNext()) {
            MimeHeader mh = (MimeHeader)iter.next();
            if (!mh.getName().equalsIgnoreCase(name)) continue;
            iter.remove();
        }
    }

    public void setHeader(String name, String value) {
        boolean didSet = false;
        for (int n = 0; n < this.headers.size(); ++n) {
            MimeHeader mh = (MimeHeader)this.headers.get(n);
            if (!mh.getName().equalsIgnoreCase(name)) continue;
            if (didSet) {
                this.headers.remove(n);
                --n;
                continue;
            }
            mh = new MimeHeader(name, value);
            this.headers.set(n, mh);
            didSet = true;
        }
        if (!didSet) {
            this.addHeader(name, value);
        }
    }

    private static class MatchingIter
    implements Iterator {
        private LinkedList headers;
        private HashSet names;
        private boolean match;
        private int index;
        private MimeHeader mh;

        MatchingIter(LinkedList headers, String[] names, boolean match) {
            this.headers = headers;
            this.index = 0;
            this.names = new HashSet();
            for (int n = 0; n < names.length; ++n) {
                this.names.add(names[n].toLowerCase());
            }
            this.match = match;
        }

        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this.index < this.headers.size();
            while (hasNext) {
                this.mh = (MimeHeader)this.headers.get(this.index);
                ++this.index;
                String name = this.mh.getName().toLowerCase();
                if (this.names.contains(name) == this.match) break;
                hasNext = this.index < this.headers.size();
            }
            return hasNext;
        }

        public Object next() {
            return this.mh;
        }

        public void remove() {
            this.headers.remove(this.index - 1);
        }
    }
}

