/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.tc5.session;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.catalina.Manager;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.StringManager;
import org.jboss.ha.httpsession.interfaces.SerializableHttpSession;
import org.jboss.logging.Logger;
import org.jboss.web.tomcat.tc5.session.AbstractJBossManager;
import org.jboss.web.tomcat.tc5.session.JBossManagerCMP;

class ClusteredSessionCMP
extends StandardSession
implements SerializableHttpSession {
    private static final long serialVersionUID = -758573655613558722L;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$web$tomcat$tc5$session$ClusteredSessionCMP == null ? (class$org$jboss$web$tomcat$tc5$session$ClusteredSessionCMP = ClusteredSessionCMP.class$("org.jboss.web.tomcat.tc5.session.ClusteredSessionCMP")) : class$org$jboss$web$tomcat$tc5$session$ClusteredSessionCMP));
    protected static final String info = "ClusteredSessionCMP/1.0";
    private transient Manager manager = null;
    private static StringManager sm = StringManager.getManager((String)"org.jboss.web.tomcat.session");
    protected transient boolean isSessionModifiedSinceLastSave = true;
    protected transient int replicationType = 0;
    protected transient boolean replicationTypeAlreadySet = false;
    static /* synthetic */ Class class$org$jboss$web$tomcat$tc5$session$ClusteredSessionCMP;

    public ClusteredSessionCMP(JBossManagerCMP manager) {
        super((Manager)manager);
        this.manager = manager;
    }

    protected void initAfterLoad(JBossManagerCMP manager) {
        this.setManager(manager);
        this.expiring = false;
        this.listeners = new ArrayList();
        this.notes = new HashMap();
        this.support = new PropertyChangeSupport((Object)this);
        this.replicationType = manager.getReplicationType();
        this.replicationTypeAlreadySet = false;
        this.activate();
    }

    public boolean areAttributesModified(SerializableHttpSession previousVersion) {
        if (this == previousVersion) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Are current session " + this.id + " attributes modified? : " + this.isSessionModifiedSinceLastSave));
            }
            return this.isSessionModifiedSinceLastSave;
        }
        return true;
    }

    public long getContentCreationTime() {
        return this.getCreationTime();
    }

    public long getContentLastAccessTime() {
        return this.getLastAccessedTime();
    }

    public void sessionHasBeenStored() {
        this.isSessionModifiedSinceLastSave = false;
        this.replicationTypeAlreadySet = false;
    }

    public int getReplicationTypeForSession() {
        return this.replicationType;
    }

    public void setReplicationTypeForSession(int type) {
        this.replicationType = type;
    }

    public boolean isReplicationTypeAlreadySet() {
        return this.replicationTypeAlreadySet;
    }

    public void setCreationTime(long time) {
        super.setCreationTime(time);
        this.sessionIsDirty();
    }

    public void setPrincipal(Principal principal) {
        Principal oldPrincipal = this.principal;
        this.principal = principal;
        this.support.firePropertyChange("principal", oldPrincipal, this.principal);
        if (oldPrincipal != null && !((Object)oldPrincipal).equals(principal) || oldPrincipal == null && principal != null) {
            this.sessionIsDirty();
        }
    }

    public void setManager(Manager manager) {
        super.setManager(manager);
        this.manager = manager;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ClusteredSessionCMP[");
        sb.append(this.id);
        sb.append("]");
        return sb.toString();
    }

    public void access() {
        super.access();
        if (!((JBossManagerCMP)this.manager).isUseLocalCache()) {
            this.sessionIsDirty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        if (!this.isValid) {
            throw new IllegalStateException(sm.getString("clusteredSession.getAttribute.ise"));
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            Object result = this.attributes.get(name);
            if (result != null) {
                int invalidationPolicy = ((AbstractJBossManager)this.manager).getInvalidateSessionPolicy();
                if (invalidationPolicy == 1) {
                    this.sessionIsDirty();
                } else if (!(invalidationPolicy != 2 || result instanceof String || result instanceof Integer || result instanceof Long || result instanceof Byte || result instanceof Short || result instanceof Float || result instanceof Double || result instanceof Character || result instanceof Boolean)) {
                    this.sessionIsDirty();
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name, boolean notify) {
        boolean found = false;
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            found = this.attributes.containsKey(name);
            if (!found) {
                return;
            }
            this.sessionIsDirty();
        }
        super.removeAttribute(name, notify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        if (!this.isValid()) {
            throw new IllegalStateException(sm.getString("standardSession.getAttributeNames.ise"));
        }
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            HashSet keys = new HashSet(this.attributes.keySet());
            Enumerator iter = new Enumerator(keys);
            return iter;
        }
    }

    public void setAttribute(String name, Object value) {
        super.setAttribute(name, value);
        this.sessionIsDirty();
    }

    protected void log(String message) {
        log.debug((Object)message);
    }

    protected void log(String message, Throwable throwable) {
        log.error((Object)message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeObject(ObjectOutputStream out) throws IOException {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            out.defaultWriteObject();
        }
    }

    protected void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    protected void sessionIsDirty() {
        this.isSessionModifiedSinceLastSave = true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

